/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.dita.topic.table;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.text.Position;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.dita.DITAAccess;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorOperationStoppedByUserException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.schemaaware.SchemaAwareHandlerResult;
import ro.sync.ecss.extensions.api.webapp.WebappRestSafe;
import ro.sync.ecss.extensions.commons.operations.CommonsOperationsUtil;
import ro.sync.ecss.extensions.commons.table.operations.AbstractTableOperation;
import ro.sync.ecss.extensions.commons.table.operations.AuthorTableHelper;
import ro.sync.ecss.extensions.commons.table.operations.InsertTableCellsContentConstants;
import ro.sync.ecss.extensions.commons.table.operations.InsertTableOperationBase;
import ro.sync.ecss.extensions.commons.table.operations.TableCustomizerConstants;
import ro.sync.ecss.extensions.commons.table.operations.TableInfo;
import ro.sync.ecss.extensions.commons.table.operations.TableOperationsUtil;
import ro.sync.ecss.extensions.dita.topic.table.ECDITATableCustomizer;
import ro.sync.ecss.extensions.dita.topic.table.SADITATableCustomizer;
import ro.sync.exml.workspace.api.Platform;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible(value=false)
@WebappRestSafe
public class InsertTableOperation
implements AuthorOperation,
InsertTableOperationBase,
InsertTableCellsContentConstants {
    private static final String CHOICE_TABLE_MODEL = "choice";
    private static final String SIMPLE_TABLE_MODEL = "simple";
    private static final String CALS_TABLE_MODEL = "cals";
    private static final String PROPERTIES_TABLE_MODEL = "properties";
    private static final String NO_TABLE_MODEL = "none";
    private static final String DEFAULT_TABLE_MODEL_ARGUMENT_NAME = "defaultTableModel";
    public static final ArgumentDescriptor DEFAULT_TABLE_MODEL_ARGUMENT = new ArgumentDescriptor("defaultTableModel", 3, "The default model of the table that will be inserted.\nCan be: cals, simple, choice, properties or none.", new String[]{"cals", "simple", "choice", "properties", "none"}, "none");
    protected String cellContent = "";
    private int defaultTableModel = -1;
    private static final ArgumentDescriptor[] ARGUMENTS = new ArgumentDescriptor[]{CELL_FRAGMENT_ARGUMENT, DEFAULT_TABLE_MODEL_ARGUMENT, AbstractTableOperation.TABLE_INFO_ARGUMENT_DESCRIPTOR};
    private static final CommonsOperationsUtil.ConversionElementHelper CONVERSION_ELEMENT_CHECKER = new CommonsOperationsUtil.ConversionElementHelper(){

        @Override
        public boolean blockContentMustBeConverted(AuthorNode node, AuthorAccess authorAccess) throws AuthorOperationException {
            boolean canBeConverted = false;
            if (node instanceof AuthorElement) {
                AuthorElement element = (AuthorElement)node;
                AttrValue attribute = element.getAttribute("class");
                String clazz = attribute.getValue();
                boolean bl = canBeConverted = clazz != null && (clazz.contains(" topic/p ") || clazz.contains(" topic/li ") || clazz.contains(" topic/ul ") || clazz.contains(" topic/ol ") || clazz.contains(" topic/dlentry ") || clazz.contains(" topic/dl ") || clazz.contains(" topic/dt ") || clazz.contains(" topic/dd "));
            }
            if (!canBeConverted) {
                throw new AuthorOperationException(authorAccess.getAuthorResourceBundle().getMessage("table.convert.exception"));
            }
            return canBeConverted;
        }
    };

    public void doOperation(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        Object tableModelObj;
        Object cellFragmentObj = args.getArgumentValue("cellFragment");
        if (cellFragmentObj instanceof String) {
            this.cellContent = (String)cellFragmentObj;
        }
        if (this.cellContent == null) {
            this.cellContent = "";
        }
        if ((tableModelObj = args.getArgumentValue(DEFAULT_TABLE_MODEL_ARGUMENT_NAME)) instanceof String) {
            String tableModelStr = (String)tableModelObj;
            if (CALS_TABLE_MODEL.equals(tableModelStr)) {
                this.defaultTableModel = 1;
            } else if (SIMPLE_TABLE_MODEL.equals(tableModelStr)) {
                this.defaultTableModel = 3;
            } else if (CHOICE_TABLE_MODEL.equals(tableModelStr)) {
                this.defaultTableModel = 4;
            } else if (PROPERTIES_TABLE_MODEL.equals(tableModelStr)) {
                this.defaultTableModel = 5;
            } else if (NO_TABLE_MODEL.equals(tableModelStr)) {
                this.defaultTableModel = -1;
            }
        }
        AuthorDocumentFragment[] fragments = null;
        ArrayList<Map<String, String>> attributes = null;
        List<CommonsOperationsUtil.SelectedFragmentInfo> selectedFrags = CommonsOperationsUtil.getSelectedFragmentsForConversions(authorAccess, CONVERSION_ELEMENT_CHECKER);
        if (selectedFrags != null) {
            fragments = new AuthorDocumentFragment[selectedFrags.size()];
            attributes = new ArrayList<Map<String, String>>(selectedFrags.size());
            for (int i = 0; i < selectedFrags.size(); ++i) {
                CommonsOperationsUtil.SelectedFragmentInfo currentFrag = selectedFrags.get(i);
                fragments[i] = currentFrag.getSelectedFragment();
                attributes.add(currentFrag.getAttributes());
            }
        }
        Object tableInfoObj = args.getArgumentValue("table_info");
        int minRows = fragments != null ? fragments.length : 0;
        TableInfo tableInfo = tableInfoObj != null ? new TableInfo((Map)tableInfoObj, minRows) : null;
        this.insertTable(fragments, attributes, false, authorAccess, null, null, tableInfo);
    }

    private void addTableBody(StringBuilder tableXMLFragment, TableInfo tableInfo, AuthorDocumentFragment[] fragments, List<Map<String, String>> rowAttributes, boolean cellsFragments, String namespace, AuthorAccess authorAccess, AuthorTableHelper tableHelper, String rowElName, String entryElName) throws AuthorOperationException {
        String tbodyElName = DITAAccess.getPossibleElementQName((AuthorDocumentController)authorAccess.getDocumentController(), (String)" topic/tbody ", (String)"tbody");
        tableXMLFragment.append("<").append(tbodyElName).append(">");
        for (int i = 0; i < tableInfo.getRowsNumber(); ++i) {
            Map<String, String> map;
            tableXMLFragment.append("<").append(rowElName);
            if (rowAttributes != null && i < rowAttributes.size() && (map = rowAttributes.get(i)) != null) {
                Set<String> keySet = map.keySet();
                for (String attrName : keySet) {
                    tableXMLFragment.append(" ").append(attrName).append("=").append("\"").append(map.get(attrName)).append("\"");
                }
            }
            tableXMLFragment.append(">");
            for (int j = 0; j < tableInfo.getColumnsNumber(); ++j) {
                if (j == 0 && fragments != null) {
                    String cellXMLFragment = TableOperationsUtil.createCellXMLFragment(authorAccess, fragments, cellsFragments, entryElName, i, namespace, tableHelper, new String[0]);
                    tableXMLFragment.append(cellXMLFragment);
                    continue;
                }
                tableXMLFragment.append("<").append(entryElName).append(">");
                tableXMLFragment.append(this.cellContent);
                tableXMLFragment.append("</").append(entryElName).append(">");
            }
            tableXMLFragment.append("</").append(rowElName).append(">");
        }
        tableXMLFragment.append("</").append(tbodyElName).append(">");
    }

    private void addTableHeader(StringBuilder tableXMLFragment, TableInfo tableInfo, AuthorAccess authorAccess, String rowElName, String entryElName) {
        if (tableInfo.isGenerateHeader()) {
            String theadElName = DITAAccess.getPossibleElementQName((AuthorDocumentController)authorAccess.getDocumentController(), (String)" topic/thead ", (String)"thead");
            tableXMLFragment.append("<").append(theadElName).append("><").append(rowElName).append(">");
            for (int i = 1; i <= tableInfo.getColumnsNumber(); ++i) {
                tableXMLFragment.append("<").append(entryElName).append(">");
                tableXMLFragment.append(this.cellContent);
                tableXMLFragment.append("</").append(entryElName).append(">");
            }
            tableXMLFragment.append("</").append(rowElName).append("></").append(theadElName).append(">");
        }
    }

    private void addSimpleTableBody(StringBuilder tableXMLFragment, TableInfo tableInfo, AuthorDocumentFragment[] fragments, List<Map<String, String>> rowAttributes, boolean cellsFragments, String namespace, AuthorAccess authorAccess, AuthorTableHelper tableHelper, String stentryElName) throws AuthorOperationException {
        String strowElName = DITAAccess.getPossibleElementQName((AuthorDocumentController)authorAccess.getDocumentController(), (String)" topic/strow ", (String)"strow");
        for (int i = 0; i < tableInfo.getRowsNumber(); ++i) {
            Map<String, String> map;
            tableXMLFragment.append("<").append(strowElName);
            if (rowAttributes != null && i < rowAttributes.size() && (map = rowAttributes.get(i)) != null) {
                Set<String> keySet = map.keySet();
                for (String attrName : keySet) {
                    tableXMLFragment.append(" ").append(attrName).append("=").append("\"").append(map.get(attrName)).append("\"");
                }
            }
            tableXMLFragment.append(">");
            for (int j = 0; j < tableInfo.getColumnsNumber(); ++j) {
                if (j == 0 && fragments != null && fragments.length > 0) {
                    String cellXMLFragment = TableOperationsUtil.createCellXMLFragment(authorAccess, fragments, cellsFragments, stentryElName, i, namespace, tableHelper, new String[0]);
                    tableXMLFragment.append(cellXMLFragment);
                    continue;
                }
                this.createCell(tableXMLFragment, stentryElName);
            }
            tableXMLFragment.append("</").append(strowElName).append(">");
        }
    }

    private void addChoiceTableBody(StringBuilder tableXMLFragment, TableInfo tableInfo, AuthorDocumentFragment[] fragments, List<Map<String, String>> rowAttributes, boolean cellsFragments, String namespace, AuthorAccess authorAccess, AuthorTableHelper tableHelper) throws AuthorOperationException {
        boolean isChoiceOptionColumn = false;
        if (fragments != null) {
            List contentNodes = fragments[0].getContentNodes();
            for (AuthorNode authorNode : contentNodes) {
                String value;
                AuthorElement authorElement;
                AttrValue classAttr;
                if (!(authorNode instanceof AuthorElement) || (classAttr = (authorElement = (AuthorElement)authorNode).getAttribute("class")) == null || !(value = classAttr.getValue()).contains(" task/choptionhd ")) continue;
                isChoiceOptionColumn = true;
                break;
            }
        }
        String chrowElName = DITAAccess.getPossibleElementQName((AuthorDocumentController)authorAccess.getDocumentController(), (String)" task/chrow ", (String)"chrow");
        String chdescElName = DITAAccess.getPossibleElementQName((AuthorDocumentController)authorAccess.getDocumentController(), (String)" task/chdesc ", (String)"chdesc");
        String choptionElName = DITAAccess.getPossibleElementQName((AuthorDocumentController)authorAccess.getDocumentController(), (String)" task/choption ", (String)"choption");
        for (int i = 0; i < tableInfo.getRowsNumber(); ++i) {
            Map<String, String> map;
            tableXMLFragment.append("<").append(chrowElName);
            if (rowAttributes != null && i < rowAttributes.size() && (map = rowAttributes.get(i)) != null) {
                Set<String> keySet = map.keySet();
                for (String attrName : keySet) {
                    tableXMLFragment.append(" ").append(attrName).append("=").append("\"").append(map.get(attrName)).append("\"");
                }
            }
            tableXMLFragment.append(">");
            if (fragments != null) {
                String cellXMLFragment;
                if (isChoiceOptionColumn) {
                    cellXMLFragment = TableOperationsUtil.createCellXMLFragment(authorAccess, fragments, cellsFragments, choptionElName, i, namespace, tableHelper, new String[0]);
                    tableXMLFragment.append(cellXMLFragment);
                    this.createCell(tableXMLFragment, chdescElName);
                } else {
                    this.createCell(tableXMLFragment, choptionElName);
                    cellXMLFragment = TableOperationsUtil.createCellXMLFragment(authorAccess, fragments, cellsFragments, chdescElName, i, namespace, tableHelper, new String[0]);
                    tableXMLFragment.append(cellXMLFragment);
                }
            } else {
                this.createCell(tableXMLFragment, choptionElName);
                this.createCell(tableXMLFragment, chdescElName);
            }
            tableXMLFragment.append("</").append(chrowElName).append(">");
        }
    }

    private static void addSimpleTableColWidths(StringBuilder tableXMLFragment, TableInfo tableInfo) {
        int columnsNumber = tableInfo.getColumnsNumber();
        TableCustomizerConstants.ColumnWidthsType columnsWidthsType = tableInfo.getColumnsWidthsType();
        if (columnsNumber > 0 && columnsWidthsType != TableCustomizerConstants.ColumnWidthsType.DYNAMIC_COL_WIDTHS) {
            tableXMLFragment.append(" relcolwidth=\"");
            for (int i = 1; i <= columnsNumber; ++i) {
                tableXMLFragment.append("1*");
                if (i == columnsNumber) continue;
                tableXMLFragment.append(" ");
            }
            tableXMLFragment.append("\"");
        }
    }

    private void addSimpleTableHeader(StringBuilder tableXMLFragment, TableInfo tableInfo, AuthorAccess authorAccess, String stentryElName) {
        String stheadElName = DITAAccess.getPossibleElementQName((AuthorDocumentController)authorAccess.getDocumentController(), (String)" topic/sthead ", (String)"sthead");
        if (tableInfo.isGenerateHeader()) {
            tableXMLFragment.append("<").append(stheadElName).append(">");
            for (int i = 1; i <= tableInfo.getColumnsNumber(); ++i) {
                this.createCell(tableXMLFragment, stentryElName);
            }
            tableXMLFragment.append("</").append(stheadElName).append(">");
        }
    }

    private void addChoiceTableHeader(StringBuilder tableXMLFragment, TableInfo tableInfo, AuthorAccess authorAccess) {
        if (tableInfo.isGenerateHeader()) {
            String chheadElName = DITAAccess.getPossibleElementQName((AuthorDocumentController)authorAccess.getDocumentController(), (String)" task/chhead ", (String)"chhead");
            String chdeschdElName = DITAAccess.getPossibleElementQName((AuthorDocumentController)authorAccess.getDocumentController(), (String)" task/chdeschd ", (String)"chdeschd");
            String choptionhdElName = DITAAccess.getPossibleElementQName((AuthorDocumentController)authorAccess.getDocumentController(), (String)" task/choptionhd ", (String)"choptionhd");
            tableXMLFragment.append("<").append(chheadElName).append(">");
            this.createCell(tableXMLFragment, choptionhdElName);
            this.createCell(tableXMLFragment, chdeschdElName);
            tableXMLFragment.append("</").append(chheadElName).append(">");
        }
    }

    private static void addColSpecs(StringBuilder tableXMLFragment, TableInfo tableInfo, AuthorDocumentController authorDocumentController) {
        TableCustomizerConstants.ColumnWidthsType columnsWidthsType = tableInfo.getColumnsWidthsType();
        String colWidth = null;
        if (columnsWidthsType == TableCustomizerConstants.ColumnWidthsType.PROPORTIONAL_COL_WIDTHS) {
            colWidth = "1*";
        } else if (columnsWidthsType == TableCustomizerConstants.ColumnWidthsType.FIXED_COL_WIDTHS) {
            colWidth = "75pt";
        }
        String colspecElName = DITAAccess.getPossibleElementQName((AuthorDocumentController)authorDocumentController, (String)" topic/colspec ", (String)"colspec");
        for (int i = 1; i <= tableInfo.getColumnsNumber(); ++i) {
            tableXMLFragment.append("<" + colspecElName + " colnum=\"" + i + "\" colname=\"c" + i + "\"");
            if (colWidth != null) {
                tableXMLFragment.append(" colwidth=\"" + colWidth + "\"");
            }
            tableXMLFragment.append("/>");
        }
    }

    public ArgumentDescriptor[] getArguments() {
        return ARGUMENTS;
    }

    public String getDescription() {
        return "Insert a DITA table";
    }

    @Override
    public void insertTable(AuthorDocumentFragment[] fragments, boolean cellsFragments, AuthorAccess authorAccess, String namespace, AuthorTableHelper tableHelper, TableInfo tableInfo) throws AuthorOperationException {
        this.insertTable(fragments, null, cellsFragments, authorAccess, namespace, tableHelper, tableInfo);
    }

    public void insertTable(AuthorDocumentFragment[] fragments, List<Map<String, String>> rowAttributes, boolean cellsFragments, AuthorAccess authorAccess, String namespace, AuthorTableHelper tableHelper, TableInfo tableInfo) throws AuthorOperationException {
        StringBuilder tableXMLFragment;
        List<Position> emptyElementsPositions;
        if (tableInfo == null) {
            Platform platform;
            int rowsCount = -1;
            int columnsCount = -1;
            if (fragments != null) {
                rowsCount = fragments.length;
                columnsCount = 1;
            }
            if (Platform.STANDALONE == (platform = authorAccess.getWorkspaceAccess().getPlatform())) {
                tableInfo = SADITATableCustomizer.getInstance().customizeTable(authorAccess, rowsCount, columnsCount, this.defaultTableModel);
            } else if (Platform.ECLIPSE == platform) {
                tableInfo = ECDITATableCustomizer.getInstance().customizeTable(authorAccess, rowsCount, columnsCount, this.defaultTableModel);
            }
        }
        if (tableInfo != null) {
            emptyElementsPositions = CommonsOperationsUtil.removeCurrentSelection(authorAccess);
            tableXMLFragment = new StringBuilder();
            int columnsNumber = tableInfo.getColumnsNumber();
            if (tableInfo.getTableModel() == 5) {
                Object propertiesTableTag = "";
                String propertiesElName = DITAAccess.getPossibleElementQName((AuthorDocumentController)authorAccess.getDocumentController(), (String)" reference/properties ", (String)PROPERTIES_TABLE_MODEL);
                String tableFrameAttr = tableInfo.getFrame();
                propertiesTableTag = tableFrameAttr != null ? "<" + propertiesElName + " frame=\"" + tableFrameAttr + "\">" : "<" + propertiesElName + ">";
                tableXMLFragment.append((String)propertiesTableTag);
                this.addPropertiesTableHeader(tableXMLFragment, tableInfo, authorAccess);
                this.addPropertiesTableBody(tableXMLFragment, tableInfo, fragments, rowAttributes, cellsFragments, namespace, authorAccess, tableHelper);
                tableXMLFragment.append("</" + propertiesElName + ">");
            } else if (tableInfo.getTableModel() == 4) {
                Object choiceTableTag = "";
                String elName = DITAAccess.getPossibleElementQName((AuthorDocumentController)authorAccess.getDocumentController(), (String)" task/choicetable ", (String)"choicetable");
                String tableFrameAttr = tableInfo.getFrame();
                choiceTableTag = tableFrameAttr != null ? "<" + elName + " frame=\"" + tableFrameAttr + "\"" : "<" + elName + " ";
                tableXMLFragment.append((String)choiceTableTag);
                InsertTableOperation.addSimpleTableColWidths(tableXMLFragment, tableInfo);
                tableXMLFragment.append(">");
                this.addChoiceTableHeader(tableXMLFragment, tableInfo, authorAccess);
                this.addChoiceTableBody(tableXMLFragment, tableInfo, fragments, rowAttributes, cellsFragments, namespace, authorAccess, tableHelper);
                tableXMLFragment.append("</" + elName + ">");
            } else if (tableInfo.getTableModel() == 3) {
                Object simpleTableTag = "";
                String elName = DITAAccess.getPossibleElementQName((AuthorDocumentController)authorAccess.getDocumentController(), (String)" topic/simpletable ", (String)"simpletable");
                String tableFrameAttr = tableInfo.getFrame();
                simpleTableTag = tableFrameAttr != null ? "<" + elName + " frame=\"" + tableFrameAttr + "\"" : "<" + elName + " ";
                tableXMLFragment.append((String)simpleTableTag);
                InsertTableOperation.addSimpleTableColWidths(tableXMLFragment, tableInfo);
                tableXMLFragment.append(">");
                String stentryElName = DITAAccess.getPossibleElementQName((AuthorDocumentController)authorAccess.getDocumentController(), (String)" topic/stentry ", (String)"stentry");
                this.addSimpleTableHeader(tableXMLFragment, tableInfo, authorAccess, stentryElName);
                this.addSimpleTableBody(tableXMLFragment, tableInfo, fragments, rowAttributes, cellsFragments, namespace, authorAccess, tableHelper, stentryElName);
                tableXMLFragment.append("</" + elName + ">");
            } else {
                String tableFrameAttr = tableInfo.getFrame();
                String tableRowsep = tableInfo.getRowsep();
                String tableColsep = tableInfo.getColsep();
                String tableElName = DITAAccess.getPossibleElementQName((AuthorDocumentController)authorAccess.getDocumentController(), (String)" topic/table ", (String)"table");
                tableXMLFragment.append("<").append(tableElName);
                if (tableFrameAttr != null) {
                    tableXMLFragment.append(" frame=\"" + tableFrameAttr + "\"");
                }
                if (tableRowsep != null) {
                    tableXMLFragment.append(" rowsep=\"" + tableRowsep + "\"");
                }
                if (tableColsep != null) {
                    tableXMLFragment.append(" colsep=\"" + tableColsep + "\"");
                }
                tableXMLFragment.append(">");
                if (tableInfo.getTitle() != null) {
                    String titleElName = DITAAccess.getPossibleElementQName((AuthorDocumentController)authorAccess.getDocumentController(), (String)" topic/title ", (String)"title");
                    tableXMLFragment.append("<").append(titleElName).append(">").append(authorAccess.getXMLUtilAccess().escapeTextValue(tableInfo.getTitle())).append("</").append(titleElName).append(">");
                }
                String tgroupElName = DITAAccess.getPossibleElementQName((AuthorDocumentController)authorAccess.getDocumentController(), (String)" topic/tgroup ", (String)"tgroup");
                tableXMLFragment.append("<" + tgroupElName + " cols=\"" + columnsNumber + "\"");
                if (tableInfo.getAlign() != null) {
                    tableXMLFragment.append(" align=\"" + tableInfo.getAlign() + "\"");
                }
                tableXMLFragment.append(">");
                InsertTableOperation.addColSpecs(tableXMLFragment, tableInfo, authorAccess.getDocumentController());
                String rowElName = DITAAccess.getPossibleElementQName((AuthorDocumentController)authorAccess.getDocumentController(), (String)" topic/row ", (String)"row");
                String entryElName = DITAAccess.getPossibleElementQName((AuthorDocumentController)authorAccess.getDocumentController(), (String)" topic/entry ", (String)"entry");
                this.addTableHeader(tableXMLFragment, tableInfo, authorAccess, rowElName, entryElName);
                this.addTableBody(tableXMLFragment, tableInfo, fragments, rowAttributes, cellsFragments, namespace, authorAccess, tableHelper, rowElName, entryElName);
                tableXMLFragment.append("</" + tgroupElName + ">");
                tableXMLFragment.append("</").append(tableElName).append(">");
            }
        } else {
            throw new AuthorOperationStoppedByUserException("Cancelled by user");
        }
        SchemaAwareHandlerResult result = authorAccess.getDocumentController().insertXMLFragmentSchemaAware(tableXMLFragment.toString(), authorAccess.getEditorAccess().getCaretOffset());
        TableOperationsUtil.placeCaretInFirstCell(authorAccess, tableInfo, authorAccess.getDocumentController(), result);
        CommonsOperationsUtil.removeEmptyElements(authorAccess, emptyElementsPositions);
    }

    private void addPropertiesTableBody(StringBuilder tableXMLFragment, TableInfo tableInfo, AuthorDocumentFragment[] fragments, List<Map<String, String>> rowAttributes, boolean cellsFragments, String namespace, AuthorAccess authorAccess, AuthorTableHelper tableHelper) throws AuthorOperationException {
        String propertyElName = DITAAccess.getPossibleElementQName((AuthorDocumentController)authorAccess.getDocumentController(), (String)" reference/property ", (String)"property");
        String propTypeElName = DITAAccess.getPossibleElementQName((AuthorDocumentController)authorAccess.getDocumentController(), (String)" reference/proptype ", (String)"proptype");
        String propValueElName = null;
        if (tableInfo.getColumnsNumber() > 1) {
            propValueElName = DITAAccess.getPossibleElementQName((AuthorDocumentController)authorAccess.getDocumentController(), (String)" reference/propvalue ", (String)"propvalue");
        }
        String propDescElName = null;
        if (tableInfo.getColumnsNumber() > 2) {
            propDescElName = DITAAccess.getPossibleElementQName((AuthorDocumentController)authorAccess.getDocumentController(), (String)" reference/propdesc ", (String)"propdesc");
        }
        for (int i = 0; i < tableInfo.getRowsNumber(); ++i) {
            Map<String, String> map;
            tableXMLFragment.append("<").append(propertyElName);
            if (rowAttributes != null && i < rowAttributes.size() && (map = rowAttributes.get(i)) != null) {
                Set<String> keySet = map.keySet();
                for (String attrName : keySet) {
                    tableXMLFragment.append(" ").append(attrName).append("=").append("\"").append(map.get(attrName)).append("\"");
                }
            }
            tableXMLFragment.append(">");
            if (fragments != null && fragments.length > 0) {
                String cellXMLFragment = TableOperationsUtil.createCellXMLFragment(authorAccess, fragments, cellsFragments, propTypeElName, 0, namespace, tableHelper, new String[0]);
                tableXMLFragment.append(cellXMLFragment);
                if (propValueElName != null) {
                    cellXMLFragment = TableOperationsUtil.createCellXMLFragment(authorAccess, fragments, cellsFragments, propValueElName, 0, namespace, tableHelper, new String[0]);
                    tableXMLFragment.append(cellXMLFragment);
                }
                if (propDescElName != null) {
                    cellXMLFragment = TableOperationsUtil.createCellXMLFragment(authorAccess, fragments, cellsFragments, propDescElName, 0, namespace, tableHelper, new String[0]);
                    tableXMLFragment.append(cellXMLFragment);
                }
            } else {
                this.createCell(tableXMLFragment, propTypeElName);
                if (propValueElName != null) {
                    this.createCell(tableXMLFragment, propValueElName);
                }
                if (propDescElName != null) {
                    this.createCell(tableXMLFragment, propDescElName);
                }
            }
            tableXMLFragment.append("</").append(propertyElName).append(">");
        }
    }

    private void addPropertiesTableHeader(StringBuilder tableXMLFragment, TableInfo tableInfo, AuthorAccess authorAccess) {
        if (tableInfo.isGenerateHeader()) {
            String propHeadElName = DITAAccess.getPossibleElementQName((AuthorDocumentController)authorAccess.getDocumentController(), (String)" reference/prophead ", (String)"prophead");
            tableXMLFragment.append("<").append(propHeadElName).append(">");
            String propTypeHdElName = DITAAccess.getPossibleElementQName((AuthorDocumentController)authorAccess.getDocumentController(), (String)" reference/proptypehd ", (String)"proptypehd");
            String propvaluehdElName = null;
            if (tableInfo.getColumnsNumber() > 1) {
                propvaluehdElName = DITAAccess.getPossibleElementQName((AuthorDocumentController)authorAccess.getDocumentController(), (String)" reference/propvaluehd ", (String)"propvaluehd");
            }
            String propdeschdElName = null;
            if (tableInfo.getColumnsNumber() > 2) {
                propdeschdElName = DITAAccess.getPossibleElementQName((AuthorDocumentController)authorAccess.getDocumentController(), (String)" reference/propdeschd ", (String)"propdeschd");
            }
            this.createCell(tableXMLFragment, propTypeHdElName);
            if (propvaluehdElName != null) {
                this.createCell(tableXMLFragment, propvaluehdElName);
            }
            if (propdeschdElName != null) {
                this.createCell(tableXMLFragment, propdeschdElName);
            }
            tableXMLFragment.append("</").append(propHeadElName).append(">");
        }
    }

    private void createCell(StringBuilder xmlFragment, String elName) {
        xmlFragment.append("<").append(elName).append(">");
        xmlFragment.append(this.cellContent);
        xmlFragment.append("</").append(elName).append(">");
    }
}

