/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.dita.topic;

import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.dita.DITAAccess;
import ro.sync.ecss.dita.ImageInfo;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.webapp.WebappRestSafe;
import ro.sync.ecss.extensions.commons.ImageFileChooser;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible(value=false)
@WebappRestSafe
public class InsertImageOperation
implements AuthorOperation {
    public static final String ARGUMENT_IMAGE_URL = "imageUrl";
    private static final ArgumentDescriptor[] arguments = new ArgumentDescriptor[]{new ArgumentDescriptor("imageUrl", 0, "The URL of the image. If not defined, an image chooser will be shown.")};

    public void doOperation(AuthorAccess authorAccess, ArgumentsMap args) throws IllegalArgumentException, AuthorOperationException {
        Object imageUrl = args.getArgumentValue(ARGUMENT_IMAGE_URL);
        ImageInfo ref = null;
        ref = imageUrl instanceof String ? new ImageInfo("href", ImageFileChooser.makeUrlRelative(authorAccess, (String)imageUrl)) : DITAAccess.chooseImageReference((AuthorAccess)authorAccess);
        if (ref != null) {
            DITAAccess.insertImage((AuthorAccess)authorAccess, (ImageInfo)ref);
        }
    }

    public ArgumentDescriptor[] getArguments() {
        return arguments;
    }

    public String getDescription() {
        return "Insert a DITA image";
    }
}

