/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.dita.map.topicref.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.net.protocol.http.HttpExceptionWithDetails;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class FileProber {
    public Status exists(URL fileUrl) {
        Status status = Status.NOT_SURE;
        try {
            URLConnection connection = fileUrl.openConnection();
            try (InputStream inputStream = connection.getInputStream();){
                inputStream.read();
                status = Status.EXISTS;
            }
        }
        catch (FileNotFoundException e) {
            status = Status.NOT_EXISTS;
        }
        catch (HttpExceptionWithDetails e) {
            if (e.getReasonCode() == 404) {
                status = Status.NOT_EXISTS;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return status;
    }

    public static enum Status {
        EXISTS,
        NOT_EXISTS,
        NOT_SURE;

    }
}

