/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.dita.map.topicref;

import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.dita.DITAAccess;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.XPathVersion;
import ro.sync.ecss.extensions.api.access.AuthorEditorAccess;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorNode;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible
public class TopicrefMoveAction {
    private static final Logger logger = LoggerFactory.getLogger(TopicrefMoveAction.class);
    private String targetLocation;
    private String sourceLocation;
    private String relativePosition;
    private AuthorEditorAccess editor;
    private AuthorDocumentController controller;
    private NodeSupplier toMoveNodeLocator;

    private TopicrefMoveAction(Builder builder) {
        this.controller = builder.authorAccess.getDocumentController();
        this.editor = builder.authorAccess.getEditorAccess();
        this.sourceLocation = builder.sourceLocation;
        this.relativePosition = builder.relativePosition;
        this.targetLocation = builder.targetLocation;
        if (this.sourceLocation != null && !this.sourceLocation.trim().isEmpty()) {
            this.toMoveNodeLocator = this::locateNodeByXPath;
            this.targetLocation = this.sourceLocation + "/" + this.targetLocation;
        } else {
            this.toMoveNodeLocator = this::locateNodeAtCaret;
        }
    }

    public void execute() throws AuthorOperationException {
        try {
            AuthorNode toMoveNode = this.toMoveNodeLocator.get();
            if (logger.isDebugEnabled()) {
                logger.debug("To move node: " + toMoveNode);
            }
            boolean selectNode = false;
            if (this.editor.getFullySelectedNode() == toMoveNode) {
                selectNode = true;
            }
            AuthorNode movedNode = this.moveNode(toMoveNode);
            if (logger.isDebugEnabled()) {
                logger.debug("Moved node: " + movedNode);
            }
            if (selectNode) {
                this.editor.select(movedNode.getStartOffset(), movedNode.getEndOffset() + 1);
            } else {
                this.editor.setCaretPosition(movedNode.getEndOffset());
            }
        }
        catch (BadLocationException e) {
            throw new AuthorOperationException("Unable to move the element sourceLocation:" + this.sourceLocation + " relativePosition:" + this.relativePosition + " targetLocationXPath:" + this.targetLocation, (Throwable)e);
        }
    }

    private AuthorNode moveNode(AuthorNode toMoveNode) throws BadLocationException, AuthorOperationException {
        int insertionOffset = this.controller.getXPathLocationOffset(this.targetLocation, this.relativePosition, false);
        AuthorDocumentFragment frag = DITAAccess.getFragWithMostSuitableTopicrefs((AuthorDocumentController)this.controller, (AuthorNode)toMoveNode, (int)insertionOffset);
        this.controller.insertFragment(insertionOffset, frag);
        AuthorNode movedNode = this.controller.getNodeAtOffset(insertionOffset + 1);
        this.controller.deleteNode(toMoveNode);
        return movedNode;
    }

    private AuthorNode locateNodeByXPath() throws AuthorOperationException {
        AuthorNode toReturn = null;
        AuthorNode[] locatedNodes = this.controller.findNodesByXPath(this.sourceLocation, null, true, true, true, false, XPathVersion.XPATH_3_0, true);
        if (locatedNodes.length > 0) {
            if (locatedNodes.length > 1) {
                logger.error("More than one nodes identified by: " + this.sourceLocation + ". Only the first node will be processed");
            }
        } else {
            throw new AuthorOperationException("The XPath expression: " + this.sourceLocation + " - doesn't identify any node");
        }
        toReturn = locatedNodes[0];
        return toReturn;
    }

    private AuthorNode locateNodeAtCaret() throws BadLocationException {
        int caretOffset = this.editor.getCaretOffset();
        return this.controller.getNodeAtOffset(caretOffset);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String sourceLocation;
        private String targetLocation;
        private String relativePosition;
        private AuthorAccess authorAccess;

        public Builder sourceLocation(String sourceLocation) {
            this.sourceLocation = sourceLocation;
            return this;
        }

        public Builder relativePosition(String relativePosition) {
            this.relativePosition = relativePosition;
            return this;
        }

        public Builder targetLocation(String targetLocation) {
            this.targetLocation = targetLocation;
            return this;
        }

        public Builder authorAccess(AuthorAccess authorAccess) {
            this.authorAccess = authorAccess;
            return this;
        }

        public TopicrefMoveAction build() {
            if (this.authorAccess == null) {
                throw new IllegalArgumentException("authorAccess cannot be null");
            }
            if (this.targetLocation == null) {
                throw new IllegalArgumentException("targetLocation cannot be null");
            }
            if (this.relativePosition == null) {
                throw new IllegalArgumentException("relativePosition cannot be null");
            }
            return new TopicrefMoveAction(this);
        }
    }

    @FunctionalInterface
    private static interface NodeSupplier {
        public AuthorNode get() throws AuthorOperationException, BadLocationException;
    }
}

