/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.dita.map.topicref;

import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorOperationWithCustomUndoBehavior;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.webapp.WebappRestSafe;
import ro.sync.ecss.extensions.dita.map.topicref.HeavyViewModeOperation;
import ro.sync.ecss.extensions.dita.map.topicref.TopicTitlesViewModeOperation;
import ro.sync.exml.workspace.api.editor.page.author.actions.AuthorActionsProvider;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible(value=true)
@WebappRestSafe
public class TopicContentViewModeOperation
extends HeavyViewModeOperation
implements AuthorOperationWithCustomUndoBehavior {
    public static final String OXY_TOPIC_CONTENT_MODE = "-oxy-topic-content-mode";
    static final String REFRESH_REFERENCES_ACTION_ID = "Author/Refresh_references";

    public String getDescription() {
        return "This operation configures Topic Content view mode.";
    }

    @Override
    String getPseudoclass() {
        return OXY_TOPIC_CONTENT_MODE;
    }

    @Override
    void doOperationInternal(AuthorAccess authorAccess, boolean expand) throws AuthorOperationException {
        Object refreshRefsAction;
        AuthorDocumentController documentController = authorAccess.getDocumentController();
        AuthorElement rootElement = documentController.getAuthorDocumentNode().getRootElement();
        if (expand) {
            new TopicTitlesViewModeOperation().doOperation(authorAccess, false);
            documentController.setPseudoClassUndoable("-oxy-expand-refs", rootElement);
        } else {
            documentController.removePseudoClassUndoable("-oxy-expand-refs", rootElement);
        }
        AuthorActionsProvider actionsProvider = authorAccess.getEditorAccess().getActionsProvider();
        if (actionsProvider != null && (refreshRefsAction = actionsProvider.getAuthorCommonActions().get(REFRESH_REFERENCES_ACTION_ID)) != null) {
            actionsProvider.invokeAction(refreshRefsAction);
        }
    }
}

