/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.dita.map.topicref;

import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.basic.util.URLInfo;
import ro.sync.ecss.dita.DITAAccess;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.webapp.WebappRestSafe;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible(value=false)
@WebappRestSafe
public class InsertTopicrefOperation
implements AuthorOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)InsertTopicrefOperation.class.getName());
    public static final String ARGUMENT_TOPIC_URL = "topicUrl";
    public static final String ARGUMENT_TOPICREF_NAME = "topicrefName";

    public void doOperation(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        URL topicUrlObj = InsertTopicrefOperation.getTopicUrlFromArgs(args);
        if (topicUrlObj != null) {
            Object topicrefName = args.getArgumentValue(ARGUMENT_TOPICREF_NAME);
            if (topicrefName != null) {
                try {
                    URLInfo urlInfo = new URLInfo(topicUrlObj, "");
                    urlInfo.addCustomQueryParam(ARGUMENT_TOPICREF_NAME, (String)topicrefName);
                    topicUrlObj = urlInfo.getURL(true, true, true);
                }
                catch (MalformedURLException e) {
                    LOGGER.error((Object)e, (Throwable)e);
                }
            }
            DITAAccess.handleTopicRefInsertUrl((AuthorAccess)authorAccess, (URL)topicUrlObj);
        } else {
            DITAAccess.insertTopicref((AuthorAccess)authorAccess);
        }
    }

    private static URL getTopicUrlFromArgs(ArgumentsMap args) {
        Object topicUrl = args.getArgumentValue(ARGUMENT_TOPIC_URL);
        URL topicUrlObj = null;
        if (topicUrl instanceof String) {
            try {
                topicUrlObj = new URL((String)topicUrl);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return topicUrlObj;
    }

    public ArgumentDescriptor[] getArguments() {
        return null;
    }

    public String getDescription() {
        return "Insert a DITA topic reference";
    }
}

