/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.dita.map.topicref;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.sax.SAXSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.dita.ContextKeyManager;
import ro.sync.ecss.dita.ContextKeyManagerProvider;
import ro.sync.ecss.dita.DITAAccess;
import ro.sync.ecss.dita.Reference;
import ro.sync.ecss.dita.reference.keyref.KeyInfo;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.DITAMapReferencesResolver;
import ro.sync.ecss.extensions.api.ReferenceResolverException;
import ro.sync.ecss.extensions.api.ValidatingReferenceResolverException;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorDocument;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorDocumentProvider;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.node.AuthorReferenceNode;
import ro.sync.ecss.extensions.dita.conref.DITAConRefResolver;
import ro.sync.ecss.extensions.dita.conref.DITAXMLReaderWrapper;
import ro.sync.exml.workspace.api.util.XMLReaderWithGrammar;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class DITAMapRefResolver
extends DITAConRefResolver
implements DITAMapReferencesResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)DITAMapRefResolver.class.getName());
    private static final String ATTRIBUTE_KEYREF = "keyref";
    private static final String ATTRIBUTE_HREF = "href";
    private static final String ATTRIBUTE_SCOPE = "scope";
    private static final String ATTRIBUTE_FORMAT = "format";
    private static final String ATTRIBUTE_CLASS = "class";
    private static final String ATTRIBUTE_PROCESSING_ROLE = "processing-role";
    private boolean resolveAllTopicRefs = false;
    private Object grammarCache = null;
    private boolean isExpandMapReferences = true;

    @Deprecated
    public DITAMapRefResolver(ContextKeyManager keyManager) {
        super(keyManager);
    }

    public DITAMapRefResolver(ContextKeyManagerProvider keyManagerProvider) {
        super(keyManagerProvider);
    }

    @Deprecated
    public DITAMapRefResolver() {
        LOGGER.error("Deprecated no-arg constructor. Using it in Web Author will break key resolution");
    }

    @Override
    public boolean hasReferences(AuthorNode node) {
        boolean hasReferences = false;
        HrefInfo hrefInfo = this.getHrefInfo(node);
        if (hrefInfo.hrefValue != null) {
            hasReferences = this.resolveAllTopicRefs || this.isExpandMapReferences;
        } else if (!hrefInfo.isTopicref || hrefInfo.isContentReference) {
            hasReferences = super.hasReferences(node);
        }
        return hasReferences;
    }

    private static boolean isKeyReference(AuthorNode node) {
        AttrValue keyrefValue;
        AuthorElement element;
        AttrValue classValue;
        boolean keyRef = false;
        if (node.getType() == 0 && (classValue = (element = (AuthorElement)node).getAttribute(ATTRIBUTE_CLASS)) != null && classValue.getValue().contains(" map/topicref ") && (keyrefValue = element.getAttribute(ATTRIBUTE_KEYREF)) != null) {
            keyRef = true;
        }
        return keyRef;
    }

    HrefInfo getHrefInfo(AuthorNode node) {
        AuthorElement element;
        AttrValue classValue;
        HrefInfo info = new HrefInfo();
        String href = null;
        if (node.getType() == 0 && (classValue = (element = (AuthorElement)node).getAttribute(ATTRIBUTE_CLASS)) != null && classValue.getValue().contains(" map/topicref ")) {
            info.isTopicref = true;
            boolean bl = info.isContentReference = element.getAttribute("conref") != null || element.getAttribute("conkeyref") != null;
            if (!classValue.getValue().contains(" subjectScheme/subjectdef ")) {
                href = this.getHrefValue(element);
            }
        }
        info.hrefValue = href;
        return info;
    }

    private String getHrefValue(AuthorElement element) {
        AttrValue hrefValue;
        String href = null;
        String hrefValueStr = null;
        AttrValue keyrefValue = element.getAttribute(ATTRIBUTE_KEYREF);
        String inheritedFormat = null;
        String inheritedScope = null;
        if (keyrefValue != null) {
            KeyInfo keyInfo;
            String keyrefStrValue = keyrefValue.getValue();
            LinkedHashMap keys = DITAAccess.getKeys((URL)element.getXMLBaseURL(), (ContextKeyManager)this.keyManagerProvider.getContextKeyManager());
            keyrefStrValue = DITAAccess.rewriteKeyref((LinkedHashMap)DITAAccess.getURLKeyScopeContexts((URL)element.getXMLBaseURL(), (ContextKeyManager)this.keyManagerProvider.getContextKeyManager()), (LinkedHashMap)keys, (AuthorNode)element, (String)keyrefStrValue);
            if (keys != null && (keyInfo = (KeyInfo)keys.get(keyrefStrValue)) != null && keyInfo.getHrefLocation() != null) {
                hrefValueStr = keyInfo.getHrefLocation().toString();
                Map attrs = keyInfo.getAttributes();
                if (attrs != null) {
                    inheritedFormat = (String)attrs.get(ATTRIBUTE_FORMAT);
                    inheritedScope = (String)attrs.get(ATTRIBUTE_SCOPE);
                }
            }
        }
        if (hrefValueStr == null && (hrefValue = element.getAttribute(ATTRIBUTE_HREF)) != null) {
            hrefValueStr = hrefValue.getValue();
        }
        if (hrefValueStr != null) {
            String scopeStrValue;
            AttrValue scopeValue = element.getAttribute(ATTRIBUTE_SCOPE);
            String string = scopeStrValue = scopeValue == null ? inheritedScope : scopeValue.getValue();
            if (scopeStrValue == null || "local".equals(scopeStrValue)) {
                String formatStr;
                AttrValue resOnlyValue = element.getAttribute(ATTRIBUTE_PROCESSING_ROLE);
                String resOnlyStrValue = resOnlyValue == null ? null : resOnlyValue.getValue();
                boolean resourceOnly = "resource-only".equals(resOnlyStrValue);
                boolean resolve = false;
                boolean isTopicRef = false;
                boolean isMapRef = false;
                AttrValue formatValue = element.getAttribute(ATTRIBUTE_FORMAT);
                String string2 = formatStr = formatValue != null ? formatValue.getValue() : inheritedFormat;
                if (formatStr == null) {
                    isTopicRef = true;
                } else if ("dita".equals(formatStr)) {
                    isTopicRef = true;
                } else if ("ditamap".equals(formatStr)) {
                    isMapRef = true;
                }
                if (isMapRef || isTopicRef) {
                    resolve = this.resolveAllTopicRefs || element.getOwnerDocument().getRootElement().hasPseudoClass("-oxy-expand-refs") || element.getType() == 0 && element.hasPseudoClass("-oxy-expand-refs") ? !resourceOnly && !DITAMapRefResolver.isInRelTable((AuthorNode)element) : isMapRef;
                }
                if (resolve) {
                    href = hrefValueStr;
                }
            }
        }
        return href;
    }

    private static boolean isInRelTable(AuthorNode node) {
        String relcell = " map/reltable ";
        while (node != null) {
            AuthorElement elem;
            AttrValue classAttr;
            if (node.getType() == 0 && (classAttr = (elem = (AuthorElement)node).getAttribute(ATTRIBUTE_CLASS)) != null && classAttr.getValue().contains(relcell)) {
                return true;
            }
            node = node.getParent();
        }
        return false;
    }

    @Override
    public String getDisplayName(AuthorNode node) {
        HrefInfo hrefInfo = this.getHrefInfo(node);
        String displayName = hrefInfo.hrefValue;
        if (displayName == null && (!hrefInfo.isTopicref || hrefInfo.isContentReference)) {
            displayName = super.getDisplayName(node);
        }
        return displayName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public SAXSource resolveReference(AuthorNode node, String systemID, AuthorAccess authorAccess, EntityResolver entityResolver) {
        HrefInfo hrefInfo = this.getHrefInfo(node);
        String href = hrefInfo.hrefValue;
        SAXSource saxSource = null;
        if (href != null) {
            try {
                AttrValue clazz;
                Reference conRef = DITAAccess.parseDITAHref((String)systemID, (String)href, (boolean)true);
                if (conRef == null) return saxSource;
                InputSource inputSource = new InputSource(conRef.getUri());
                XMLReaderWithGrammar readerWithCache = authorAccess.getXMLUtilAccess().newNonValidatingXMLReader(this.grammarCache);
                XMLReader xmlReader = readerWithCache.getXmlReader();
                this.grammarCache = readerWithCache.getGrammarCache();
                xmlReader.setEntityResolver(entityResolver);
                String[] topicPath = this.getTopicPath(conRef.getTopicID());
                String sourceClass = null;
                if (node != null && node.getType() == 0 && (clazz = ((AuthorElement)node).getAttribute(ATTRIBUTE_CLASS)) != null) {
                    sourceClass = clazz.getValue();
                }
                xmlReader = new DITAXMLReaderWrapper(xmlReader, topicPath, null, sourceClass, DITAMapRefResolver.isKeyReference(node));
                return new SAXSource(xmlReader, inputSource);
            }
            catch (Exception e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.error((Object)e, (Throwable)e);
                }
                ReferenceResolverException rre = new ReferenceResolverException(e.getMessage(), false, false);
                rre.initCause((Throwable)e);
                throw rre;
            }
        }
        if (!hrefInfo.isTopicref) return super.resolveReference(node, systemID, authorAccess, entityResolver);
        if (!hrefInfo.isContentReference) return saxSource;
        return super.resolveReference(node, systemID, authorAccess, entityResolver);
    }

    public boolean hasEditableReference(String systemID, AuthorNode referenceNodeParent) {
        HrefInfo hrefInfo = this.getHrefInfo(referenceNodeParent);
        String href = hrefInfo.hrefValue;
        if (href != null) {
            try {
                Reference conRef = DITAAccess.parseDITAHref((String)systemID, (String)href, (boolean)true);
                if (conRef != null) {
                    return conRef.getTopicID() == null || conRef.getTopicID().isEmpty();
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean allowsValidatationForEditableReference(String systemID, AuthorNode referenceNodeParent) {
        return this.hasEditableReference(systemID, referenceNodeParent);
    }

    public void replaceReference(AuthorDocumentProvider targetProvider, AuthorAccess authorAccess, AuthorReferenceNode referenceNode) throws IOException {
        try {
            List contentNodes = referenceNode.getContentNodes();
            if (!contentNodes.isEmpty()) {
                AuthorNode newRootElement = (AuthorNode)contentNodes.get(0);
                AuthorDocumentFragment contentToSave = authorAccess.getDocumentController().createDocumentFragment(newRootElement.getStartOffset(), newRootElement.getEndOffset(), true);
                if (contentToSave != null) {
                    targetProvider.getAuthorDocumentController().replaceRoot(contentToSave);
                }
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public String getReferenceSystemID(AuthorNode node, AuthorAccess authorAccess) {
        Object systemID;
        block11: {
            HrefInfo hrefInfo = this.getHrefInfo(node);
            systemID = null;
            String href = hrefInfo.hrefValue;
            if (href != null) {
                block10: {
                    try {
                        Reference parseDITAHref = DITAAccess.parseDITAHref((String)(node.getXMLBaseURL() == null ? null : node.getXMLBaseURL().toString()), (String)href, (boolean)true);
                        if (parseDITAHref != null) {
                            systemID = parseDITAHref.getUri();
                            if (parseDITAHref.getTopicID() != null && parseDITAHref.getTopicID().length() > 0) {
                                systemID = (String)systemID + "#" + parseDITAHref.getTopicID();
                            }
                        }
                    }
                    catch (MalformedURLException e) {
                        if (!LOGGER.isDebugEnabled()) break block10;
                        LOGGER.debug((Object)e, (Throwable)e);
                    }
                }
                try {
                    if (systemID == null) {
                        systemID = new URL(node.getXMLBaseURL(), href).toString();
                    }
                    break block11;
                }
                catch (MalformedURLException e) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)e, (Throwable)e);
                    }
                    break block11;
                }
            }
            if (!hrefInfo.isTopicref || hrefInfo.isContentReference) {
                systemID = super.getReferenceSystemID(node, authorAccess);
            }
        }
        return systemID;
    }

    @Override
    public void checkTarget(AuthorNode node, AuthorDocument targetDocument) throws ValidatingReferenceResolverException {
        HrefInfo hrefInfo = this.getHrefInfo(node);
        if (hrefInfo.hrefValue == null && (!hrefInfo.isTopicref || hrefInfo.isContentReference)) {
            super.checkTarget(node, targetDocument);
        }
    }

    @Override
    public String getReferenceUniqueID(AuthorNode node) {
        HrefInfo hrefInfo = this.getHrefInfo(node);
        String id = hrefInfo.hrefValue;
        if (id == null && (!hrefInfo.isTopicref || hrefInfo.isContentReference)) {
            return super.getReferenceUniqueID(node);
        }
        return id;
    }

    @Override
    public boolean isReferenceChanged(AuthorNode node, String attributeName) {
        return ATTRIBUTE_HREF.equals(attributeName) || ATTRIBUTE_SCOPE.equals(attributeName) || ATTRIBUTE_FORMAT.equals(attributeName) || ATTRIBUTE_PROCESSING_ROLE.equals(attributeName) || super.isReferenceChanged(node, attributeName);
    }

    public void setResolveAllTopicReferences(boolean resolveAllTopicRefs) {
        this.resolveAllTopicRefs = resolveAllTopicRefs;
    }

    public void setExpandMapReferences(boolean isExpand) {
        this.isExpandMapReferences = isExpand;
    }

    public Object getGrammarCache() {
        return this.grammarCache;
    }

    public void setGrammarCache(Object grammarCache) {
        this.grammarCache = grammarCache;
    }

    @Override
    public String getCacheKey(AuthorNode node) {
        String key = super.getCacheKey(node);
        if (key != null) {
            StringBuilder ksContexts = null;
            while (node != null) {
                AttrValue ks;
                if (node instanceof AuthorElement && (ks = ((AuthorElement)node).getAttribute("keyscope")) != null) {
                    if (ksContexts == null) {
                        ksContexts = new StringBuilder();
                    }
                    ksContexts.append("KS:").append(ks).append(" ");
                }
                node = node.getParent();
            }
            if (ksContexts != null) {
                ksContexts.append(key);
                key = ksContexts.toString();
            }
        }
        return key;
    }

    static class HrefInfo {
        private String hrefValue;
        private boolean isTopicref;
        private boolean isContentReference;

        HrefInfo() {
        }

        String getHrefValue() {
            return this.hrefValue;
        }

        boolean isTopicref() {
            return this.isTopicref;
        }
    }
}

