/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.dita.map;

import java.util.List;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorSchemaManager;
import ro.sync.ecss.extensions.api.InvalidEditException;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.dita.DITASchemaAwareEditingHandler;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class DITAMapSchemaAwareEditingHandler
extends DITASchemaAwareEditingHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)DITAMapSchemaAwareEditingHandler.class.getName());

    @Override
    public boolean handlePasteFragment(int offset, AuthorDocumentFragment[] fragmentsToInsert, int actionId, AuthorAccess authorAccess) throws InvalidEditException {
        try {
            AuthorElement elementAtOffset;
            AttrValue classAttr;
            AuthorNode nodeAtOffset;
            if (DITAMapSchemaAwareEditingHandler.areTopicRefsPasted(fragmentsToInsert) && (nodeAtOffset = authorAccess.getDocumentController().getNodeAtOffset(offset + 1)) instanceof AuthorElement && (classAttr = (elementAtOffset = (AuthorElement)nodeAtOffset).getAttribute("class")) != null && classAttr.getValue().contains(" map/topicmeta ")) {
                int insertionOffset = elementAtOffset.getEndOffset() + 1;
                AuthorSchemaManager authorSchemaManager = authorAccess.getDocumentController().getAuthorSchemaManager();
                DITAMapSchemaAwareEditingHandler.insertFragmentsIfValid(fragmentsToInsert, authorAccess, insertionOffset, authorSchemaManager);
                return true;
            }
        }
        catch (BadLocationException e) {
            logger.error((Object)e, (Throwable)e);
        }
        return super.handlePasteFragment(offset, fragmentsToInsert, actionId, authorAccess);
    }

    private static boolean areTopicRefsPasted(AuthorDocumentFragment[] fragmentsToInsert) {
        AuthorNode firstNode;
        AuthorDocumentFragment frag;
        List fragNodes;
        if (fragmentsToInsert != null && fragmentsToInsert.length > 0 && (fragNodes = (frag = fragmentsToInsert[0]).getContentNodes()) != null && !fragNodes.isEmpty() && (firstNode = (AuthorNode)fragNodes.get(0)) instanceof AuthorElement) {
            AuthorElement elem = (AuthorElement)firstNode;
            AttrValue classAttr = elem.getAttribute("class");
            return classAttr != null && classAttr.getValue().contains(" map/topicref ");
        }
        return false;
    }

    private static void insertFragmentsIfValid(AuthorDocumentFragment[] fragmentsToInsert, AuthorAccess authorAccess, int insertionOffset, AuthorSchemaManager authorSchemaManager) {
        boolean validResult;
        if (!authorSchemaManager.isLearnSchema() && !authorSchemaManager.hasLoadingErrors() && authorSchemaManager.getAuthorSchemaAwareOptions().isEnableSmartPaste() && (validResult = authorSchemaManager.canInsertDocumentFragments(fragmentsToInsert, insertionOffset, (short)4))) {
            for (int i = fragmentsToInsert.length - 1; i >= 0; --i) {
                authorAccess.getDocumentController().insertFragment(insertionOffset, fragmentsToInsert[i]);
            }
        }
    }
}

