/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.dita.map;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.basic.util.URLInfo;
import ro.sync.basic.util.URLUtil;
import ro.sync.ecss.dita.ContextKeyManagerProvider;
import ro.sync.ecss.dita.DITAAccess;
import ro.sync.ecss.dita.reference.keyref.KeyInfo;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.ReferenceType;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.dita.DITAExternalObjectInsertionHandler;
import ro.sync.ecss.extensions.dita.DITAExternalObjectInsertionHandlerUtil;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.util.UtilAccess;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class DITAMapExternalObjectInsertionHandler
extends DITAExternalObjectInsertionHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)DITAMapExternalObjectInsertionHandler.class.getName());
    private ContextKeyManagerProvider keyManagerProvider;
    private static final String TOPICREF_NAME_PARAM = "topicrefName";

    public DITAMapExternalObjectInsertionHandler() {
    }

    public DITAMapExternalObjectInsertionHandler(ContextKeyManagerProvider keyManagerProvider) {
        this.keyManagerProvider = keyManagerProvider;
    }

    @Override
    public void insertURLs(AuthorAccess authorAccess, List<URL> urls, List<ReferenceType> types, int source) throws AuthorOperationException {
        if (DITAMapExternalObjectInsertionHandler.isNodeAtOffsetOrItsAncestorTopic(authorAccess)) {
            super.insertURLs(authorAccess, urls, types, source);
        } else if (!urls.isEmpty()) {
            URL base = DITAMapExternalObjectInsertionHandler.getBaseURLAtCaretPosition((AuthorAccess)authorAccess);
            if (!urls.isEmpty()) {
                int cp = authorAccess.getEditorAccess().getCaretOffset();
                int newCp = DITAMapExternalObjectInsertionHandler.adjustCaretOffset(authorAccess, cp);
                if (newCp != cp) {
                    authorAccess.getEditorAccess().setCaretPosition(newCp);
                }
                AuthorNode contextNode = null;
                try {
                    contextNode = authorAccess.getDocumentController().getNodeAtOffset(cp);
                }
                catch (BadLocationException e) {
                    logger.error((Object)e, (Throwable)e);
                }
                StringBuilder toInsert = new StringBuilder();
                String tagName = DITAAccess.getAutoInsertTopicRefElementName((AuthorAccess)authorAccess, (int)cp);
                for (int i = 0; i < urls.size(); ++i) {
                    URL url = urls.get(i);
                    String computedTagName = tagName;
                    if (url.getQuery() != null && url.getQuery().contains(TOPICREF_NAME_PARAM)) {
                        try {
                            String paramValue;
                            URLInfo urlInfo = new URLInfo(url, "");
                            LinkedHashMap queryParams = urlInfo.getCustomQueryParameters();
                            if (queryParams != null && (paramValue = (String)queryParams.get(TOPICREF_NAME_PARAM)) != null && !paramValue.isEmpty()) {
                                computedTagName = paramValue;
                                urlInfo.removeCustomQueryParam(TOPICREF_NAME_PARAM);
                                url = urlInfo.getURL(true, true, true);
                            }
                        }
                        catch (MalformedURLException e) {
                            logger.error((Object)e, (Throwable)e);
                        }
                    }
                    if (source == 5) {
                        this.computeTopicrefForDnDFromDitaReusableComponents(authorAccess, toInsert, computedTagName, url);
                        continue;
                    }
                    String[] refData = DITAExternalObjectInsertionHandlerUtil.getReferenceAttributeNameAndValue(this.keyManagerProvider, authorAccess, base, url, contextNode);
                    String refAttrName = refData[0];
                    String refAttrValue = refData[1];
                    toInsert.append("<").append(computedTagName).append(" ").append(refAttrName).append("=\"").append(authorAccess.getXMLUtilAccess().escapeAttributeValue(DITAExternalObjectInsertionHandlerUtil.clearInternalQueryParamsFromExtractedRefAttrVal(base, refAttrValue))).append("\"");
                    if ("href".equals(refAttrName)) {
                        DITAMapExternalObjectInsertionHandler.addAttributesToTopicrefWithHref(authorAccess, computedTagName, types.get(i), toInsert, url);
                    }
                    toInsert.append("/>");
                }
                if (toInsert.length() > 0) {
                    authorAccess.getDocumentController().insertXMLFragmentSchemaAware(toInsert.toString(), authorAccess.getEditorAccess().getCaretOffset(), true);
                }
            }
        }
    }

    private static int adjustCaretOffset(AuthorAccess authorAccess, int cp) {
        AuthorElement rootElement = authorAccess.getDocumentController().getAuthorDocumentNode().getRootElement();
        if (rootElement != null && cp > rootElement.getEndOffset()) {
            cp = rootElement.getEndOffset();
        } else {
            try {
                AuthorElement elementAtOffset;
                AttrValue classAttr;
                AuthorNode nodeAtOffset = authorAccess.getDocumentController().getNodeAtOffset(cp + 1);
                if (nodeAtOffset instanceof AuthorElement && (classAttr = (elementAtOffset = (AuthorElement)nodeAtOffset).getAttribute("class")) != null && classAttr.getValue().contains(" map/topicmeta ")) {
                    cp = elementAtOffset.getEndOffset() + 1;
                }
            }
            catch (BadLocationException e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
        return cp;
    }

    private static void addAttributesToTopicrefWithHref(AuthorAccess authorAccess, String topicrefName, ReferenceType refType, StringBuilder stringBuilder, URL url) {
        PluginWorkspace pluginWS = PluginWorkspaceProvider.getPluginWorkspace();
        if (pluginWS != null) {
            boolean isAddKeysAttr = (Boolean)pluginWS.getGlobalObjectProperty("create.keys.attribute.for.topicref.based.on.filename");
            if (isAddKeysAttr && "ditamap".equals(authorAccess.getUtilAccess().getExtension(url))) {
                isAddKeysAttr = false;
            }
            if (isAddKeysAttr) {
                stringBuilder.append(" ").append("keys").append("=\"").append(DITAAccess.getKeysAttributeValueBasedOnFilename((URL)url)).append("\"");
            }
        }
        if (!"mapref".equals(topicrefName)) {
            stringBuilder.append(DITAAccess.computeFormatForURLPasteAndDnD((UtilAccess)authorAccess.getUtilAccess(), (URL)url, (ReferenceType)refType));
        }
    }

    private void computeTopicrefForDnDFromDitaReusableComponents(AuthorAccess authorAccess, StringBuilder stringBuilder, String tagName, URL url) throws AuthorOperationException {
        List keys = DITAAccess.getKeysForInsertion((URL)authorAccess.getEditorAccess().getEditorLocation());
        String keyref = URLUtil.getURLParameterValue((URL)url, (String)"FullyQualifiedKeyName");
        if (keyref != null) {
            KeyInfo key = null;
            for (KeyInfo keyInfo : keys) {
                if (!keyref.equals(keyInfo.getKeyName())) continue;
                key = keyInfo;
                break;
            }
            if (key != null) {
                if (key.getHrefValue() == null) {
                    String qName = DITAAccess.computeVariableKeyrefElementName((AuthorAccess)authorAccess);
                    if (qName != null) {
                        stringBuilder.append("<").append(qName).append(" keyref=\"").append(keyref).append("\"/>");
                    } else {
                        String possibleElementQName = DITAAccess.getPossibleElementQName((AuthorDocumentController)authorAccess.getDocumentController(), (String)" map/topicref ", (String)"topicref");
                        stringBuilder.append("<").append(possibleElementQName).append(" keyref=\"").append(keyref).append("\"/>");
                    }
                } else {
                    stringBuilder.append("<").append(tagName).append(" keyref=\"").append(keyref).append("\"/>");
                }
            }
        } else {
            DITAExternalObjectInsertionHandlerUtil.insertContentReference(this.keyManagerProvider, authorAccess, url);
        }
    }

    @Override
    public void insertURLs(AuthorAccess authorAccess, List<URL> urls, int source) throws AuthorOperationException {
        List<Object> types = Collections.nCopies(urls.size(), null);
        this.insertURLs(authorAccess, urls, types, source);
    }

    private static boolean isNodeAtOffsetOrItsAncestorTopic(AuthorAccess authorAccess) {
        try {
            for (AuthorNode node = authorAccess.getDocumentController().getNodeAtOffset(authorAccess.getEditorAccess().getCaretOffset()); node != null; node = node.getParent()) {
                String clazzVal;
                AuthorElement element;
                AttrValue clazz;
                if (node.getType() != 0 || (clazz = (element = (AuthorElement)node).getAttribute("class")) == null || (clazzVal = clazz.getValue()) == null || !clazzVal.contains(" topic/topic ")) continue;
                return true;
            }
        }
        catch (BadLocationException e) {
            logger.error((Object)e, (Throwable)e);
        }
        return false;
    }
}

