/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.dita.map;

import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.dita.DITAAccess;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorExtensionStateListener;
import ro.sync.ecss.extensions.api.AuthorExtensionStateListenerDelegator;
import ro.sync.ecss.extensions.api.AuthorExternalObjectInsertionHandler;
import ro.sync.ecss.extensions.api.AuthorPreloadProcessor;
import ro.sync.ecss.extensions.api.AuthorReferenceResolver;
import ro.sync.ecss.extensions.api.AuthorSchemaAwareEditingHandler;
import ro.sync.ecss.extensions.api.EditPropertiesHandler;
import ro.sync.ecss.extensions.api.link.ElementLocatorProvider;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.table.operations.AuthorTableOperationsHandler;
import ro.sync.ecss.extensions.api.text.TextPageExternalObjectInsertionHandler;
import ro.sync.ecss.extensions.dita.DITAElementLocatorProvider;
import ro.sync.ecss.extensions.dita.DITAExtensionsBundle;
import ro.sync.ecss.extensions.dita.map.DITAMapAuthorTableOperationsHandler;
import ro.sync.ecss.extensions.dita.map.DITAMapExternalObjectInsertionHandler;
import ro.sync.ecss.extensions.dita.map.DITAMapSchemaAwareEditingHandler;
import ro.sync.ecss.extensions.dita.map.DITAMapTextPageExternalObjectInsertionHandler;
import ro.sync.ecss.extensions.dita.map.DITAMapTopicTitlesResolveListener;
import ro.sync.ecss.extensions.dita.map.DITAMapVariableDetector;
import ro.sync.ecss.extensions.dita.map.topicref.DITAMapRefResolver;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class DITAMapExtensionsBundle
extends DITAExtensionsBundle {
    private DITAMapAuthorTableOperationsHandler ditaMapAuthorTableOperationsHandler = null;
    private DITAMapSchemaAwareEditingHandler ditaMapSchemaAwareEditingHandler;

    @Override
    public AuthorExtensionStateListener createAuthorExtensionStateListener() {
        AuthorExtensionStateListenerDelegator stateListenerDelegator = new AuthorExtensionStateListenerDelegator();
        stateListenerDelegator.addListener(super.createAuthorExtensionStateListener());
        stateListenerDelegator.addListener((AuthorExtensionStateListener)new DITAMapVariableDetector());
        stateListenerDelegator.addListener((AuthorExtensionStateListener)new DITAMapTopicTitlesResolveListener());
        return stateListenerDelegator;
    }

    public AuthorPreloadProcessor createAuthorPreloadProcessor() {
        return new DITAMapVariableDetector();
    }

    @Override
    public AuthorReferenceResolver createAuthorReferenceResolver() {
        return new DITAMapRefResolver(this.keyManagerProvider);
    }

    @Override
    public AuthorExternalObjectInsertionHandler createExternalObjectInsertionHandler() {
        return new DITAMapExternalObjectInsertionHandler(this.keyManagerProvider);
    }

    @Override
    public ElementLocatorProvider createElementLocatorProvider() {
        return new DITAElementLocatorProvider(true);
    }

    @Override
    public AuthorTableOperationsHandler getAuthorTableOperationsHandler() {
        if (this.ditaMapAuthorTableOperationsHandler == null) {
            this.ditaMapAuthorTableOperationsHandler = new DITAMapAuthorTableOperationsHandler();
        }
        return this.ditaMapAuthorTableOperationsHandler;
    }

    @Override
    public EditPropertiesHandler createEditPropertiesHandler() {
        return new EditPropertiesHandler(){

            public String getDescription() {
                return "Handles topicref editing";
            }

            public void editProperties(AuthorNode authorNode, AuthorAccess authorAccess) {
                DITAAccess.editTopicref((AuthorElement[])new AuthorElement[]{(AuthorElement)authorNode}, (AuthorAccess)authorAccess);
            }

            public boolean canEditProperties(AuthorNode authorNode) {
                boolean isHandled = false;
                if (authorNode.getType() == 0) {
                    AuthorElement element = (AuthorElement)authorNode;
                    AttrValue classAttr = element.getAttribute("class");
                    isHandled = classAttr != null && classAttr.getValue().contains(" map/topicref ");
                }
                return isHandled;
            }
        };
    }

    @Override
    public TextPageExternalObjectInsertionHandler createTextPageExternalObjectInsertionHandler() {
        return new DITAMapTextPageExternalObjectInsertionHandler();
    }

    @Override
    public String getHelpPageID(String currentEditorPage) {
        return "author-dita-map-doc-type";
    }

    @Override
    public AuthorSchemaAwareEditingHandler getAuthorSchemaAwareEditingHandler() {
        if (this.ditaMapSchemaAwareEditingHandler == null) {
            this.ditaMapSchemaAwareEditingHandler = new DITAMapSchemaAwareEditingHandler();
        }
        return this.ditaMapSchemaAwareEditingHandler;
    }
}

