/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.dita.map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.ContentInterval;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.table.operations.AuthorTableDeleteColumnArguments;
import ro.sync.ecss.extensions.api.table.operations.AuthorTableDeleteRowArguments;
import ro.sync.ecss.extensions.api.table.operations.AuthorTableDeleteRowsArguments;
import ro.sync.ecss.extensions.api.table.operations.AuthorTableInsertColumnArguments;
import ro.sync.ecss.extensions.api.table.operations.AuthorTableOperationsHandler;
import ro.sync.ecss.extensions.commons.table.operations.TableOperationsUtil;
import ro.sync.ecss.extensions.dita.map.table.DeleteColumnOperation;
import ro.sync.ecss.extensions.dita.map.table.DeleteRowOperation;
import ro.sync.ecss.extensions.dita.map.table.InsertColumnOperation;
import ro.sync.ecss.extensions.dita.map.table.InsertRowOperation;
import ro.sync.ecss.extensions.dita.map.table.InsertTableOperation;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class DITAMapAuthorTableOperationsHandler
extends AuthorTableOperationsHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)DITAMapAuthorTableOperationsHandler.class.getName());
    private InsertColumnOperation insertColumnOperation = null;
    private InsertRowOperation insertRowOperation = null;
    private DeleteColumnOperation deleteColumnOperation = null;
    private InsertTableOperation insertTableOperation = null;
    private DeleteRowOperation deleteRowOperation = null;

    public boolean handleInsertColumn(AuthorTableInsertColumnArguments tablePasteColumnArgs) throws AuthorOperationException {
        boolean handled = false;
        try {
            if (this.insertRowOperation == null) {
                this.insertRowOperation = new InsertRowOperation();
            }
            if (this.insertColumnOperation == null) {
                this.insertColumnOperation = new InsertColumnOperation();
            }
            if (this.insertTableOperation == null) {
                this.insertTableOperation = new InsertTableOperation();
            }
            this.insertColumnOperation.performInsertColumn(tablePasteColumnArgs.getAuthorAccess(), null, tablePasteColumnArgs.getColumnFragments(), null, tablePasteColumnArgs.areFragmentsWrappedInCells(), this.insertRowOperation, this.insertTableOperation);
            handled = true;
        }
        catch (IllegalArgumentException e) {
            logger.warn("Paste column failed.", (Throwable)e);
        }
        return handled;
    }

    public boolean handleDeleteColumn(AuthorTableDeleteColumnArguments arguments) throws AuthorOperationException {
        if (this.deleteColumnOperation == null) {
            this.deleteColumnOperation = new DeleteColumnOperation();
        }
        return this.deleteColumnOperation.performDeleteColumn(arguments.getAuthorAccess(), arguments.getColumnCellsIntervals(), false);
    }

    public boolean handleDeleteRow(AuthorTableDeleteRowArguments arguments) throws AuthorOperationException {
        ContentInterval rowInterval = arguments.getRowInterval();
        if (this.deleteRowOperation == null) {
            this.deleteRowOperation = new DeleteRowOperation();
        }
        return this.deleteRowOperation.performDeleteRows(arguments.getAuthorAccess(), rowInterval.getStartOffset(), rowInterval.getEndOffset());
    }

    public boolean handleDeleteRows(AuthorTableDeleteRowsArguments arguments) throws AuthorOperationException {
        if (this.deleteRowOperation == null) {
            this.deleteRowOperation = new DeleteRowOperation();
        }
        return this.deleteRowOperation.performDeleteRows(arguments.getAuthorAccess(), arguments.getContentIntervals());
    }

    public AuthorElement getTableElementContainingOffset(AuthorAccess access, int offset) {
        return TableOperationsUtil.getTableElementContainingOffset(offset, access, " map/reltable ");
    }
}

