/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.dita.link;

import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.dita.DITAAccess;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.webapp.WebappRestSafe;
import ro.sync.ecss.extensions.dita.WebappKeysUtil;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible(value=false)
@WebappRestSafe
public class InsertXrefOperation
implements AuthorOperation {
    private static final Logger logger = LoggerFactory.getLogger((String)InsertXrefOperation.class.getName());
    private static final String ARGUMENT_TYPE = "type";
    private static final String ARGUMENT_FORMAT = "format";
    private static final String ARGUMENT_SCOPE = "scope";
    private static final String ARGUMENT_HREF_TYPE = "href type";
    private static final String ARGUMENT_PREFERRED_ELEMENT_NAME = "preferred element name";
    private static final String ARGUMENT_REFERENCE_VALUE = "reference_value";
    private static final String ARGUMENT_REPLACE_REFERENCE_AT_CARET = "replace_reference";
    private static final String ARGUMENT_TARGET_CLASS = "target_element_class";
    private static final String ARGUMENT_TARGET_NAME = "target_element_name";
    private ArgumentDescriptor[] arguments = new ArgumentDescriptor[5];

    public InsertXrefOperation() {
        ArgumentDescriptor argumentDescriptor;
        this.arguments[0] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_TYPE, 0, "The type attribute value");
        this.arguments[1] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_FORMAT, 0, "The format attribute value");
        this.arguments[2] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_SCOPE, 0, "The scope attribute value");
        this.arguments[3] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_HREF_TYPE, 3, "The type of the href attribute", new String[]{"dita topic", "non dita resource", "web page"}, "dita topic");
        this.arguments[4] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_PREFERRED_ELEMENT_NAME, 0, "The preferred name of the reference element to be inserted");
    }

    public void doOperation(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        this.doOperationInternal(authorAccess, args, true);
    }

    protected void doOperationInternal(AuthorAccess authorAccess, ArgumentsMap args, boolean isXref) throws AuthorOperationException {
        Object type = args.getArgumentValue(ARGUMENT_TYPE);
        Object format = args.getArgumentValue(ARGUMENT_FORMAT);
        Object scope = args.getArgumentValue(ARGUMENT_SCOPE);
        Object hrefType = args.getArgumentValue(ARGUMENT_HREF_TYPE);
        Object preferredElName = args.getArgumentValue(ARGUMENT_PREFERRED_ELEMENT_NAME);
        Object referenceValue = args.getArgumentValue(ARGUMENT_REFERENCE_VALUE);
        if (referenceValue == null) {
            DITAAccess.insertLinkReference((AuthorAccess)authorAccess, (String)((String)type), (String)((String)format), (String)((String)scope), (boolean)isXref, (String)((String)preferredElName), (String)((String)hrefType), null, (boolean)true);
        } else {
            String keyRef;
            boolean replaceReferenceAtCaret = "true".equals(args.getArgumentValue(ARGUMENT_REPLACE_REFERENCE_AT_CARET));
            if (replaceReferenceAtCaret) {
                InsertXrefOperation.deleteReferenceAtCaret(authorAccess, isXref);
            }
            String reference = (keyRef = WebappKeysUtil.getKeyRefForUrl(authorAccess, (String)referenceValue)) != null ? keyRef : (String)referenceValue;
            String targetClass = (String)args.getArgumentValue(ARGUMENT_TARGET_CLASS);
            String targetElementQName = (String)args.getArgumentValue(ARGUMENT_TARGET_NAME);
            DITAAccess.insertLinkReference((String)reference, (String)targetClass, (String)targetElementQName, (AuthorAccess)authorAccess, (String)((String)type), (String)((String)format), (String)((String)scope), (boolean)isXref, (keyRef != null ? 1 : 0) != 0, (String)((String)hrefType));
        }
    }

    private static void deleteReferenceAtCaret(AuthorAccess authorAccess, boolean isXref) {
        AuthorElement referenceAtCaret = null;
        try {
            AuthorElement elementAtCaret;
            String className;
            int caretOffset = authorAccess.getEditorAccess().getCaretOffset();
            AuthorNode nodeAtCaret = authorAccess.getDocumentController().getNodeAtOffset(caretOffset);
            if (nodeAtCaret.getType() == 0 && (className = " " + (elementAtCaret = (AuthorElement)nodeAtCaret).getAttribute("class").getValue() + " ").contains(isXref ? " topic/xref " : " topic/link ")) {
                referenceAtCaret = elementAtCaret;
            }
        }
        catch (BadLocationException e) {
            logger.debug((Object)e, (Throwable)e);
        }
        if (referenceAtCaret != null) {
            authorAccess.getDocumentController().deleteNode(referenceAtCaret);
        }
    }

    public ArgumentDescriptor[] getArguments() {
        return this.arguments;
    }

    public String getDescription() {
        return "Insert a DITA cross reference";
    }
}

