/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.dita.link;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXParseException;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.basic.util.URLUtil;
import ro.sync.ecss.dita.ContextKeyManager;
import ro.sync.ecss.dita.ContextKeyManagerProvider;
import ro.sync.ecss.dita.DITAAccess;
import ro.sync.ecss.dita.KeysManagerBase;
import ro.sync.ecss.dita.Reference;
import ro.sync.ecss.dita.reference.keyref.KeyInfo;
import ro.sync.ecss.extensions.api.AttributeChangedEvent;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorListener;
import ro.sync.ecss.extensions.api.AuthorListenerAdapter;
import ro.sync.ecss.extensions.api.access.AuthorEditorAccess;
import ro.sync.ecss.extensions.api.link.InvalidLinkException;
import ro.sync.ecss.extensions.api.link.LinkTextResolver;
import ro.sync.ecss.extensions.api.link.Severity;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorDocument;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.exml.workspace.api.Platform;

@API(type=APIType.EXTENDABLE, src=SourceType.PUBLIC)
public class DitaLinkTextResolver
extends LinkTextResolver {
    private static final float CONCURRENT_HASH_MAP_LOAD_FACTOR = 0.75f;
    private static final Logger logger = LoggerFactory.getLogger((String)DitaLinkTextResolver.class.getName());
    private static final String ATTRIBUTE_KEYREF = "keyref";
    private static final String ATTRIBUTE_HREF = "href";
    private static final ResolvedLinkInfo NOT_RESOLVED = new ResolvedLinkInfo(null, null);
    private static final ResolvedLinkInfo TITLE_NOT_FOUND = new ResolvedLinkInfo("", null);
    private static final ResolvedLinkInfo PENDING = new ResolvedLinkInfo(null, null);
    private final Map<String, ResolvedLinkInfo> keyrefs = new ConcurrentHashMap<String, ResolvedLinkInfo>(16, 0.75f, 1);
    private final Map<String, ResolvedLinkInfo> hrefs = new ConcurrentHashMap<String, ResolvedLinkInfo>(16, 0.75f, 1);
    private final Map<String, WeakHashMap<AuthorNode, Object>> ditaLinkElements = new ConcurrentHashMap<String, WeakHashMap<AuthorNode, Object>>(16, 0.75f, 1);
    private AuthorListenerAdapter authorListenerAdapter = new AuthorListenerAdapter(){

        public void attributeChanged(AttributeChangedEvent e) {
            AttrValue classValue;
            AuthorElement element = (AuthorElement)e.getOwnerAuthorNode();
            String attrName = e.getAttributeName();
            if (DitaLinkTextResolver.this.resolvesTopicrefs && (classValue = element.getAttribute("class")) != null && classValue.getValue().contains(" map/topicref ")) {
                boolean depends;
                boolean bl = depends = "locktitle".equals(attrName) || "navtitle".equals(attrName);
                if (depends) {
                    DitaLinkTextResolver.this.authorAccess.getEditorAccess().refresh((AuthorNode)element);
                }
            }
        }
    };
    private AuthorAccess authorAccess;
    private boolean resolvesTopicrefs;
    private ContextKeyManagerProvider keyManagerProvider;

    public DitaLinkTextResolver() {
        this.keyManagerProvider = new ContextKeyManagerProvider(){
            private ContextKeyManager keyManger = ContextKeyManager.getDefault();

            public ContextKeyManager getContextKeyManager() {
                return this.keyManger;
            }
        };
    }

    @Deprecated
    public DitaLinkTextResolver(ContextKeyManager keyManager) {
        final ContextKeyManager finalKeyManager = keyManager;
        this.keyManagerProvider = new ContextKeyManagerProvider(){

            public ContextKeyManager getContextKeyManager() {
                return finalKeyManager;
            }
        };
    }

    public DitaLinkTextResolver(ContextKeyManagerProvider keyManagerProvider) {
        this.keyManagerProvider = keyManagerProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String resolveReference(AuthorNode node) throws InvalidLinkException {
        AuthorElement element;
        AttrValue classValue;
        ResolvedLinkInfo resolvedInfo = null;
        if (node.getType() == 0 && (classValue = (element = (AuthorElement)node).getAttribute("class")) != null) {
            boolean fromThisDocument;
            AttrValue attrValue = element.getAttribute(ATTRIBUTE_KEYREF);
            if (attrValue != null && attrValue.getValue() != null) {
                resolvedInfo = this.resolveKeyrefReference(element, attrValue.getValue(), classValue.getValue());
            }
            if (resolvedInfo == null) {
                if (classValue.getValue().contains(" map/topicref ")) {
                    resolvedInfo = this.resolveTopicRefReference(element, classValue);
                }
                if (resolvedInfo == null && (attrValue = element.getAttribute(ATTRIBUTE_HREF)) != null && DitaLinkTextResolver.isHrefElement(element) && node.getXMLBaseURL() != null && DitaLinkTextResolver.isLocalReference(element)) {
                    resolvedInfo = this.resolveHrefReference(element, attrValue.getValue());
                }
            }
            boolean bl = fromThisDocument = node.getOwnerDocument() == this.authorAccess.getDocumentController().getAuthorDocumentNode();
            if (fromThisDocument && resolvedInfo != null && resolvedInfo.definitionLocation != null) {
                WeakHashMap<Object, Object> dependencies = this.ditaLinkElements.get(resolvedInfo.definitionLocation);
                if (dependencies == null) {
                    dependencies = new WeakHashMap();
                    this.ditaLinkElements.put(resolvedInfo.definitionLocation, dependencies);
                }
                WeakHashMap<AuthorNode, Object> weakHashMap = dependencies;
                synchronized (weakHashMap) {
                    dependencies.put(node, null);
                }
            }
        }
        if (resolvedInfo != null && resolvedInfo.exception != null) {
            throw resolvedInfo.exception;
        }
        return resolvedInfo != null ? resolvedInfo.content : null;
    }

    private ResolvedLinkInfo resolveTopicRefReference(AuthorElement element, AttrValue classValue) {
        ResolvedLinkInfo resolvedInfo = null;
        this.resolvesTopicrefs = true;
        AttrValue locktitle = element.getAttribute("locktitle");
        boolean isTopicHead = classValue.getValue().contains(" mapgroup-d/topichead ");
        if (isTopicHead || locktitle != null && "yes".equals(locktitle.getValue())) {
            resolvedInfo = this.extractNavTitle(element);
        }
        return resolvedInfo;
    }

    private ResolvedLinkInfo extractNavTitle(AuthorElement element) {
        List topicrefChildren;
        ResolvedLinkInfo resolvedInfo = null;
        AttrValue navtitle = element.getAttribute("navtitle");
        if (navtitle != null) {
            resolvedInfo = new ResolvedLinkInfo(navtitle.getValue(), null);
        }
        if ((topicrefChildren = element.getContentNodes()) != null && !topicrefChildren.isEmpty()) {
            for (AuthorNode trChild : topicrefChildren) {
                ResolvedLinkInfo found;
                if (trChild.getType() != 0) continue;
                AuthorElement firstChild = (AuthorElement)trChild;
                AttrValue firstChClass = firstChild.getAttribute("class");
                if (firstChClass == null || !firstChClass.getValue().contains(" map/topicmeta ") || (found = this.findNavtitleInTopicmetaChildren(firstChild)) == null) break;
                resolvedInfo = found;
                break;
            }
        }
        return resolvedInfo;
    }

    private ResolvedLinkInfo findNavtitleInTopicmetaChildren(AuthorElement topicmeta) {
        ResolvedLinkInfo resolvedInfo = null;
        List topicMetaChildren = topicmeta.getContentNodes();
        if (topicMetaChildren != null && !topicMetaChildren.isEmpty()) {
            for (AuthorNode tmChild : topicMetaChildren) {
                AuthorElement tmChildElem;
                AttrValue tmChildElemClass;
                if (tmChild.getType() != 0 || (tmChildElemClass = (tmChildElem = (AuthorElement)tmChild).getAttribute("class")) == null || !tmChildElemClass.getValue().contains(" topic/navtitle ")) continue;
                try {
                    resolvedInfo = new ResolvedLinkInfo(tmChildElem.getTextContent(), null);
                }
                catch (BadLocationException e) {
                    logger.error((Object)e, (Throwable)e);
                }
                break;
            }
        }
        return resolvedInfo;
    }

    private ResolvedLinkInfo resolveHrefReference(AuthorElement element, String hrefValue) {
        ResolvedLinkInfo resolvedInfo = null;
        String cacheKey = DitaLinkTextResolver.computeCacheKey((AuthorNode)element, hrefValue);
        resolvedInfo = this.hrefs.get(cacheKey);
        if (resolvedInfo == null) {
            block13: {
                logger.debug("Resolve using href: {}", (Object)element);
                if (DITAAccess.isReferenceToDITAResource((AuthorNode)element, null) || DITAAccess.isReferenceToDITACompatibleResource((AuthorNode)element, null)) {
                    try {
                        this.hrefs.put(cacheKey, PENDING);
                        String targetInfo = DITAAccess.computeLinkText((AuthorNode)element, null, (String)hrefValue, (String)element.getXMLBaseURL().toString(), (KeysManagerBase)this.keyManagerProvider.getContextKeyManager());
                        if (targetInfo != null) {
                            Reference parsed = DITAAccess.parseDITAHref((String)element.getXMLBaseURL().toExternalForm(), (String)hrefValue, (boolean)true);
                            if (parsed != null) {
                                String linkLocation = URLUtil.removeQueryOrAnchorFromName((String)parsed.getUri());
                                resolvedInfo = new ResolvedLinkInfo(targetInfo, linkLocation);
                            }
                            break block13;
                        }
                        resolvedInfo = TITLE_NOT_FOUND;
                    }
                    catch (FileNotFoundException e) {
                        resolvedInfo = this.getFileNotFoundInfo((AuthorNode)element, hrefValue, e);
                    }
                    catch (IOException e) {
                        resolvedInfo = new ResolvedLinkInfo(null, null);
                        InvalidLinkException exception = new InvalidLinkException(e.getMessage(), Severity.ERROR, true);
                        exception.initCause((Throwable)e);
                        resolvedInfo.setException(exception);
                    }
                    catch (SAXParseException e) {
                        resolvedInfo = new ResolvedLinkInfo(null, null);
                        String message = MessageFormat.format(this.authorAccess.getAuthorResourceBundle().getMessage("Invalid_dita_resource"), hrefValue);
                        InvalidLinkException exception = new InvalidLinkException(message, Severity.ERROR, true);
                        exception.initCause((Throwable)e);
                        resolvedInfo.setException(exception);
                    }
                    catch (Exception e) {
                        resolvedInfo = new ResolvedLinkInfo(null, null);
                        InvalidLinkException ex = new InvalidLinkException(e.getMessage());
                        ex.initCause((Throwable)e);
                        resolvedInfo.setException(ex);
                    }
                } else {
                    String relativeLocation = hrefValue;
                    try {
                        relativeLocation = this.authorAccess.getUtilAccess().makeRelative(element.getXMLBaseURL(), new URL(hrefValue));
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                    resolvedInfo = new ResolvedLinkInfo(relativeLocation, hrefValue);
                }
            }
            this.hrefs.put(cacheKey, resolvedInfo);
        } else {
            logger.debug("Cache hit! {}", (Object)element);
        }
        return resolvedInfo;
    }

    private ResolvedLinkInfo resolveKeyrefReference(AuthorElement element, String keyref, String classValue) {
        LinkedHashMap keys;
        String keyrefCacheKey;
        ResolvedLinkInfo resolvedInfo;
        String keyName = keyref;
        String elementID = null;
        int slashIndex = keyref.indexOf(47);
        if (slashIndex != -1) {
            if (slashIndex < keyref.length() - 1) {
                elementID = keyref.substring(slashIndex + 1, keyref.length());
            }
            keyName = keyref.substring(0, slashIndex);
        }
        if ((resolvedInfo = this.keyrefs.get(keyrefCacheKey = this.buildKeyrefCacheKey(element, keyref, keys = DITAAccess.getKeys((URL)element.getXMLBaseURL(), (ContextKeyManager)this.keyManagerProvider.getContextKeyManager())))) == null) {
            KeyInfo keyInfo;
            KeyInfo keyInfo2 = keyInfo = keys != null ? (KeyInfo)keys.get(keyName) : null;
            if (keys != null && keyInfo == null) {
                keyName = DITAAccess.rewriteKeyref((LinkedHashMap)DITAAccess.getURLKeyScopeContexts((URL)element.getXMLBaseURL(), (ContextKeyManager)this.keyManagerProvider.getContextKeyManager()), (LinkedHashMap)keys, (AuthorNode)element, (String)keyName);
                keyInfo = (KeyInfo)keys.get(keyName);
            }
            logger.debug("Resolve using keyref: {} to {}", (Object)element, (Object)keyInfo);
            if (keyInfo != null) {
                if (elementID == null || keyInfo.getHrefLocation() == null && keyInfo.getHrefValue() != null) {
                    resolvedInfo = this.resolveKeyRefToKeydefMetadata(classValue, keyInfo);
                }
                if (resolvedInfo == null && keyInfo.getHrefLocation() != null) {
                    URL keyResolvedURL;
                    String absoluteLocation = keyInfo.getHrefLocation().toExternalForm();
                    if (elementID != null && (keyResolvedURL = DITAAccess.resolveKeyRef((URL)element.getXMLBaseURL(), (String)keyref, (ContextKeyManager)this.keyManagerProvider.getContextKeyManager(), (boolean)true)) != null) {
                        absoluteLocation = keyResolvedURL.toString();
                    }
                    try {
                        this.keyrefs.put(keyrefCacheKey, PENDING);
                        String targetInfo = null;
                        if (DITAAccess.isReferenceToDITAResource((AuthorNode)element, (KeyInfo)keyInfo)) {
                            Object keyRefValue = keyName;
                            if (elementID != null && !elementID.isEmpty()) {
                                keyRefValue = (String)keyRefValue + "/" + elementID;
                            }
                            targetInfo = DITAAccess.computeLinkText((AuthorNode)element, (String)keyRefValue, (String)absoluteLocation, (String)absoluteLocation, (KeysManagerBase)this.keyManagerProvider.getContextKeyManager());
                            logger.debug("targetInfo " + targetInfo);
                        } else {
                            String navTitle = keyInfo.getNavTitle();
                            targetInfo = navTitle != null ? navTitle : this.getLocationForDisplay(absoluteLocation, (AuthorNode)element);
                        }
                        resolvedInfo = targetInfo == null ? TITLE_NOT_FOUND : new ResolvedLinkInfo(targetInfo, absoluteLocation);
                    }
                    catch (FileNotFoundException e) {
                        resolvedInfo = this.getFileNotFoundInfo((AuthorNode)element, absoluteLocation, e);
                    }
                    catch (IOException e) {
                        resolvedInfo = new ResolvedLinkInfo(null, absoluteLocation);
                        InvalidLinkException exception = new InvalidLinkException(e.getMessage(), Severity.ERROR, true);
                        exception.initCause((Throwable)e);
                        resolvedInfo.setException(exception);
                    }
                    catch (Exception e) {
                        resolvedInfo = new ResolvedLinkInfo(null, absoluteLocation);
                        InvalidLinkException invalidLinkException = new InvalidLinkException(e.getMessage());
                        invalidLinkException.initCause((Throwable)e);
                        resolvedInfo.setException(invalidLinkException);
                    }
                }
                if (resolvedInfo == null) {
                    resolvedInfo = NOT_RESOLVED;
                }
                logger.debug("Resolved {} to {}", (Object)keyref, (Object)resolvedInfo);
            } else {
                resolvedInfo = new ResolvedLinkInfo(null, null);
                String keyNotFound = MessageFormat.format(this.authorAccess.getAuthorResourceBundle().getMessage("Key_name_not_found"), keyName);
                InvalidLinkException ex = new InvalidLinkException(keyNotFound, Severity.WARNING, true);
                Object shortMessage = "";
                if (this.authorAccess != null && this.authorAccess.getWorkspaceAccess() != null && this.authorAccess.getWorkspaceAccess().getPlatform() == Platform.WEBAPP) {
                    shortMessage = "[" + keyref + "]";
                }
                ex.setShortMessage((String)shortMessage);
                resolvedInfo.setException(ex);
            }
        } else {
            logger.debug("Cache hit! {}", (Object)element);
        }
        if (resolvedInfo != null) {
            this.keyrefs.put(keyrefCacheKey, resolvedInfo);
        } else {
            this.keyrefs.remove(keyrefCacheKey);
        }
        return resolvedInfo;
    }

    private ResolvedLinkInfo resolveKeyRefToKeydefMetadata(String classValue, KeyInfo keyInfo) {
        ResolvedLinkInfo resolvedInfo = null;
        if (keyInfo.getMetaContentProvider() != null) {
            String linkContent = keyInfo.getMetaContentProvider().getContent(classValue);
            if (linkContent == null && (keyInfo.getHrefValue() == null || keyInfo.getHrefLocation() == null) && keyInfo.getKeyrefValue() == null && classValue != null && (classValue.contains(" topic/xref ") || classValue.contains(" topic/link "))) {
                linkContent = keyInfo.getMetaContentProvider().getContent(" topic/ph ");
            }
            if (linkContent != null) {
                linkContent = this.authorAccess.getXMLUtilAccess().unescapeAttributeValue(linkContent);
                resolvedInfo = new ResolvedLinkInfo(linkContent, URLUtil.removeQueryOrAnchorFromName((String)keyInfo.getDefinitionLocation().toExternalForm()));
            }
        }
        if (resolvedInfo == null && Boolean.TRUE.equals(keyInfo.getLocktitle()) && keyInfo.getNavTitle() != null) {
            resolvedInfo = new ResolvedLinkInfo(keyInfo.getNavTitle(), keyInfo.getHrefLocation().toExternalForm());
        }
        return resolvedInfo;
    }

    private String getLocationForDisplay(String absoluteLocation, AuthorNode node) {
        String locationForDisplay = absoluteLocation;
        URL locationUrl = URLUtil.clearUserInfo((String)absoluteLocation);
        if (locationUrl != null) {
            locationForDisplay = locationUrl.toExternalForm();
            AuthorDocument document = node.getOwnerDocument();
            if (document != null) {
                try {
                    URL systemIdUrl = new URL(document.getSystemID());
                    if (systemIdUrl.getProtocol().equals(locationUrl.getProtocol()) && !URLUtil.hasCommonProtocol((URL)locationUrl)) {
                        locationForDisplay = this.authorAccess.getUtilAccess().makeRelative(systemIdUrl, locationUrl);
                    }
                }
                catch (MalformedURLException e) {
                    logger.debug((Object)e, (Throwable)e);
                }
            }
        }
        return locationForDisplay;
    }

    private ResolvedLinkInfo getFileNotFoundInfo(AuthorNode node, String hrefValue, FileNotFoundException e) {
        Object message = e.getMessage();
        try {
            Reference parsed;
            URL xmlBaseURL = node.getXMLBaseURL();
            if (xmlBaseURL != null && (parsed = DITAAccess.parseDITAHref((String)xmlBaseURL.toExternalForm(), (String)hrefValue, (boolean)true)) != null) {
                int lastIndexOfSharp;
                File file = URLUtil.getCanonicalFileFromFileUrl((URL)new URL(parsed.getUri()));
                message = file != null ? this.authorAccess.getAuthorResourceBundle().getMessage("File_not_found") + ": \"" + file.getName() + "\"" : ((lastIndexOfSharp = hrefValue.lastIndexOf(35)) != -1 ? this.authorAccess.getAuthorResourceBundle().getMessage("File_not_found") + ": \"" + hrefValue.substring(0, lastIndexOfSharp) + "\"" : this.authorAccess.getAuthorResourceBundle().getMessage("File_not_found") + ": \"" + hrefValue + "\"");
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        ResolvedLinkInfo resolvedInfo = new ResolvedLinkInfo(null, null);
        resolvedInfo.setException(new InvalidLinkException((String)message, Severity.ERROR, true));
        return resolvedInfo;
    }

    private static String computeCacheKey(AuthorNode node, String hrefValue) {
        String ksCache;
        String xmlBase = node.getXMLBaseURL().toExternalForm();
        int lastIndexOfSlash = xmlBase.lastIndexOf(47);
        if (lastIndexOfSlash != -1) {
            xmlBase = xmlBase.substring(0, lastIndexOfSlash + 1);
        }
        String kk = xmlBase + "#####" + hrefValue;
        if (hrefValue != null && hrefValue.startsWith("#./")) {
            kk = kk + "#####" + DitaLinkTextResolver.getParentTopicID(node);
        }
        if ((ksCache = DitaLinkTextResolver.computeKeyScopesHash(node)) != null && !ksCache.isEmpty()) {
            kk = kk + "#####" + ksCache;
        }
        return kk;
    }

    private static String getParentTopicID(AuthorNode element) {
        for (AuthorNode currentElement = element; currentElement != null; currentElement = currentElement.getParent()) {
            AttrValue idVal;
            AuthorElement elem;
            AttrValue classAttr;
            if (!(currentElement instanceof AuthorElement) || (classAttr = (elem = (AuthorElement)currentElement).getAttribute("class")) == null || !classAttr.getValue().contains(" topic/topic ") || (idVal = elem.getAttribute("id")) == null) continue;
            return idVal.getValue();
        }
        return null;
    }

    private static String computeKeyScopesHash(AuthorNode elem) {
        AttrValue clazz;
        StringBuilder hash = new StringBuilder();
        if (elem instanceof AuthorElement && (clazz = ((AuthorElement)elem).getAttribute("class")) != null && clazz.getValue().contains(" map/topicref ")) {
            while (elem != null && elem.getType() != 2) {
                AttrValue keyScope;
                if (elem.getType() == 0 && (keyScope = ((AuthorElement)elem).getAttribute("keyscope")) != null) {
                    hash.insert(0, '/').insert(0, keyScope.getValue());
                }
                elem = elem.getParent();
            }
        }
        return hash.toString();
    }

    private static boolean isLocalDITAReference(AuthorElement element) {
        return DITAAccess.isReferenceToDITAResource((AuthorNode)element, null) && DitaLinkTextResolver.isLocalReference(element);
    }

    private static boolean isLocalReference(AuthorElement element) {
        AttrValue scopeAttr = element.getAttribute("scope");
        String scope = scopeAttr != null ? scopeAttr.getValue() : null;
        return scope == null || "local".equals(scope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Set<String> modifiedURLs) {
        ResolvedLinkInfo resolvedKeyInfo;
        Object key;
        Set<String> keySet = this.keyrefs.keySet();
        Iterator<String> iterator = keySet.iterator();
        while (iterator.hasNext()) {
            key = iterator.next();
            resolvedKeyInfo = this.keyrefs.get(key);
            if (resolvedKeyInfo != null && resolvedKeyInfo.definitionLocation != null && !modifiedURLs.contains(resolvedKeyInfo.definitionLocation)) continue;
            iterator.remove();
        }
        keySet = this.hrefs.keySet();
        iterator = keySet.iterator();
        while (iterator.hasNext()) {
            key = iterator.next();
            resolvedKeyInfo = this.hrefs.get(key);
            if (resolvedKeyInfo.definitionLocation != null && !modifiedURLs.contains(resolvedKeyInfo.definitionLocation)) continue;
            iterator.remove();
        }
        LinkedList allToRefresh = new LinkedList();
        for (String url : modifiedURLs) {
            Map nodes = this.ditaLinkElements.get(url);
            if (nodes == null) continue;
            Map map = nodes;
            synchronized (map) {
                allToRefresh.addAll(nodes.keySet());
            }
        }
        AuthorEditorAccess editorAccess = this.authorAccess.getEditorAccess();
        for (AuthorNode authorNode : allToRefresh) {
            editorAccess.refresh(authorNode);
        }
    }

    private static boolean isHrefElement(AuthorElement element) {
        AttrValue classValue = element.getAttribute("class");
        return classValue != null && (classValue.getValue().contains(" map/topicref ") || classValue.getValue().contains(" topic/xref ") && !classValue.getValue().contains(" pr-d/coderef ") || classValue.getValue().contains(" topic/link "));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        this.keyrefs.clear();
        this.hrefs.clear();
        LinkedList<AuthorNode> toRefresh = new LinkedList<AuthorNode>();
        Collection<WeakHashMap<AuthorNode, Object>> values = this.ditaLinkElements.values();
        Iterator<WeakHashMap<AuthorNode, Object>> iterator = values.iterator();
        while (iterator.hasNext()) {
            WeakHashMap<AuthorNode, Object> weakHashMap;
            WeakHashMap<AuthorNode, Object> weakHashMap2 = weakHashMap = iterator.next();
            synchronized (weakHashMap2) {
                toRefresh.addAll(weakHashMap.keySet());
            }
        }
        this.ditaLinkElements.clear();
        for (AuthorNode authorNode : toRefresh) {
            if (authorNode.getOwnerDocument() == null) continue;
            this.authorAccess.getEditorAccess().refresh(authorNode);
        }
    }

    public void refreshNodeReferences(AuthorNode node) {
        if (node.getType() == 0) {
            AuthorElement element = (AuthorElement)node;
            AttrValue attrValue = element.getAttribute(ATTRIBUTE_KEYREF);
            if (attrValue != null && attrValue.getValue() != null && !attrValue.getValue().contains("/")) {
                LinkedHashMap keys = DITAAccess.getKeys((URL)node.getXMLBaseURL(), (ContextKeyManager)this.keyManagerProvider.getContextKeyManager());
                this.keyrefs.remove(this.buildKeyrefCacheKey(element, attrValue.getValue(), keys));
            }
            if ((attrValue = element.getAttribute(ATTRIBUTE_HREF)) != null && DitaLinkTextResolver.isHrefElement(element) && node.getXMLBaseURL() != null && DitaLinkTextResolver.isLocalDITAReference(element)) {
                this.hrefs.remove(DitaLinkTextResolver.computeCacheKey(node, attrValue.getValue()));
            }
            this.authorAccess.getEditorAccess().refresh(node);
        }
    }

    private String buildKeyrefCacheKey(AuthorElement node, String keyName, LinkedHashMap<String, KeyInfo> keys) {
        AttrValue attribute = node.getAttribute("class");
        keyName = DITAAccess.rewriteKeyref((LinkedHashMap)DITAAccess.getURLKeyScopeContexts((URL)node.getXMLBaseURL(), (ContextKeyManager)this.keyManagerProvider.getContextKeyManager()), keys, (AuthorNode)node, (String)keyName);
        return keyName + "\"" + (attribute != null ? attribute.getValue() : "");
    }

    public void clearReferencesCache() {
        this.keyrefs.clear();
        this.hrefs.clear();
        this.ditaLinkElements.clear();
    }

    public void activated(AuthorAccess authorAccess) {
        this.authorAccess = authorAccess;
        authorAccess.getDocumentController().addAuthorListener((AuthorListener)this.authorListenerAdapter);
    }

    public void deactivated(AuthorAccess authorAccess) {
        authorAccess.getDocumentController().removeAuthorListener((AuthorListener)this.authorListenerAdapter);
    }

    private static class ResolvedLinkInfo {
        final String content;
        final String definitionLocation;
        private InvalidLinkException exception;

        public ResolvedLinkInfo(String content, String definitionLocation) {
            this.content = content;
            this.definitionLocation = definitionLocation;
        }

        public void setException(InvalidLinkException exception) {
            this.exception = exception;
        }

        public String toString() {
            return this.content + ", location: " + this.definitionLocation;
        }
    }
}

