/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.dita.id;

import java.net.URL;
import java.util.StringTokenizer;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.basic.util.URLUtil;
import ro.sync.ecss.extensions.api.AuthorElementBaseInterface;
import ro.sync.ecss.extensions.api.access.AuthorEditorAccess;
import ro.sync.ecss.extensions.api.content.ClipboardFragmentInformation;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.id.DefaultUniqueAttributesRecognizer;
import ro.sync.ecss.extensions.dita.id.DITAUniqueAttributesRecognizerUtil;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class DITAUniqueAttributesRecognizer
extends DefaultUniqueAttributesRecognizer {
    private static final Logger logger = LoggerFactory.getLogger((String)DITAUniqueAttributesRecognizer.class.getName());

    @Override
    public boolean copyAttributeOnSplit(String attrQName, AuthorElement element) {
        return super.copyAttributeOnSplit(attrQName, element) && !"conref".equals(attrQName);
    }

    @Override
    public String getDescription() {
        return "DITA Unique attributes recognizer";
    }

    @Override
    protected String getGenerateIDAttributeQName(AuthorElement element, String[] elemsWithAutoGeneration, boolean forceGeneration) {
        String idAttrName = super.getGenerateIDAttributeQName(element, elemsWithAutoGeneration, forceGeneration);
        if (idAttrName == null) {
            block0: for (int i = 0; i < elemsWithAutoGeneration.length; ++i) {
                String pattern = elemsWithAutoGeneration[i];
                if (!pattern.contains("/")) continue;
                pattern = pattern.trim();
                AttrValue clazz = element.getAttribute("class");
                if (clazz == null || clazz.getValue() == null) continue;
                String classValue = clazz.getValue();
                StringTokenizer st = new StringTokenizer(classValue, " ", false);
                while (st.hasMoreTokens()) {
                    String nextToken = st.nextToken();
                    if (!nextToken.equals(pattern)) continue;
                    idAttrName = this.idAttrQname;
                    break block0;
                }
            }
        }
        if (idAttrName != null && DITAUniqueAttributesRecognizer.isInsideConref((AuthorElementBaseInterface)element)) {
            idAttrName = null;
        }
        return idAttrName;
    }

    private static boolean isInsideConref(AuthorElementBaseInterface element) {
        boolean insideConref = false;
        for (AuthorElementBaseInterface parent = element.getParentElement(); parent != null; parent = parent.getParentElement()) {
            AuthorElement elem;
            if (!(parent instanceof AuthorElement) || (elem = (AuthorElement)parent).getAttribute("conref") == null && elem.getAttribute("conkeyref") == null) continue;
            insideConref = true;
            break;
        }
        return insideConref;
    }

    @Override
    public void process(ClipboardFragmentInformation fragmentInformation) {
        block2: {
            super.process(fragmentInformation);
            try {
                AuthorEditorAccess editorAccess = this.authorAccess.getEditorAccess();
                int caretOffset = editorAccess.getCaretOffset();
                AuthorNode nodeAtOffset = this.authorAccess.getDocumentController().getNodeAtOffset(caretOffset);
                URL destinationURL = nodeAtOffset.getXMLBaseURL();
                AuthorDocumentFragment fragment = fragmentInformation.getFragment();
                URL fragmentOriginalLocation = URLUtil.convertToURL((String)fragmentInformation.getOriginalLocation());
                DITAUniqueAttributesRecognizerUtil.correctFragmentReferences(fragment, fragmentOriginalLocation, destinationURL);
            }
            catch (BadLocationException e) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug((Object)e, (Throwable)e);
            }
        }
    }
}

