/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.dita.conref;

import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.document.DocumentPositionedInfo;
import ro.sync.ecss.dita.DITAAccess;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.ExtensionsBundle;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.link.LinkTextResolver;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.results.ResultsManager;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible
public class ReplaceAllKeyrefsAndConrefsOperation
implements AuthorOperation {
    private static final Logger logger = LoggerFactory.getLogger(ReplaceAllKeyrefsAndConrefsOperation.class);

    public String getDescription() {
        return "Replaces all conrefs, keyrefs and conkeyrefs in a DITA topic with the resolved content.";
    }

    public void doOperation(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        LinkTextResolver resolver;
        int caretOffset = authorAccess.getEditorAccess().getCaretOffset();
        Position caretOffsetPos = null;
        try {
            caretOffsetPos = authorAccess.getDocumentController().createPositionInContent(caretOffset);
        }
        catch (BadLocationException e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        List foundProblems = DITAAccess.replaceAllConrefs((AuthorAccess)authorAccess);
        ExtensionsBundle eb = authorAccess.getEditorAccess().getExtensionsBundle();
        if (eb != null && (resolver = eb.createLinkTextResolver()) != null) {
            foundProblems.addAll(DITAAccess.expandAllKeyrefs((AuthorAccess)authorAccess, (LinkTextResolver)resolver));
        }
        if (caretOffsetPos != null) {
            authorAccess.getEditorAccess().setCaretPosition(caretOffsetPos.getOffset());
        }
        PluginWorkspace pluginWorkspace = PluginWorkspaceProvider.getPluginWorkspace();
        int noOfProblems = foundProblems.size();
        if (pluginWorkspace != null && noOfProblems > 0) {
            ResultsManager resultsManager = pluginWorkspace.getResultsManager();
            if (resultsManager != null) {
                String tabName = authorAccess.getAuthorResourceBundle().getMessage("all.keyref.conref.replace");
                for (int i = 0; i < noOfProblems; ++i) {
                    resultsManager.addResult(tabName, (DocumentPositionedInfo)foundProblems.get(i), ResultsManager.ResultType.PROBLEM, false, false);
                }
            } else {
                StringBuilder message = new StringBuilder();
                for (int i = 0; i < noOfProblems; ++i) {
                    message.append(((DocumentPositionedInfo)foundProblems.get(i)).getMessage());
                    if (i >= noOfProblems - 1) continue;
                    message.append("\n");
                }
                authorAccess.getWorkspaceAccess().showWarningMessage(message.toString());
            }
        }
    }

    public ArgumentDescriptor[] getArguments() {
        return null;
    }
}

