/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.dita.conref;

import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.dita.DITAAccess;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.webapp.WebappRestSafe;
import ro.sync.ecss.extensions.dita.WebappKeysUtil;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible(value=false)
@WebappRestSafe
public class InsertConrefOperation
implements AuthorOperation {
    public static final String ARGUMENT_REFERENCE_VALUE = "reference_value";
    public static final String ARGUMENT_ELEMENT_CLASS = "target_element_class";
    private static final String ARGUMENT_TARGET_NAME = "target_element_name";
    private ArgumentDescriptor[] arguments = new ArgumentDescriptor[2];

    public InsertConrefOperation() {
        ArgumentDescriptor argumentDescriptor;
        this.arguments[0] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_REFERENCE_VALUE, 0, "The reference url");
        this.arguments[1] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_ELEMENT_CLASS, 0, "The elements class");
    }

    public void doOperation(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        if (args.getArgumentValue(ARGUMENT_REFERENCE_VALUE) == null) {
            DITAAccess.insertReference((AuthorAccess)authorAccess, (int)2);
        } else {
            String referenceUrl = (String)args.getArgumentValue(ARGUMENT_REFERENCE_VALUE);
            String targetName = (String)args.getArgumentValue(ARGUMENT_TARGET_NAME);
            String elementClass = (String)args.getArgumentValue(ARGUMENT_ELEMENT_CLASS);
            String keyRef = WebappKeysUtil.getKeyRefForUrl(authorAccess, referenceUrl);
            if (keyRef != null) {
                DITAAccess.insertReference((AuthorAccess)authorAccess, (String)keyRef, (int)2, (String)targetName, (String)elementClass);
            } else {
                DITAAccess.insertReference((AuthorAccess)authorAccess, (String)referenceUrl, (String)targetName, (String)elementClass);
            }
        }
    }

    public ArgumentDescriptor[] getArguments() {
        return this.arguments;
    }

    public String getDescription() {
        return "Insert a DITA content reference";
    }
}

