/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.dita.conref;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.Attributes2;
import org.xml.sax.ext.LexicalHandler;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ReferenceResolverSAXParseException;
import ro.sync.xml.ProxyNamespaceMapping;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class DITAFilteringContentHandler
implements ContentHandler,
LexicalHandler {
    private static final String TOPIC_CLASS = " topic/topic ";
    private ContentHandler contentHandler;
    private LexicalHandler lexicalHandler;
    private String[] topicPath;
    private int pathIndex;
    private int referredPathDepth;
    private boolean isForwardingEvents;
    private ProxyNamespaceMapping proxyNamespaceMapping;
    private boolean referenceResolved;
    private boolean startDTD;
    private final String[] endRangePath;
    private SAXException invalidRangeException;
    private int depth;
    private int startRangeDepth;
    private boolean foundEndRangeElement;
    private String startRangeElementQName;
    private final boolean isKeyReference;
    private boolean mapDocument;
    private String idOfFoundTopic;
    private Stack<ClassAndID> nestedClassesAndIDs;
    private Locator locator;

    public DITAFilteringContentHandler(String[] topicPath, String[] endRangePath, String sourceClass, boolean isKeyReference) {
        block4: {
            boolean invalidRange;
            block6: {
                block5: {
                    this.proxyNamespaceMapping = new ProxyNamespaceMapping();
                    this.referenceResolved = false;
                    this.depth = 0;
                    this.startRangeDepth = -1;
                    this.nestedClassesAndIDs = new Stack();
                    this.topicPath = topicPath;
                    this.endRangePath = endRangePath;
                    this.isKeyReference = isKeyReference;
                    if (endRangePath == null) break block4;
                    invalidRange = false;
                    if (topicPath != null) break block5;
                    if (sourceClass != null && sourceClass.contains(TOPIC_CLASS)) break block6;
                    invalidRange = true;
                    break block6;
                }
                if (endRangePath.length != topicPath.length) {
                    invalidRange = !isKeyReference;
                } else {
                    for (int i = 0; i < topicPath.length - 1; ++i) {
                        if (topicPath[i].equals(endRangePath[i])) continue;
                        invalidRange = true;
                        break;
                    }
                }
            }
            if (invalidRange) {
                this.invalidRangeException = this.createInvalidRangeException("Different parent paths.");
            }
        }
    }

    private SAXException createInvalidRangeException(String situation) {
        return new ReferenceResolverSAXParseException("Problem when constructing conref range between \"" + DITAFilteringContentHandler.createConrefDescr(this.topicPath, true) + "\" and \"" + DITAFilteringContentHandler.createConrefDescr(this.endRangePath, true) + "\" because: " + situation);
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public void setLexicalHandler(LexicalHandler lexicalHandler) {
        this.lexicalHandler = lexicalHandler;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.isForwardingEvents && this.contentHandler != null) {
            this.contentHandler.characters(ch, start, length);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.contentHandler != null) {
            this.contentHandler.endDocument();
            if (!this.referenceResolved) {
                if (this.topicPath != null && this.topicPath.length > 0) {
                    String firstID = this.topicPath[0];
                    if (this.mapDocument) {
                        throw new ReferenceResolverSAXParseException("Element ID '" + firstID + "' not found.", this.locator);
                    }
                    if (this.topicPath.length > 1) {
                        if (this.idOfFoundTopic != null) {
                            String conref = DITAFilteringContentHandler.createConrefDescr(this.topicPath, false);
                            throw new ReferenceResolverSAXParseException("Element ID '" + conref + "' not found in topic with ID '" + this.idOfFoundTopic + "'.", this.locator);
                        }
                        throw new ReferenceResolverSAXParseException("Topic ID '" + firstID + "' not found.", this.locator);
                    }
                    if (this.isKeyReference) {
                        throw new ReferenceResolverSAXParseException("Element ID '" + firstID + "' not found.", this.locator);
                    }
                    throw new ReferenceResolverSAXParseException("Topic ID '" + firstID + "' not found.", this.locator);
                }
                throw new ReferenceResolverSAXParseException("Reference was not resolved.", this.locator);
            }
        }
    }

    private static String createConrefDescr(String[] topicPath, boolean createFullPath) {
        StringBuilder conref = new StringBuilder();
        if (topicPath != null) {
            int i;
            int n = i = createFullPath ? 0 : 1;
            while (i < topicPath.length) {
                conref.append(topicPath[i]);
                if (i != topicPath.length - 1) {
                    conref.append("/");
                }
                ++i;
            }
        }
        return conref.toString();
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        this.nestedClassesAndIDs.pop();
        --this.depth;
        if (this.isForwardingEvents) {
            if (this.contentHandler != null) {
                this.contentHandler.endElement(uri, localName, name);
            }
            if (this.endRangePath != null) {
                if (this.foundEndRangeElement && this.depth == this.startRangeDepth - 1) {
                    this.isForwardingEvents = false;
                    this.referenceResolved = true;
                } else if (this.depth < this.startRangeDepth - 1) {
                    throw this.createInvalidRangeException("Conrefend target element is not a sibling of the conref target element.");
                }
            } else {
                --this.referredPathDepth;
                if (this.referredPathDepth == 0) {
                    this.isForwardingEvents = false;
                    this.referenceResolved = true;
                }
            }
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        if (this.contentHandler != null) {
            this.contentHandler.endPrefixMapping(prefix);
        }
        if (!this.isForwardingEvents) {
            this.proxyNamespaceMapping.removeByPrefix(prefix);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.isForwardingEvents && this.contentHandler != null) {
            this.contentHandler.ignorableWhitespace(ch, start, length);
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        if (this.isForwardingEvents && this.contentHandler != null) {
            this.contentHandler.processingInstruction(target, data);
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
        if (this.contentHandler != null) {
            this.contentHandler.setDocumentLocator(locator);
        }
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        if (this.isForwardingEvents && this.contentHandler != null) {
            this.contentHandler.skippedEntity(name);
        }
    }

    @Override
    public void startDocument() throws SAXException {
        if (this.invalidRangeException != null) {
            throw this.invalidRangeException;
        }
        if (this.contentHandler != null) {
            this.contentHandler.startDocument();
        }
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        this.nestedClassesAndIDs.push(new ClassAndID(atts.getValue("class"), atts.getValue("id")));
        ++this.depth;
        if (!this.isForwardingEvents && !this.referenceResolved) {
            String clazz = atts.getValue("class");
            if (this.depth == 1 && clazz != null && clazz.contains(" map/map ")) {
                this.mapDocument = true;
                if (this.topicPath != null && this.topicPath.length == 2 && "FIRST_TOPIC_ID".equals(this.topicPath[0])) {
                    String elementID = this.topicPath[1];
                    this.topicPath = new String[1];
                    this.topicPath[0] = elementID;
                }
            }
            if (this.topicPath == null) {
                if (clazz != null && (clazz.contains(TOPIC_CLASS) || clazz.contains(" map/map ")) || "dita".equals(name) && this.endRangePath == null) {
                    this.isForwardingEvents = true;
                    this.startRangeDepth = this.depth;
                    this.startRangeElementQName = name;
                }
            } else {
                String idValue = atts.getValue("id");
                if (idValue != null) {
                    boolean matches = idValue.equals(this.topicPath[this.pathIndex]);
                    if (!matches && this.pathIndex == 0) {
                        if (".".equals(this.topicPath[this.pathIndex])) {
                            matches = true;
                        } else if ("FIRST_TOPIC_ID".equals(this.topicPath[this.pathIndex]) && clazz != null && clazz.contains(TOPIC_CLASS) && this.getNumberOfAncestorTopics() == 1) {
                            matches = true;
                        }
                    }
                    if (matches) {
                        String closestTopicIDValue;
                        boolean found = true;
                        if (!this.mapDocument && !this.isKeyReference && this.pathIndex == 0) {
                            if (clazz != null && !clazz.contains(TOPIC_CLASS)) {
                                found = false;
                            }
                        } else if (!(this.mapDocument || this.pathIndex != 1 || clazz == null || clazz.contains(TOPIC_CLASS) || (closestTopicIDValue = this.getClosestTopicIDValue()) == null || closestTopicIDValue.equals(this.idOfFoundTopic))) {
                            found = false;
                        }
                        if (found) {
                            if (this.idOfFoundTopic == null && clazz != null && clazz.contains(TOPIC_CLASS)) {
                                this.idOfFoundTopic = atts.getValue("id");
                            }
                            ++this.pathIndex;
                            if (this.pathIndex == this.topicPath.length) {
                                this.isForwardingEvents = true;
                                this.startRangeDepth = this.depth;
                                this.startRangeElementQName = name;
                            }
                        }
                    }
                }
            }
        }
        if (this.isForwardingEvents) {
            String idValue;
            if (this.endRangePath != null && this.depth == this.startRangeDepth && (idValue = atts.getValue("id")) != null && idValue.equals(this.endRangePath[this.endRangePath.length - 1])) {
                if (name.equals(this.startRangeElementQName)) {
                    this.foundEndRangeElement = true;
                } else {
                    throw this.createInvalidRangeException("Incompatible target elements types.");
                }
            }
            ++this.referredPathDepth;
            if (this.referredPathDepth == 1) {
                AttrsImpl newAttributes = new AttrsImpl(atts);
                List proxies = this.proxyNamespaceMapping.getProxies();
                for (String proxy : proxies) {
                    String namespace = this.proxyNamespaceMapping.getNamespaceForPrefix(proxy);
                    if ("".equals(namespace)) continue;
                    Object attrName = "xmlns";
                    if (!"".equals(proxy)) {
                        attrName = (String)attrName + ":" + proxy;
                    }
                    if (newAttributes.getValue((String)attrName) != null) continue;
                    newAttributes.addAttribute((String)attrName, namespace, false);
                }
                atts = newAttributes;
            }
            this.contentHandler.startElement(uri, localName, name, atts);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.proxyNamespaceMapping.addMapping(prefix, uri);
        this.contentHandler.startPrefixMapping(prefix, uri);
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        if (this.isForwardingEvents && this.lexicalHandler != null) {
            this.lexicalHandler.comment(ch, start, length);
        }
    }

    @Override
    public void endCDATA() throws SAXException {
        if (this.isForwardingEvents && this.lexicalHandler != null) {
            this.lexicalHandler.endCDATA();
        }
    }

    @Override
    public void endDTD() throws SAXException {
        this.startDTD = false;
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endDTD();
        }
    }

    @Override
    public void endEntity(String name) throws SAXException {
        if (this.lexicalHandler != null && (this.isForwardingEvents || this.startDTD)) {
            this.lexicalHandler.endEntity(name);
        }
    }

    @Override
    public void startCDATA() throws SAXException {
        if (this.isForwardingEvents && this.lexicalHandler != null) {
            this.lexicalHandler.startCDATA();
        }
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.startDTD = true;
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startDTD(name, publicId, systemId);
        }
    }

    @Override
    public void startEntity(String name) throws SAXException {
        if (this.lexicalHandler != null && (this.isForwardingEvents || this.startDTD)) {
            this.lexicalHandler.startEntity(name);
        }
    }

    private int getNumberOfAncestorTopics() {
        int no = 0;
        for (int i = 0; i < this.nestedClassesAndIDs.size(); ++i) {
            String clazz = ((ClassAndID)this.nestedClassesAndIDs.get((int)i)).classValue;
            if (clazz == null || !clazz.contains(TOPIC_CLASS)) continue;
            ++no;
        }
        return no;
    }

    private String getClosestTopicIDValue() {
        String id = null;
        for (int i = this.nestedClassesAndIDs.size() - 1; i >= 0; --i) {
            ClassAndID classAndID = (ClassAndID)this.nestedClassesAndIDs.get(i);
            String clazz = classAndID.classValue;
            if (clazz == null || !clazz.contains(TOPIC_CLASS)) continue;
            id = classAndID.idValue;
            break;
        }
        return id;
    }

    private static class ClassAndID {
        private final String classValue;
        private final String idValue;

        public ClassAndID(String classValue, String idValue) {
            this.classValue = classValue;
            this.idValue = idValue;
        }
    }

    private static class AttrsImpl
    implements Attributes2 {
        private List attrs;

        public AttrsImpl(Attributes attributes) {
            int length = attributes.getLength();
            this.attrs = new ArrayList(length);
            for (int i = 0; i < length; ++i) {
                boolean isDeclared = false;
                boolean isSpecified = true;
                if (attributes instanceof Attributes2) {
                    Attributes2 attributes2 = (Attributes2)attributes;
                    isDeclared = attributes2.isDeclared(i);
                    isSpecified = attributes2.isSpecified(i);
                }
                this.attrs.add(new Attribute(attributes.getURI(i), attributes.getQName(i), attributes.getLocalName(i), attributes.getType(i), attributes.getValue(i), isSpecified, isDeclared));
            }
        }

        public void addAttribute(String attrName, String value, boolean specified) {
            this.attrs.add(new Attribute(null, attrName, attrName, null, value, specified, false));
        }

        @Override
        public int getIndex(String name) {
            int idx = -1;
            int i = -1;
            Iterator iterator = this.attrs.iterator();
            while (iterator.hasNext()) {
                ++i;
                Attribute attr = (Attribute)iterator.next();
                if (!AttrsImpl.areStringEqual(name, attr.qName)) continue;
                idx = i;
                break;
            }
            return idx;
        }

        @Override
        public int getIndex(String uri, String localName) {
            int idx = -1;
            int i = -1;
            Iterator iterator = this.attrs.iterator();
            while (iterator.hasNext()) {
                ++i;
                Attribute attr = (Attribute)iterator.next();
                if (!AttrsImpl.areStringEqual(uri, attr.uri) || !AttrsImpl.areStringEqual(localName, attr.localName)) continue;
                idx = i;
                break;
            }
            return idx;
        }

        @Override
        public int getLength() {
            return this.attrs.size();
        }

        @Override
        public String getLocalName(int index) {
            return ((Attribute)this.attrs.get((int)index)).localName;
        }

        @Override
        public String getQName(int index) {
            return ((Attribute)this.attrs.get((int)index)).qName;
        }

        @Override
        public String getType(int index) {
            return ((Attribute)this.attrs.get((int)index)).type;
        }

        @Override
        public String getType(String name) {
            String type = null;
            for (Attribute attr : this.attrs) {
                if (!AttrsImpl.areStringEqual(name, attr.qName)) continue;
                type = attr.type;
                break;
            }
            return type;
        }

        @Override
        public String getType(String uri, String localName) {
            String type = null;
            for (Attribute attr : this.attrs) {
                if (!AttrsImpl.areStringEqual(uri, attr.uri) || !AttrsImpl.areStringEqual(localName, attr.localName)) continue;
                type = attr.type;
                break;
            }
            return type;
        }

        @Override
        public String getURI(int index) {
            return ((Attribute)this.attrs.get((int)index)).uri;
        }

        @Override
        public String getValue(int index) {
            return ((Attribute)this.attrs.get((int)index)).value;
        }

        @Override
        public String getValue(String name) {
            String value = null;
            for (Attribute attr : this.attrs) {
                if (!AttrsImpl.areStringEqual(name, attr.qName)) continue;
                value = attr.value;
                break;
            }
            return value;
        }

        @Override
        public String getValue(String uri, String localName) {
            String value = null;
            for (Attribute attr : this.attrs) {
                if (!AttrsImpl.areStringEqual(uri, attr.uri) || !AttrsImpl.areStringEqual(localName, attr.localName)) continue;
                value = attr.value;
                break;
            }
            return value;
        }

        @Override
        public boolean isDeclared(int index) {
            return ((Attribute)this.attrs.get((int)index)).isDeclared;
        }

        @Override
        public boolean isDeclared(String name) {
            boolean value = false;
            for (Attribute attr : this.attrs) {
                if (!AttrsImpl.areStringEqual(name, attr.qName)) continue;
                value = attr.isDeclared;
                break;
            }
            return value;
        }

        @Override
        public boolean isDeclared(String uri, String localName) {
            boolean value = false;
            for (Attribute attr : this.attrs) {
                if (!AttrsImpl.areStringEqual(uri, attr.uri) || !AttrsImpl.areStringEqual(localName, attr.localName)) continue;
                value = attr.isDeclared;
                break;
            }
            return value;
        }

        @Override
        public boolean isSpecified(int index) {
            return ((Attribute)this.attrs.get((int)index)).isSpecified;
        }

        @Override
        public boolean isSpecified(String name) {
            boolean value = true;
            for (Attribute attr : this.attrs) {
                if (!AttrsImpl.areStringEqual(name, attr.qName)) continue;
                value = attr.isSpecified;
                break;
            }
            return value;
        }

        @Override
        public boolean isSpecified(String uri, String localName) {
            boolean value = true;
            for (Attribute attr : this.attrs) {
                if (!AttrsImpl.areStringEqual(uri, attr.uri) || !AttrsImpl.areStringEqual(localName, attr.localName)) continue;
                value = attr.isSpecified;
                break;
            }
            return value;
        }

        private static boolean areStringEqual(String str1, String str2) {
            return str1 == null && str2 == null || str1 != null && str2 != null && str1.equals(str2);
        }
    }

    private static class Attribute {
        private String uri;
        private String qName;
        private String localName;
        private String type;
        private String value;
        private final boolean isSpecified;
        private final boolean isDeclared;

        public Attribute(String uri, String qName, String localName, String type, String value, boolean isSpecified, boolean isDeclared) {
            this.uri = uri;
            this.qName = qName;
            this.localName = localName;
            this.type = type;
            this.value = value;
            this.isSpecified = isSpecified;
            this.isDeclared = isDeclared;
        }
    }
}

