/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.dita.conref;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.StringTokenizer;
import javax.xml.transform.sax.SAXSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.basic.util.URLUtil;
import ro.sync.ecss.dita.ContextKeyManager;
import ro.sync.ecss.dita.ContextKeyManagerProvider;
import ro.sync.ecss.dita.DITAAccess;
import ro.sync.ecss.dita.KeysManagerBase;
import ro.sync.ecss.dita.Reference;
import ro.sync.ecss.dita.reference.keyref.KeyInfo;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.CacheableAuthorReferencesResolver;
import ro.sync.ecss.extensions.api.DITAConrefsResolverBase;
import ro.sync.ecss.extensions.api.ReferenceErrorResolver;
import ro.sync.ecss.extensions.api.ReferenceResolverException;
import ro.sync.ecss.extensions.api.ValidatingReferenceResolverException;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorDocument;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.dita.conref.DITAXMLReaderWrapper;
import ro.sync.ecss.extensions.dita.conref.TextReferenceReader;
import ro.sync.exml.editor.xmleditor.ErrorListException;
import ro.sync.exml.workspace.api.util.XMLReaderWithGrammar;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class DITAConRefResolver
extends DITAConrefsResolverBase
implements CacheableAuthorReferencesResolver {
    private static final Logger logger = LoggerFactory.getLogger((String)DITAConRefResolver.class.getName());
    private static final String ATTRIBUTE_CLASS = "class";
    private static final String ATTRIBUTE_KEYREF = "keyref";
    private static final String ATTRIBUTE_CONREF = "conref";
    private static final String CODEREF_CLASS = " pr-d/coderef ";
    private static final String ATTRIBUTE_CONREF_END = "conrefend";
    private static final String ATTRIBUTE_CONKEYREF = "conkeyref";
    private static final String ATTRIBUTE_CONACTION = "conaction";
    private static final String ATTRIBUTE_HREF = "href";
    private static final String ATTRIBUTE_FORMAT = "format";
    private static final String ATTRIBUTE_ID = "id";
    private static final String TOPIC_CLASS_FRAG = " topic/topic ";
    private static Object grammarCache = null;
    private boolean grammarCacheInUse = false;
    private boolean resolveAlsoKeyRefs = false;
    protected final ContextKeyManagerProvider keyManagerProvider;

    @Deprecated
    public DITAConRefResolver(ContextKeyManager keyManager) {
        final ContextKeyManager finalKeyManager = keyManager;
        this.keyManagerProvider = new ContextKeyManagerProvider(){

            public ContextKeyManager getContextKeyManager() {
                return finalKeyManager;
            }
        };
    }

    public DITAConRefResolver() {
        this.keyManagerProvider = new ContextKeyManagerProvider(){
            private ContextKeyManager keyManager = ContextKeyManager.getDefault();

            public ContextKeyManager getContextKeyManager() {
                return this.keyManager;
            }
        };
    }

    public DITAConRefResolver(ContextKeyManagerProvider keyManagerProvider) {
        this.keyManagerProvider = keyManagerProvider;
    }

    public boolean hasReferences(AuthorNode node) {
        boolean hasReferences = false;
        if (node.getType() == 0) {
            AuthorElement element = (AuthorElement)node;
            AttrValue conAction = element.getAttribute(ATTRIBUTE_CONACTION);
            if (conAction != null) {
                hasReferences = false;
            } else {
                AttrValue attrValue = element.getAttribute(ATTRIBUTE_CONKEYREF);
                boolean bl = hasReferences = attrValue != null;
                if (!hasReferences) {
                    attrValue = element.getAttribute(ATTRIBUTE_CONREF);
                    boolean bl2 = hasReferences = attrValue != null;
                }
                if (!hasReferences) {
                    attrValue = element.getAttribute(ATTRIBUTE_HREF);
                    AttrValue classAttr = element.getAttribute(ATTRIBUTE_CLASS);
                    boolean bl3 = hasReferences = attrValue != null && classAttr != null && classAttr.getValue() != null && classAttr.getValue().contains(CODEREF_CLASS);
                }
                if (!hasReferences) {
                    hasReferences = this.hasKeyrefReference(element);
                }
            }
        }
        return hasReferences;
    }

    private boolean hasKeyrefReference(AuthorElement element) {
        boolean hasKeyref = false;
        AttrValue attrValue = element.getAttribute(ATTRIBUTE_KEYREF);
        if (attrValue != null) {
            String key = attrValue.getValue();
            AttrValue classValue = element.getAttribute(ATTRIBUTE_CLASS);
            boolean bl = hasKeyref = key != null && classValue != null && classValue.getValue() != null && classValue.getValue().contains(CODEREF_CLASS);
            if (!hasKeyref && key != null && !key.contains("/") && this.resolveAlsoKeyRefs) {
                KeyInfo keyInfo;
                LinkedHashMap keys = DITAAccess.getKeys((URL)element.getXMLBaseURL(), (ContextKeyManager)this.keyManagerProvider.getContextKeyManager());
                key = DITAAccess.rewriteKeyref((LinkedHashMap)DITAAccess.getURLKeyScopeContexts((URL)element.getXMLBaseURL(), (ContextKeyManager)this.keyManagerProvider.getContextKeyManager()), (LinkedHashMap)keys, (AuthorNode)element, (String)key);
                if (keys != null && (keyInfo = (KeyInfo)keys.get(key)) != null) {
                    hasKeyref = true;
                }
            }
        }
        return hasKeyref;
    }

    public String getDisplayName(AuthorNode node) {
        StringBuilder displayName = new StringBuilder("conref-fragment");
        if (node.getType() == 0) {
            AuthorElement element = (AuthorElement)node;
            AttrValue attrValue = element.getAttribute(ATTRIBUTE_CONKEYREF);
            if (attrValue != null) {
                displayName.setLength(0);
                displayName.append(attrValue.getValue());
            } else {
                attrValue = element.getAttribute(ATTRIBUTE_CONREF);
                if (attrValue != null) {
                    displayName.setLength(0);
                    displayName.append(attrValue.getValue());
                } else {
                    attrValue = element.getAttribute(ATTRIBUTE_KEYREF);
                    if (attrValue != null) {
                        displayName.setLength(0);
                        displayName.append(attrValue.getValue());
                    }
                }
            }
            attrValue = element.getAttribute(ATTRIBUTE_CONREF_END);
            if (attrValue != null) {
                displayName.insert(0, '[');
                displayName.append(" .. ").append(attrValue.getValue()).append(']');
            }
            if ((attrValue = element.getAttribute(ATTRIBUTE_HREF)) != null) {
                displayName.setLength(0);
                displayName.append(attrValue.getValue());
            }
        }
        return displayName.toString();
    }

    public SAXSource resolveReference(AuthorNode node, String systemID, AuthorAccess authorAccess, EntityResolver entityResolver) throws ReferenceResolverException {
        SAXSource saxSource = null;
        if (node.getType() == 0) {
            try {
                AuthorElement element = (AuthorElement)node;
                AttrValue classValue = element.getAttribute(ATTRIBUTE_CLASS);
                boolean isCoderef = classValue != null && classValue.getValue().contains(CODEREF_CLASS);
                AttrValue attrValue = element.getAttribute(ATTRIBUTE_KEYREF);
                if (attrValue != null && classValue != null && !isCoderef) {
                    saxSource = this.resolveKeyrefReference(attrValue.getValue(), classValue.getValue(), element, systemID, authorAccess);
                } else {
                    attrValue = element.getAttribute(ATTRIBUTE_HREF);
                    saxSource = isCoderef && attrValue != null ? DITAConRefResolver.resolveHrefReference(attrValue.getValue(), element, authorAccess, entityResolver) : this.resolveConrefAndConkeyref(element, classValue, systemID, authorAccess, entityResolver);
                }
            }
            catch (IOException e) {
                Object originalMsg = e.getMessage();
                String message = originalMsg;
                if (e instanceof FileNotFoundException) {
                    message = "Target file not found";
                    originalMsg = "Error while parsing reference because: " + e.getMessage();
                }
                ReferenceResolverException rre = new ReferenceResolverException(message, (String)originalMsg, true, false);
                rre.initCause((Throwable)e);
                throw rre;
            }
            catch (SAXException e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
        return saxSource;
    }

    private SAXSource resolveConrefAndConkeyref(AuthorElement element, AttrValue classValue, String systemID, AuthorAccess authorAccess, EntityResolver entityResolver) throws SAXException, IOException {
        Reference conRef = null;
        AttrValue attrValue = element.getAttribute(ATTRIBUTE_CONREF);
        if (attrValue != null) {
            String cnrfAttrStringVal = attrValue.getValue();
            try {
                conRef = DITAAccess.parseDITAHref((String)systemID, (String)cnrfAttrStringVal, (boolean)true);
            }
            catch (MalformedURLException e) {
                ReferenceResolverException rre = new ReferenceResolverException("Conref:" + e.getMessage(), false, false);
                rre.initCause((Throwable)e);
                throw rre;
            }
        }
        attrValue = classValue != null && classValue.getValue().contains(CODEREF_CLASS) ? element.getAttribute(ATTRIBUTE_KEYREF) : element.getAttribute(ATTRIBUTE_CONKEYREF);
        boolean isConKeyRef = false;
        boolean isKeyrefToElementID = false;
        if (attrValue != null) {
            String attrStringVal = attrValue.getValue();
            String problem = DITAAccess.checkValidKeyRef((String)attrStringVal);
            if (problem != null) {
                throw new ReferenceResolverException(problem, true, true);
            }
            ContextKeyManager contextKeyManager = this.keyManagerProvider.getContextKeyManager();
            LinkedHashMap keys = DITAAccess.getKeys((URL)element.getXMLBaseURL(), (ContextKeyManager)contextKeyManager);
            String attrKeyWithoutScope = attrStringVal;
            attrStringVal = DITAAccess.rewriteKeyref((LinkedHashMap)DITAAccess.getURLKeyScopeContexts((URL)element.getXMLBaseURL(), (ContextKeyManager)this.keyManagerProvider.getContextKeyManager()), (LinkedHashMap)keys, (AuthorNode)element, (String)attrStringVal);
            String keyName = attrStringVal;
            int indexOfSlash = keyName.indexOf(47);
            if (indexOfSlash != -1) {
                isKeyrefToElementID = true;
                keyName = keyName.substring(0, indexOfSlash);
            }
            if (keys != null && keys.containsKey(keyName)) {
                Reference conkeyrefResolved = DITAAccess.parseDITAKeyRef((URL)element.getXMLBaseURL(), (ContextKeyManager)this.keyManagerProvider.getContextKeyManager(), (String)attrStringVal);
                if (conkeyrefResolved == null) {
                    throw new ReferenceResolverException("Key definition for \"" + keyName + "\" does not point to a resource.", false, false);
                }
                isConKeyRef = true;
                conRef = conkeyrefResolved;
            } else {
                DITAConRefResolver.treatKeyNotFound(conRef, attrKeyWithoutScope, attrStringVal);
            }
        }
        SAXSource saxSource = null;
        if (conRef != null && conRef.getUri() != null) {
            saxSource = classValue != null && classValue.getValue().contains(CODEREF_CLASS) ? DITAConRefResolver.resolveCoderef(authorAccess, entityResolver, conRef) : this.resolveConrefAndConkeyRefInternal(element, systemID, authorAccess, entityResolver, conRef, isConKeyRef, isKeyrefToElementID);
        }
        return saxSource;
    }

    private SAXSource resolveConrefAndConkeyRefInternal(AuthorElement element, String systemID, AuthorAccess authorAccess, EntityResolver entityResolver, Reference conRef, boolean isConKeyRef, boolean isKeyrefToElementID) throws SAXException, IOException {
        String formatToDita;
        Object targetTopicID = conRef.getTopicID();
        if (isKeyrefToElementID && targetTopicID != null && !((String)targetTopicID).contains("/")) {
            targetTopicID = "FIRST_TOPIC_ID/" + (String)targetTopicID;
        }
        String uri = conRef.getUri();
        InputSource inputSource = entityResolver.resolveEntity(null, conRef.getUri());
        if (inputSource == null) {
            inputSource = new InputSource(uri);
        }
        if ((formatToDita = DITAAccess.getConverterFormatForDITACompatibleResource((String)URLUtil.getExtension((String)uri))) != null) {
            try {
                String systemId = inputSource.getSystemId();
                String ditaContent = DITAAccess.convertDitaCompatibleResource((Reader)inputSource.getCharacterStream(), (String)systemId, (String)formatToDita);
                inputSource = new InputSource(new StringReader(ditaContent));
                inputSource.setSystemId(systemId);
            }
            catch (ErrorListException e) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
        }
        boolean gcInUse = this.grammarCacheInUse;
        XMLReaderWithGrammar readerWithCache = authorAccess.getXMLUtilAccess().newNonValidatingXMLReader(this.grammarCacheInUse ? null : grammarCache);
        if (!gcInUse) {
            grammarCache = readerWithCache.getGrammarCache();
        }
        String[] endRangePath = null;
        AttrValue conrefEndVal = element.getAttribute(ATTRIBUTE_CONREF_END);
        if (conrefEndVal != null) {
            endRangePath = this.getRangeEndPath(element, systemID, conrefEndVal, isConKeyRef);
        }
        String sourceClass = null;
        AttrValue clazz = element.getAttribute(ATTRIBUTE_CLASS);
        if (clazz != null) {
            sourceClass = clazz.getValue();
        }
        String[] topicPath = this.getTopicPath((String)targetTopicID);
        DITAConRefResolver.computeTopicIdForSelfLink(element, topicPath);
        DITAXMLReaderWrapper readerWrapper = new DITAXMLReaderWrapper(readerWithCache.getXmlReader(), topicPath, endRangePath, sourceClass, isConKeyRef){

            @Override
            public void parse(InputSource input) throws IOException, SAXException {
                try {
                    DITAConRefResolver.this.grammarCacheInUse = true;
                    super.parse(input);
                }
                finally {
                    DITAConRefResolver.this.grammarCacheInUse = false;
                }
            }
        };
        return new SAXSource(readerWrapper, inputSource);
    }

    private static void computeTopicIdForSelfLink(AuthorElement element, String[] topicPath) {
        if (topicPath != null && topicPath.length > 0 && ".".equals(topicPath[0])) {
            for (AuthorElement currentNode = element; currentNode != null; currentNode = currentNode.getParent()) {
                AuthorElement currentElem;
                AttrValue currentClazz;
                if (!(currentNode instanceof AuthorElement) || (currentClazz = (currentElem = currentNode).getAttribute(ATTRIBUTE_CLASS)) == null || !currentClazz.getValue().contains(TOPIC_CLASS_FRAG)) continue;
                AttrValue currentID = currentElem.getAttribute(ATTRIBUTE_ID);
                if (currentID == null) break;
                topicPath[0] = currentID.getValue();
                break;
            }
        }
    }

    private static void treatKeyNotFound(Reference conRef, String keyrefValWithOutScope, String keyrefValWithScope) throws ReferenceResolverException {
        if (conRef == null) {
            ReferenceResolverException ex = new ReferenceResolverException(keyrefValWithOutScope, "Key definition not found for key reference: " + keyrefValWithScope, false, false);
            ReferenceErrorResolver ditaKeysErrorResolver = authorAccess -> DITAAccess.resolveKeyNotFoundError((AuthorAccess)authorAccess, (String)keyrefValWithScope);
            ex.setErrorResolver(ditaKeysErrorResolver);
            throw ex;
        }
    }

    private static SAXSource resolveCoderef(AuthorAccess authorAccess, EntityResolver entityResolver, Reference conRef) throws SAXException, IOException {
        Object absoluteURL = conRef.getTopicID() != null ? conRef.getUri() + "#" + conRef.getTopicID() : conRef.getUri();
        InputSource inputSource = entityResolver.resolveEntity(null, (String)absoluteURL);
        if (inputSource == null) {
            inputSource = new InputSource((String)absoluteURL);
        }
        TextReferenceReader reader = new TextReferenceReader((String)absoluteURL, "UTF8", authorAccess.getUtilAccess());
        reader.setEntityResolver(entityResolver);
        return new SAXSource(reader, inputSource);
    }

    private String[] getRangeEndPath(AuthorElement element, String systemID, AttrValue conrefEndVal, boolean isConKeyRef) {
        Reference conRefEnd = null;
        try {
            conRefEnd = DITAAccess.parseDITAHref((String)systemID, (String)conrefEndVal.getValue(), (boolean)true);
        }
        catch (MalformedURLException e) {
            ReferenceResolverException rre = new ReferenceResolverException("Conref end:" + e.getMessage(), false, false);
            rre.initCause((Throwable)e);
            throw rre;
        }
        String[] endRangePath = null;
        if (conRefEnd != null && conRefEnd.getTopicID() != null && conRefEnd.getTopicID().length() > 0) {
            endRangePath = this.getTopicPath(conRefEnd.getTopicID());
            DITAConRefResolver.computeTopicIdForSelfLink(element, endRangePath);
            if (isConKeyRef && endRangePath != null && endRangePath.length > 0) {
                endRangePath = new String[]{endRangePath[endRangePath.length - 1]};
            }
        }
        return endRangePath;
    }

    private static SAXSource resolveHrefReference(String hrefValue, AuthorElement element, AuthorAccess authorAccess, EntityResolver entityResolver) {
        SAXSource saxSource = null;
        String referenceSystemId = authorAccess.getXMLUtilAccess().resolvePathThroughCatalogs(element.getXMLBaseURL(), hrefValue, false, true).toExternalForm();
        if (referenceSystemId != null) {
            String[] tokens;
            InputSource inputSource = new InputSource(referenceSystemId);
            String charset = "UTF8";
            AttrValue formatAttr = element.getAttribute(ATTRIBUTE_FORMAT);
            if (formatAttr != null && (tokens = formatAttr.getValue().trim().split("[;=]")).length >= 3 && "charset".equals(tokens[1].trim())) {
                charset = tokens[2].trim();
            }
            TextReferenceReader reader = new TextReferenceReader(referenceSystemId, charset, authorAccess.getUtilAccess());
            reader.setEntityResolver(entityResolver);
            saxSource = new SAXSource(reader, inputSource);
        }
        return saxSource;
    }

    private SAXSource resolveKeyrefReference(String keyref, String classValue, AuthorElement element, String systemID, AuthorAccess authorAccess) {
        KeyInfo keyInfo;
        SAXSource saxSource = null;
        LinkedHashMap keys = DITAAccess.getKeys((URL)element.getXMLBaseURL(), (ContextKeyManager)this.keyManagerProvider.getContextKeyManager());
        if (keys != null && (keyInfo = (KeyInfo)keys.get(keyref = DITAAccess.rewriteKeyref((LinkedHashMap)DITAAccess.getURLKeyScopeContexts((URL)element.getXMLBaseURL(), (ContextKeyManager)this.keyManagerProvider.getContextKeyManager()), (LinkedHashMap)keys, (AuthorNode)element, (String)keyref))) != null) {
            String linkContent = null;
            if (keyInfo.getMetaContentProvider() != null) {
                linkContent = keyInfo.getMetaContentProvider().getContent(classValue);
            }
            if (linkContent == null && Boolean.TRUE.equals(keyInfo.getLocktitle()) && keyInfo.getNavTitle() != null) {
                linkContent = keyInfo.getNavTitle();
            }
            if (linkContent == null) {
                linkContent = this.parseReferencedTopic(systemID, keyInfo);
            }
            if (linkContent != null) {
                saxSource = new SAXSource(authorAccess.getXMLUtilAccess().newNonValidatingXMLReader(), new InputSource(new StringReader("<okr xmlns='http://www.oxygenxml.com/extensions/author'>" + linkContent + "</okr>")));
            }
        }
        return saxSource;
    }

    private String parseReferencedTopic(String systemID, KeyInfo keyInfo) {
        String linkContent = null;
        URL hrefLocation = keyInfo.getHrefLocation();
        if (hrefLocation != null && keyInfo.getAttributes() != null && DITAAccess.isKeyDefToDITAResource((KeyInfo)keyInfo)) {
            try {
                if (!hrefLocation.toExternalForm().equals(systemID)) {
                    linkContent = DITAAccess.computeLinkText(null, null, (String)hrefLocation.toExternalForm(), (String)systemID, (KeysManagerBase)this.keyManagerProvider.getContextKeyManager());
                }
            }
            catch (Exception e) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
        }
        return linkContent;
    }

    protected String[] getTopicPath(String value) {
        String[] path = null;
        if (value != null) {
            StringTokenizer tokenizer = new StringTokenizer(value, "/", false);
            path = new String[tokenizer.countTokens()];
            int i = 0;
            while (tokenizer.hasMoreTokens()) {
                path[i] = tokenizer.nextToken();
                ++i;
            }
        }
        return path;
    }

    public String getDescription() {
        return "Resolves the 'conkeyref/conref/keyref' references";
    }

    public String getReferenceUniqueID(AuthorNode node) {
        String id = null;
        if (node.getType() == 0) {
            AuthorElement element = (AuthorElement)node;
            AttrValue attrValue = element.getAttribute(ATTRIBUTE_CONKEYREF);
            if (attrValue != null) {
                id = attrValue.getValue();
            } else {
                attrValue = element.getAttribute(ATTRIBUTE_CONREF);
                if (attrValue != null) {
                    id = attrValue.getValue();
                } else {
                    attrValue = element.getAttribute(ATTRIBUTE_KEYREF);
                    if (attrValue != null) {
                        id = attrValue.getValue();
                    } else {
                        attrValue = element.getAttribute(ATTRIBUTE_HREF);
                        if (attrValue != null) {
                            id = attrValue.getValue();
                        }
                    }
                }
            }
        }
        return id;
    }

    public boolean isReferenceChanged(AuthorNode node, String attributeName) {
        return ATTRIBUTE_CONKEYREF.equals(attributeName) || ATTRIBUTE_CONREF.equals(attributeName) || ATTRIBUTE_CONREF_END.equals(attributeName) || ATTRIBUTE_KEYREF.equals(attributeName) || ATTRIBUTE_CONACTION.equals(attributeName) || ATTRIBUTE_HREF.equals(attributeName);
    }

    public String getReferenceSystemID(AuthorNode node, AuthorAccess authorAccess) {
        String systemID = null;
        try {
            if (node.getType() == 0) {
                AuthorElement element = (AuthorElement)node;
                AttrValue attrValue = element.getAttribute(ATTRIBUTE_CONKEYREF);
                AttrValue classValue = element.getAttribute(ATTRIBUTE_CLASS);
                if (classValue != null && classValue.getValue().contains(CODEREF_CLASS)) {
                    attrValue = element.getAttribute(ATTRIBUTE_KEYREF);
                }
                if (attrValue != null) {
                    String keyrefVal = attrValue.getValue();
                    keyrefVal = DITAAccess.rewriteKeyref((LinkedHashMap)DITAAccess.getURLKeyScopeContexts((URL)node.getXMLBaseURL(), (ContextKeyManager)this.keyManagerProvider.getContextKeyManager()), (LinkedHashMap)DITAAccess.getKeys((URL)node.getXMLBaseURL(), (ContextKeyManager)this.keyManagerProvider.getContextKeyManager()), (AuthorNode)node, (String)keyrefVal);
                    URL absURL = DITAAccess.resolveKeyRef((URL)node.getXMLBaseURL(), (String)keyrefVal, (ContextKeyManager)this.keyManagerProvider.getContextKeyManager(), (boolean)true);
                    if (absURL != null) {
                        systemID = absURL.toString();
                    }
                }
                if (systemID == null) {
                    systemID = DITAConRefResolver.getConrefReferenceSystemID(element);
                }
                if (systemID == null) {
                    systemID = this.getKeyrefRefereceSystenID(element);
                }
                if (systemID == null && (attrValue = element.getAttribute(ATTRIBUTE_HREF)) != null) {
                    systemID = authorAccess.getXMLUtilAccess().resolvePathThroughCatalogs(element.getXMLBaseURL(), attrValue.getValue(), false, true).toExternalForm();
                }
            }
        }
        catch (MalformedURLException e) {
            logger.debug((Object)e, (Throwable)e);
        }
        return systemID;
    }

    private static String getConrefReferenceSystemID(AuthorElement element) throws MalformedURLException {
        Object systemID = null;
        AttrValue attrValue = element.getAttribute(ATTRIBUTE_CONREF);
        if (attrValue != null) {
            String attrStringVal = attrValue.getValue();
            Reference parseDITAHref = DITAAccess.parseDITAHref((String)(element.getXMLBaseURL() == null ? null : element.getXMLBaseURL().toString()), (String)attrStringVal, (boolean)true);
            if (parseDITAHref != null) {
                systemID = parseDITAHref.getUri();
                if (parseDITAHref.getTopicID() != null && parseDITAHref.getTopicID().length() > 0) {
                    systemID = (String)systemID + "#" + parseDITAHref.getTopicID();
                }
            }
            if (systemID == null) {
                systemID = new URL(element.getXMLBaseURL(), attrStringVal).toString();
            }
        }
        return systemID;
    }

    private String getKeyrefRefereceSystenID(AuthorElement element) {
        String systemID = null;
        AttrValue attrValue = element.getAttribute(ATTRIBUTE_KEYREF);
        if (attrValue != null) {
            KeyInfo keyInfo;
            String keyrefValue = attrValue.getValue();
            LinkedHashMap keys = DITAAccess.getKeys((URL)element.getXMLBaseURL(), (ContextKeyManager)this.keyManagerProvider.getContextKeyManager());
            keyrefValue = DITAAccess.rewriteKeyref((LinkedHashMap)DITAAccess.getURLKeyScopeContexts((URL)element.getXMLBaseURL(), (ContextKeyManager)this.keyManagerProvider.getContextKeyManager()), (LinkedHashMap)keys, (AuthorNode)element, (String)keyrefValue);
            if (keys != null && (keyInfo = (KeyInfo)keys.get(keyrefValue)) != null) {
                systemID = keyInfo.getDefinitionLocation().toString();
            }
        }
        return systemID;
    }

    public void checkTarget(AuthorNode node, AuthorDocument targetDocument) throws ValidatingReferenceResolverException {
        AuthorElement sourceElement;
        if (node.getType() == 0 && (sourceElement = (AuthorElement)node).getAttribute(ATTRIBUTE_KEYREF) != null) {
            return;
        }
        Object errorMessage = null;
        Object errorShortMessage = null;
        boolean sourceIsConrefPush = false;
        AuthorElement targetElement = targetDocument.getRootElement();
        if (targetElement != null && !targetElement.getName().equals(node.getName())) {
            AttrValue targetClass = targetElement.getAttribute(ATTRIBUTE_CLASS);
            if (targetClass == null) {
                errorMessage = "The target does not have a class attribute";
            } else if (node.getType() == 0) {
                AuthorElement sourceElement2 = (AuthorElement)node;
                AttrValue sourceClass = sourceElement2.getAttribute(ATTRIBUTE_CLASS);
                if (sourceClass != null) {
                    if (sourceClass.getValue().contains(CODEREF_CLASS)) {
                        return;
                    }
                    sourceIsConrefPush = sourceElement2.getAttribute(ATTRIBUTE_CONACTION) != null;
                    int inheritanceType = DITAAccess.getInheritanceType((String)sourceClass.getValue(), (String)targetClass.getValue());
                    if (sourceIsConrefPush) {
                        if (inheritanceType != 1 && inheritanceType != 2) {
                            errorMessage = "The source element \"" + sourceElement2.getName() + "\" with class value \"" + sourceClass.getValue() + "\" is not a specialization of target element \"" + targetElement.getName() + "\" with class value \"" + targetClass.getValue() + "\"";
                            errorShortMessage = "Target of conref push was not resolved";
                        }
                    } else if (inheritanceType != 0 && inheritanceType != 2) {
                        errorMessage = "The source element \"" + sourceElement2.getName() + "\" with class value \"" + sourceClass.getValue() + "\" is not a generalization of target element \"" + targetElement.getName() + "\" with class value \"" + targetClass.getValue() + "\"";
                        errorShortMessage = "Conref was not expanded";
                    }
                } else {
                    errorMessage = "The source does not have a class attribute";
                }
            } else {
                errorMessage = "The conref source is not an element";
            }
        }
        if (errorMessage != null) {
            String exMsg = (sourceIsConrefPush ? "Target of conref push was not resolved:\n" : "Conref was not expanded:\n") + errorMessage;
            throw new ValidatingReferenceResolverException((String)(errorShortMessage != null ? errorShortMessage : exMsg), exMsg);
        }
    }

    public void setResolveKeyrefsToMetaContentAsConrefs(boolean resolveKeyrefsAsConrefs) {
        this.resolveAlsoKeyRefs = resolveKeyrefsAsConrefs;
    }

    public String getCacheKey(AuthorNode node) {
        if (node != null && node.getType() == 0) {
            AuthorElement elem = (AuthorElement)node;
            StringBuilder sb = new StringBuilder();
            AttrValue ref = elem.getAttribute(ATTRIBUTE_HREF);
            if (ref == null) {
                ref = elem.getAttribute(ATTRIBUTE_CONREF);
            }
            if (ref != null) {
                try {
                    sb.append(URLUtil.getCanonicalURL((URL)new URL(elem.getXMLBaseURL(), ref.getValue())));
                }
                catch (MalformedURLException e) {
                    sb.append(elem.getXMLBaseURL()).append(ref.getValue());
                }
            }
            int attributesCount = elem.getAttributesCount();
            for (int i = 0; i < attributesCount; ++i) {
                String name = elem.getAttributeAtIndex(i);
                if (ATTRIBUTE_HREF.equals(name) || ATTRIBUTE_CONREF.equals(name)) continue;
                AttrValue value = elem.getAttribute(name);
                sb.append(" ");
                sb.append(name);
                sb.append("=\"");
                sb.append(value.getValue());
                sb.append("\" ,");
            }
            return sb.toString();
        }
        return super.getCacheKey(node);
    }
}

