/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.dita;

import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.basic.util.URLUtil;
import ro.sync.contentcompletion.xml.CIElement;
import ro.sync.contentcompletion.xml.Context;
import ro.sync.contentcompletion.xml.WhatElementsCanGoHereContext;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorSchemaManager;
import ro.sync.ecss.extensions.api.WebappCompatible;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible(value=true)
public class ShowDITAElementDocumentationOperation
implements AuthorOperation {
    private static final Logger logger = LoggerFactory.getLogger((String)ShowDITAElementDocumentationOperation.class.getName());

    public String getDescription() {
        return "Shows the current element documentation in reference manual.";
    }

    public void doOperation(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        CIElement element;
        int co = authorAccess.getEditorAccess().getCaretOffset();
        AuthorSchemaManager sm = authorAccess.getDocumentController().getAuthorSchemaManager();
        WhatElementsCanGoHereContext ctxt = null;
        try {
            ctxt = sm.createWhatElementsCanGoHereContext(co);
        }
        catch (BadLocationException e) {
            logger.warn((Object)e, (Throwable)e);
        }
        if (ctxt != null && (element = authorAccess.getDocumentController().getAuthorSchemaManager().getElementDescription((Context)ctxt)) != null) {
            URL docLink = null;
            String annotation = element.getAnnotation();
            if (annotation != null) {
                String regex = "<a(\\s+)href=\"([^\"]*?)\"[^>]*>DITA Specs<\\/a>";
                Pattern p = Pattern.compile(regex);
                Matcher m = p.matcher(annotation);
                if (m.find()) {
                    String group = m.group(2);
                    docLink = group != null ? URLUtil.convertToURL((String)group) : URLUtil.convertToURL((String)"https://www.oxygenxml.com/");
                }
                if (docLink != null) {
                    authorAccess.getWorkspaceAccess().openInExternalApplication(docLink, false, "html");
                }
            }
        }
    }

    public ArgumentDescriptor[] getArguments() {
        return null;
    }
}

