/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.dita;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.swing.text.BadLocationException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.basic.util.NumberFormatException;
import ro.sync.basic.util.NumberParserUtil;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.webapp.WebappRestSafe;
import ro.sync.ecss.extensions.commons.imagemap.operations.NewShapeDescriptor;
import ro.sync.ecss.extensions.commons.imagemap.operations.UpdateImageMapOperationBase;
import ro.sync.ecss.imagemap.Areas2SVGUtil;
import ro.sync.ecss.imagemap.SupportedFrameworks;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible
@WebappRestSafe
public class DITAUpdateImageMapOperation
extends UpdateImageMapOperationBase {
    private static final String ORIGINAL_LAYER_ATTR_NAME = "original-layer";
    private static final Logger logger = LoggerFactory.getLogger((String)DITAUpdateImageMapOperation.class.getName());

    @Override
    protected List<? extends NewShapeDescriptor> getNewShapesList(String svgText) throws AuthorOperationException {
        Document newMapDOM = this.getFrameworkSpecificImageMapDom(svgText);
        return DITAUpdateImageMapOperation.getNewShapesList(newMapDOM);
    }

    private Document getFrameworkSpecificImageMapDom(String svgText) throws AuthorOperationException {
        String imageMapXml = Areas2SVGUtil.fromSVG((String)svgText, (SupportedFrameworks)SupportedFrameworks.DITA);
        if (imageMapXml != null && !imageMapXml.trim().isEmpty()) {
            try {
                return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(imageMapXml)));
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                throw new AuthorOperationException("Cannot obtain the image map from internal model!", (Throwable)e);
            }
        }
        throw new AuthorOperationException("Cannot obtain the image map from internal model!");
    }

    private static List<DITANewShapeDescriptor> getNewShapesList(Document newMapDOM) {
        ArrayList<DITANewShapeDescriptor> list = new ArrayList<DITANewShapeDescriptor>();
        NodeList imageMapElements = newMapDOM.getElementsByTagName("area");
        for (int i = 0; i < imageMapElements.getLength(); ++i) {
            list.add(new DITANewShapeDescriptor((Element)imageMapElements.item(i)));
        }
        return list;
    }

    @Override
    protected AuthorElement[] getExistingShapesList(AuthorElement existingImageMap) {
        return existingImageMap.getElementsByLocalName("area");
    }

    @Override
    protected AuthorElement getImageMapElement(AuthorElement currentElement) {
        return (AuthorElement)(currentElement == null ? null : currentElement.getParentElement());
    }

    public static class DITANewShapeDescriptor
    implements NewShapeDescriptor {
        private Element elem;
        private final Optional<Integer> originalLayer;

        public DITANewShapeDescriptor(Element elem) {
            this.elem = elem;
            this.originalLayer = DITANewShapeDescriptor.getOriginalLayer(elem);
            elem.removeAttribute(DITAUpdateImageMapOperation.ORIGINAL_LAYER_ATTR_NAME);
        }

        @Override
        public Optional<String> serializeToXml() {
            try {
                StringWriter sw = new StringWriter();
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document newDocument = builder.newDocument();
                Node importedNode = newDocument.importNode(this.elem, true);
                newDocument.appendChild(importedNode);
                transformer.transform(new DOMSource(importedNode), new StreamResult(sw));
                return Optional.of(sw.toString());
            }
            catch (ParserConfigurationException | TransformerException e) {
                return Optional.empty();
            }
        }

        private static Optional<Integer> getOriginalLayer(Element shapeElement) {
            Optional<Integer> originalLayer = Optional.empty();
            String originalLayerAttr = shapeElement.getAttribute(DITAUpdateImageMapOperation.ORIGINAL_LAYER_ATTR_NAME);
            if (originalLayerAttr != null && !originalLayerAttr.isEmpty()) {
                try {
                    originalLayer = Optional.of(NumberParserUtil.valueOfInteger((String)originalLayerAttr));
                }
                catch (NumberFormatException e) {
                    logger.error("Unable to parse layer.", (Throwable)e);
                }
            }
            return originalLayer;
        }

        @Override
        public void mergeIntoOriginalShape(AuthorDocumentController controller, AuthorElement shapeElement) throws BadLocationException {
            AuthorElement[] shapeCoordsElems = shapeElement.getElementsByLocalName("coords");
            NodeList newShapeCoordsElems = this.elem.getElementsByTagName("coords");
            if (shapeCoordsElems != null && shapeCoordsElems.length > 0 && newShapeCoordsElems != null && newShapeCoordsElems.getLength() > 0) {
                Element newShapeCoordsElem = (Element)newShapeCoordsElems.item(0);
                AuthorElement shapeCoordsElem = shapeCoordsElems[0];
                int[] shapeCoords = new int[]{shapeCoordsElem.getStartOffset(), shapeCoordsElem.getEndOffset()};
                controller.delete(shapeCoords[0] + 1, shapeCoords[1] - 1);
                controller.insertText(shapeCoords[0] + 1, newShapeCoordsElem.getTextContent().trim());
            }
        }

        @Override
        public Optional<Integer> getOriginalLayer() {
            return this.originalLayer;
        }
    }
}

