/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.dita;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.basic.util.URLInfo;
import ro.sync.basic.util.URLUtil;
import ro.sync.basic.xml.BasicXmlUtil;
import ro.sync.contentcompletion.xml.ContextElement;
import ro.sync.contentcompletion.xml.WhatElementsCanGoHereContext;
import ro.sync.ecss.dita.ContextKeyManagerProvider;
import ro.sync.ecss.dita.DITAAccess;
import ro.sync.ecss.dita.DITAImposedReferenceType;
import ro.sync.ecss.dita.DITATextAccess;
import ro.sync.ecss.dita.KeysManagerBase;
import ro.sync.ecss.dita.MediaInfo;
import ro.sync.ecss.dita.reference.keyref.KeyInfo;
import ro.sync.ecss.extensions.api.text.TextPageExternalObjectInsertionHandler;
import ro.sync.ecss.extensions.api.text.TextPageOperationException;
import ro.sync.ecss.extensions.commons.MediaObjectsUtil;
import ro.sync.ecss.extensions.dita.DITAExternalObjectInsertionHandlerUtil;
import ro.sync.exml.editor.xmleditor.operations.context.RelativeInsertPosition;
import ro.sync.exml.workspace.api.editor.page.text.WSTextXMLSchemaManager;
import ro.sync.exml.workspace.api.editor.page.text.xml.TextOperationException;
import ro.sync.exml.workspace.api.editor.page.text.xml.WSXMLTextEditorPage;
import ro.sync.exml.workspace.api.editor.page.text.xml.WSXMLTextNodeRange;
import ro.sync.exml.workspace.api.editor.page.text.xml.XPathException;
import ro.sync.exml.workspace.api.util.UtilAccess;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class DITATextPageExternalObjectInsertionHandler
extends TextPageExternalObjectInsertionHandler {
    private static final String CLOSEST_RELATED_LINK_ELEMENT = "(ancestor-or-self::*[contains(@class, ' topic/topic ')][1]/*[contains(@class, ' topic/related-links ')])[1]";
    private static final String CLOSEST_TOPIC_ELEMENT = "ancestor-or-self::*[contains(@class, ' topic/topic ')][1]";
    private static final String CLASS_ATTRIBUTE_NAME = "class";
    private static final String TOPIC_CLASS_VALUE = " topic/topic ";
    private static final String BODY_CLASS_VALUE = " topic/body ";
    private static final String FOLLOWING_SIBLINGS = "following-sibling::*";
    private static final String FOLLOWING_TOPIC_SIBLINGS = "(following-sibling::*[contains(@class, ' topic/topic ')])[1]";
    private static final String RELATED_LINKS_XML_FRAGMENT = "<related-links/>";
    private static final String FIRST_TOPIC_ELEMENT = "/*[contains(@class, ' topic/topic ')][1]";
    private static final int TOPIC_END_TAG_LENGTH = 7;
    private static final Logger logger = LoggerFactory.getLogger((String)DITATextPageExternalObjectInsertionHandler.class.getName());
    private ContextKeyManagerProvider keyManagerProvider;

    public DITATextPageExternalObjectInsertionHandler() {
    }

    public DITATextPageExternalObjectInsertionHandler(ContextKeyManagerProvider keyManagerProvider) {
        this.keyManagerProvider = keyManagerProvider;
    }

    public boolean acceptsURLs(WSXMLTextEditorPage textAccess, List<URL> urls, int source) {
        return source == 5 || source == 8 || source == 7 || source == 1;
    }

    public void insertURLs(WSXMLTextEditorPage textAccess, List<URL> urlList, int source) throws TextPageOperationException {
        for (URL url : urlList) {
            if (source == 8) {
                this.insertContentReference(textAccess, url);
                continue;
            }
            KeyInfo keyInfo = DITATextPageExternalObjectInsertionHandler.detectKeyInfo(textAccess, url);
            if (keyInfo != null) {
                this.insertKeyInfo(textAccess, keyInfo, url);
                continue;
            }
            this.insertUrlAsReference(textAccess, url);
        }
    }

    private void insertKeyInfo(WSXMLTextEditorPage textAccess, KeyInfo key, URL originalUrlToInsert) throws TextPageOperationException {
        boolean isImage = DITAAccess.isKeyReferenceToImage((KeyInfo)key);
        boolean preferRelatedLinks = false;
        String fragToInsert = null;
        DITAImposedReferenceType imposedRefType = DITAAccess.detectInsertionType((URL)originalUrlToInsert);
        switch (imposedRefType) {
            case VARIABLE: {
                fragToInsert = DITATextPageExternalObjectInsertionHandler.computeKeyReferenceFragment(textAccess, key, true, false, false);
                break;
            }
            case FIGURE: {
                fragToInsert = DITATextAccess.buildFigureKeyrefImageXMLToInsert((WSXMLTextEditorPage)textAccess, null, (String)key.getKeyName());
                break;
            }
            case MEDIA: {
                if (isImage) {
                    fragToInsert = DITATextPageExternalObjectInsertionHandler.computeKeyReferenceFragment(textAccess, key, false, false, true);
                    break;
                }
                fragToInsert = DITATextPageExternalObjectInsertionHandler.computeMediaObjectFrag(this.keyManagerProvider, textAccess, key);
                break;
            }
            case XREF: 
            case NOT_IMPOSED: {
                preferRelatedLinks = this.preferRelatedLinks(textAccess);
                fragToInsert = DITATextPageExternalObjectInsertionHandler.computeKeyReferenceFragment(textAccess, key, false, preferRelatedLinks, isImage);
                if (!preferRelatedLinks) break;
                DITATextPageExternalObjectInsertionHandler.createRelatedLinksSection(textAccess);
                break;
            }
            default: {
                logger.warn(String.format("Unable to insert key '%s' as '%s'.", key.getKeyName(), imposedRefType));
            }
        }
        try {
            if (fragToInsert != null) {
                if (preferRelatedLinks) {
                    DITATextPageExternalObjectInsertionHandler.insertAsRelatedLink(textAccess, fragToInsert);
                } else {
                    textAccess.getDocumentController().insertXMLFragment(fragToInsert, textAccess.getCaretOffset());
                }
            }
        }
        catch (Exception e) {
            throw new TextPageOperationException(e.getMessage(), (Throwable)e, true);
        }
    }

    private static KeyInfo detectKeyInfo(WSXMLTextEditorPage textAccess, URL url) {
        String keyName = URLUtil.getURLParameterValue((URL)url, (String)"FullyQualifiedKeyName");
        return Optional.ofNullable(keyName).map(kn -> DITATextAccess.getKeyInfo((WSXMLTextEditorPage)textAccess, (String)keyName)).orElse(null);
    }

    private void insertUrlAsReference(WSXMLTextEditorPage textAccess, URL originalUrl) throws TextPageOperationException {
        URL nodeBaseUrl = DITATextAccess.getCurrentNodeBaseURL((WSXMLTextEditorPage)textAccess);
        WSTextXMLSchemaManager schemaManager = textAccess.getXMLSchemaManager();
        try {
            DITAImposedReferenceType insertionType = DITAAccess.detectInsertionType((URL)originalUrl);
            URL cleanUrl = DITATextPageExternalObjectInsertionHandler.removeOxyCustomQueryParams(originalUrl);
            boolean isHtmlReference = DITATextPageExternalObjectInsertionHandler.isHTMLReference(cleanUrl);
            boolean isMedia = MediaObjectsUtil.isMediaReference(cleanUrl);
            UtilAccess utilAccess = DITATextAccess.getUtilAccess();
            boolean isImage = utilAccess != null && utilAccess.isSupportedImageURL(cleanUrl);
            String[] referenceAttributeNameAndValue = DITAExternalObjectInsertionHandlerUtil.getReferenceAttributeNameAndValueInternal(this.keyManagerProvider, textAccess.getParentEditor().getEditorLocation(), nodeBaseUrl, cleanUrl, null, isMedia || isHtmlReference);
            switch (insertionType) {
                case FIGURE: {
                    this.createAndInsertFigureWithImageHref(textAccess, nodeBaseUrl, referenceAttributeNameAndValue);
                    break;
                }
                case MEDIA: {
                    if (isImage) {
                        DITATextPageExternalObjectInsertionHandler.createAndInsertImageRef(textAccess, nodeBaseUrl, schemaManager, referenceAttributeNameAndValue);
                        break;
                    }
                    DITATextPageExternalObjectInsertionHandler.createAndInsertMediaRef(textAccess, schemaManager, cleanUrl, referenceAttributeNameAndValue);
                    break;
                }
                case XREF: {
                    this.insertAsXref(textAccess, cleanUrl, nodeBaseUrl, schemaManager);
                    break;
                }
                case NOT_IMPOSED: {
                    if (isImage) {
                        DITATextPageExternalObjectInsertionHandler.createAndInsertImageRef(textAccess, nodeBaseUrl, schemaManager, referenceAttributeNameAndValue);
                        break;
                    }
                    if (isMedia) {
                        DITATextPageExternalObjectInsertionHandler.createAndInsertMediaRef(textAccess, schemaManager, cleanUrl, referenceAttributeNameAndValue);
                        break;
                    }
                    this.insertAsXref(textAccess, cleanUrl, nodeBaseUrl, schemaManager);
                    break;
                }
                default: {
                    logger.warn(String.format("Unable to insert resource '%s' as '%s'.", originalUrl, insertionType));
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new TextPageOperationException(e.getMessage(), (Throwable)e, true);
        }
    }

    private void insertAsXref(WSXMLTextEditorPage textAccess, URL resourceToInsert, URL nodeBaseUrl, WSTextXMLSchemaManager schemaManager) throws XPathException, TextOperationException {
        String[] refData = DITAExternalObjectInsertionHandlerUtil.getReferenceAttributeNameAndValueInternal(this.keyManagerProvider, textAccess.getParentEditor().getEditorLocation(), nodeBaseUrl, resourceToInsert, null, false);
        if (this.preferRelatedLinks(textAccess)) {
            DITATextPageExternalObjectInsertionHandler.createAndInsertElementInRelatedLinks(textAccess, nodeBaseUrl, schemaManager, refData);
        } else {
            String linkElementName = DITATextAccess.getPossibleElementQName((WSTextXMLSchemaManager)schemaManager, (String)" topic/xref ", (String)"xref");
            String fragment = DITATextAccess.buildNonMediaFragment((String[])refData, (String)linkElementName, (URL)nodeBaseUrl);
            textAccess.getDocumentController().insertXMLFragment(fragment, textAccess.getCaretOffset());
        }
    }

    private void createAndInsertFigureWithImageHref(WSXMLTextEditorPage textAccess, URL nodeBaseUrl, String[] referenceAttributeNameAndValue) throws TextOperationException {
        String figWithImageFragment = DITATextAccess.buildFigureHrefImageXMLToInsert((WSXMLTextEditorPage)textAccess, (URL)nodeBaseUrl, null, (String[])referenceAttributeNameAndValue);
        textAccess.getDocumentController().insertXMLFragment(figWithImageFragment, textAccess.getCaretOffset());
    }

    private static void createAndInsertImageRef(WSXMLTextEditorPage textAccess, URL nodeBaseUrl, WSTextXMLSchemaManager schemaManager, String[] referenceAttributeNameAndValue) throws TextOperationException {
        String elementTag = DITATextAccess.getPossibleElementQName((WSTextXMLSchemaManager)schemaManager, (String)" topic/image ", (String)"image");
        String imageFragment = DITATextAccess.buildNonMediaFragment((String[])referenceAttributeNameAndValue, (String)elementTag, (URL)nodeBaseUrl);
        textAccess.getDocumentController().insertXMLFragment(imageFragment, textAccess.getCaretOffset());
    }

    private static void createAndInsertMediaRef(WSXMLTextEditorPage textAccess, WSTextXMLSchemaManager schemaManager, URL resourceURL, String[] referenceAttributeNameAndValue) throws TextOperationException {
        String referenceUsedToDetectParams = referenceAttributeNameAndValue[1];
        if ("datakeyref".equals(referenceAttributeNameAndValue[0])) {
            referenceUsedToDetectParams = resourceURL.toExternalForm();
        }
        String outputClass = MediaObjectsUtil.detectOutputclass(referenceUsedToDetectParams);
        String mediaElementName = DITATextPageExternalObjectInsertionHandler.getMostUsedMediaElementNameToDrop(textAccess, referenceAttributeNameAndValue[0], outputClass);
        MediaInfo mediaInfo = new MediaInfo(referenceAttributeNameAndValue[0].equals("data") ? referenceAttributeNameAndValue[1] : null, referenceAttributeNameAndValue[0].equals("datakeyref") ? referenceAttributeNameAndValue[1] : null, null, null, null, null, outputClass, MediaObjectsUtil.isEmbeddedContent(referenceUsedToDetectParams));
        String mediaFragment = DITATextPageExternalObjectInsertionHandler.computeMediaReferenceXMLToInsert(schemaManager, mediaInfo.getProperties(), mediaElementName);
        textAccess.getDocumentController().insertXMLFragment(mediaFragment, textAccess.getCaretOffset());
    }

    private static void createAndInsertElementInRelatedLinks(WSXMLTextEditorPage textAccess, URL nodeBaseUrl, WSTextXMLSchemaManager schemaManager, String[] referenceAttributeNameAndValue) throws XPathException, TextOperationException {
        String linkElementName = DITATextAccess.getPossibleElementQName((WSTextXMLSchemaManager)schemaManager, (String)" topic/link ", (String)"link");
        String fragment = DITATextAccess.buildNonMediaFragment((String[])referenceAttributeNameAndValue, (String)linkElementName, (URL)nodeBaseUrl);
        DITATextPageExternalObjectInsertionHandler.insertAsRelatedLink(textAccess, fragment);
    }

    private static void insertAsRelatedLink(WSXMLTextEditorPage textAccess, String fragment) throws XPathException, TextOperationException {
        DITATextPageExternalObjectInsertionHandler.createRelatedLinksSection(textAccess);
        Object[] evaluateXPath = textAccess.evaluateXPath(CLOSEST_RELATED_LINK_ELEMENT);
        if (evaluateXPath.length > 0) {
            textAccess.getDocumentController().insertXMLFragment(fragment, CLOSEST_RELATED_LINK_ELEMENT, RelativeInsertPosition.INSERT_LOCATION_AS_LAST_CHILD);
        }
    }

    private boolean preferRelatedLinks(WSXMLTextEditorPage tp) {
        boolean prefer = false;
        try {
            Object[] currentElements;
            WSXMLTextNodeRange[] relLinksRange = tp.findElementsByXPath(CLOSEST_RELATED_LINK_ELEMENT);
            if (relLinksRange != null && relLinksRange.length == 1) {
                int startRellinks = tp.getOffsetOfLineStart(relLinksRange[0].getStartLine()) + relLinksRange[0].getStartColumn() - 1;
                int endRellinks = tp.getOffsetOfLineStart(relLinksRange[0].getEndLine()) + relLinksRange[0].getEndColumn() - 1;
                if (startRellinks <= tp.getCaretOffset() && tp.getCaretOffset() <= endRellinks) {
                    prefer = true;
                }
            }
            if (!prefer && (currentElements = tp.evaluateXPath(".")) != null && currentElements.length == 1 && currentElements[0] instanceof Node) {
                Node currentNode = (Node)currentElements[0];
                if (currentNode instanceof Element) {
                    Element element = (Element)currentNode;
                    Node parentNode = element.getParentNode();
                    String clazzValue = element.getAttribute(CLASS_ATTRIBUTE_NAME);
                    if (clazzValue != null && clazzValue.contains(TOPIC_CLASS_VALUE)) {
                        ContextElement previous;
                        String previousClazzValue;
                        WhatElementsCanGoHereContext ctxt = tp.getXMLSchemaManager().createWhatElementsCanGoHereContext(tp.getCaretOffset());
                        List previousSiblings = ctxt.getPreviousSiblingElements();
                        if (previousSiblings != null && !previousSiblings.isEmpty() && (previousClazzValue = ctxt.getDefaultAttributeValue(previous = (ContextElement)previousSiblings.get(previousSiblings.size() - 1), CLASS_ATTRIBUTE_NAME)) != null && previousClazzValue.contains(BODY_CLASS_VALUE)) {
                            prefer = true;
                        }
                        if (!prefer && previousSiblings != null && !previousSiblings.isEmpty()) {
                            for (ContextElement ce : previousSiblings) {
                                String clazzVal = ctxt.getDefaultAttributeValue(ce, CLASS_ATTRIBUTE_NAME);
                                if (clazzVal == null || !clazzVal.contains(TOPIC_CLASS_VALUE)) continue;
                                prefer = true;
                                break;
                            }
                        }
                        if (!prefer && parentNode instanceof org.w3c.dom.Document) {
                            prefer = true;
                        }
                    } else if (clazzValue != null && clazzValue.contains(BODY_CLASS_VALUE)) {
                        String text;
                        Document document = tp.getDocument();
                        if (tp.getCaretOffset() > 7 && (text = document.getText(tp.getCaretOffset() - 7, 7)) != null && text.contains("body")) {
                            prefer = true;
                        }
                    }
                } else if (currentNode instanceof org.w3c.dom.Document) {
                    prefer = true;
                }
            }
        }
        catch (BadLocationException | XPathException e) {
            logger.warn((Object)e, e);
        }
        return prefer;
    }

    private static String computeKeyReferenceFragment(WSXMLTextEditorPage textAccess, KeyInfo key, boolean forceInsertAsVariableKeyref, boolean preferRelatedLinks, boolean isImage) {
        String frag = null;
        String qName = DITATextAccess.computeKeyReferenceElementName((WSXMLTextEditorPage)textAccess, (KeyInfo)key, (boolean)isImage, (boolean)forceInsertAsVariableKeyref, (boolean)preferRelatedLinks);
        if (qName != null) {
            frag = "<" + qName + " keyref=\"" + key.getKeyName() + "\"/>";
        }
        return frag;
    }

    private static void createRelatedLinksSection(WSXMLTextEditorPage textAccess) {
        try {
            Object[] evaluateXPath = textAccess.evaluateXPath(CLOSEST_RELATED_LINK_ELEMENT);
            if (evaluateXPath == null || evaluateXPath.length <= 0) {
                Object[] currentTopic = textAccess.evaluateXPath(CLOSEST_TOPIC_ELEMENT);
                if (currentTopic.length == 1) {
                    DITATextPageExternalObjectInsertionHandler.createRelatedLinksSectionInternal(textAccess);
                } else {
                    textAccess.getDocumentController().insertXMLFragment(RELATED_LINKS_XML_FRAGMENT, FIRST_TOPIC_ELEMENT, RelativeInsertPosition.INSERT_LOCATION_AS_LAST_CHILD);
                }
            }
        }
        catch (TextOperationException | XPathException e) {
            logger.error((Object)e, e);
        }
    }

    private static void createRelatedLinksSectionInternal(WSXMLTextEditorPage textAccess) throws XPathException, TextOperationException {
        try {
            WhatElementsCanGoHereContext ctxt = textAccess.getXMLSchemaManager().createWhatElementsCanGoHereContext(textAccess.getCaretOffset());
            List previousSiblings = ctxt.getPreviousSiblingElements();
            if (previousSiblings != null && !previousSiblings.isEmpty()) {
                boolean rightAfterBody;
                ContextElement contextElement = (ContextElement)previousSiblings.get(previousSiblings.size() - 1);
                String clazzVal = ctxt.getDefaultAttributeValue(contextElement, CLASS_ATTRIBUTE_NAME);
                boolean bl = rightAfterBody = clazzVal != null && clazzVal.contains(BODY_CLASS_VALUE);
                if (rightAfterBody && textAccess.evaluateXPath(FOLLOWING_SIBLINGS).length > 0) {
                    if (textAccess.evaluateXPath(FOLLOWING_TOPIC_SIBLINGS).length > 0) {
                        textAccess.getDocumentController().insertXMLFragment(RELATED_LINKS_XML_FRAGMENT, FOLLOWING_TOPIC_SIBLINGS, RelativeInsertPosition.INSERT_LOCATION_BEFORE);
                    } else {
                        textAccess.getDocumentController().insertXMLFragment(RELATED_LINKS_XML_FRAGMENT, textAccess.getCaretOffset());
                    }
                } else {
                    textAccess.getDocumentController().insertXMLFragment(RELATED_LINKS_XML_FRAGMENT, CLOSEST_TOPIC_ELEMENT, RelativeInsertPosition.INSERT_LOCATION_AS_LAST_CHILD);
                }
            } else {
                textAccess.getDocumentController().insertXMLFragment(RELATED_LINKS_XML_FRAGMENT, CLOSEST_TOPIC_ELEMENT, RelativeInsertPosition.INSERT_LOCATION_AS_LAST_CHILD);
            }
        }
        catch (BadLocationException e) {
            logger.warn((Object)e, (Throwable)e);
        }
    }

    private static String computeMediaObjectFrag(ContextKeyManagerProvider keyManagerProvider, WSXMLTextEditorPage textAccess, KeyInfo keyInfo) {
        URL keyHrefLocation = keyInfo.getHrefLocation();
        String frag = null;
        boolean embeddedContent = keyHrefLocation != null && MediaObjectsUtil.isEmbeddedContent(keyHrefLocation.toExternalForm());
        String outputClass = DITAAccess.detectMediaObjectOutputclass((KeyInfo)keyInfo);
        WSTextXMLSchemaManager schemaManager = textAccess.getXMLSchemaManager();
        URL nodeBaseUrl = DITATextAccess.getCurrentNodeBaseURL((WSXMLTextEditorPage)textAccess);
        String[] ref = DITAExternalObjectInsertionHandlerUtil.getMediaReferenceAttributeNameAndValue(keyManagerProvider, textAccess.getParentEditor().getEditorLocation(), nodeBaseUrl, keyHrefLocation, null);
        MediaInfo mediaInfo = new MediaInfo(ref[0].equals("data") ? ref[1] : null, ref[0].equals("datakeyref") ? ref[1] : null, null, null, null, null, outputClass, embeddedContent);
        String mediaElementName = DITATextPageExternalObjectInsertionHandler.getMostUsedMediaElementNameToDrop(textAccess, ref[0], outputClass);
        frag = DITATextPageExternalObjectInsertionHandler.computeMediaReferenceXMLToInsert(schemaManager, mediaInfo.getProperties(), mediaElementName);
        return frag;
    }

    private void insertContentReference(WSXMLTextEditorPage textAccess, URL url) throws TextPageOperationException {
        String path = URLUtil.getURLParameterValue((URL)url, (String)"ReusableComponentTargetPath");
        String targetElementQName = URLUtil.getURLParameterValue((URL)url, (String)"ReusableComponentTargetQname");
        String elementClass = URLUtil.getURLParameterValue((URL)url, (String)"ReusableComponentElementClass");
        if (path != null && targetElementQName != null && elementClass != null) {
            url = URLUtil.removeQuery((URL)url);
            URL editorLocation = textAccess.getParentEditor().getEditorLocation();
            boolean insertedKey = false;
            String keyForUrl = DITAAccess.getKeyForUrl((KeysManagerBase)(this.keyManagerProvider != null ? this.keyManagerProvider.getContextKeyManager() : null), (URL)url, (URL)editorLocation);
            if (keyForUrl != null) {
                int indexOf = path.indexOf(47);
                if (indexOf != -1) {
                    path = path.substring(indexOf + 1);
                }
                String conkeyrefValue = keyForUrl + "/" + path;
                try {
                    textAccess.getDocumentController().insertXMLFragment("<" + targetElementQName + " conkeyref=\"" + conkeyrefValue + "\"/>", textAccess.getCaretOffset());
                    insertedKey = true;
                }
                catch (TextOperationException e) {
                    throw new TextPageOperationException(e.getMessage(), (Throwable)e);
                }
            }
            if (!insertedKey) {
                String relativeLocation = URLUtil.makeRelative((URL)editorLocation, (URL)url, (boolean)true, (boolean)false);
                String conrefAttrValue = relativeLocation + "#" + path;
                try {
                    textAccess.getDocumentController().insertXMLFragment("<" + targetElementQName + " conref=\"" + conrefAttrValue + "\"/>", textAccess.getCaretOffset());
                }
                catch (TextOperationException e) {
                    throw new TextPageOperationException(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private static String computeMediaReferenceXMLToInsert(WSTextXMLSchemaManager schemaManager, Map<String, String> mediaProperties, String mediaElementName) {
        String fragment = "video".equals(mediaElementName) || "audio".equals(mediaElementName) ? DITATextPageExternalObjectInsertionHandler.computeVideoAndAudioReferenceXMLToInsert(schemaManager, mediaProperties, mediaElementName) : DITATextPageExternalObjectInsertionHandler.computeObjectReferenceXMLToInsert(mediaProperties, mediaElementName);
        return fragment;
    }

    private static String computeObjectReferenceXMLToInsert(Map<String, String> mediaProperties, String mediaElementName) {
        StringBuilder sb = new StringBuilder().append('<').append(mediaElementName).append(' ');
        String fullScreen = null;
        for (Map.Entry<String, String> entry : mediaProperties.entrySet()) {
            String keyName = entry.getKey();
            String value = entry.getValue();
            String attrNameToSet = null;
            if ("href".equals(keyName)) {
                attrNameToSet = "data";
                value = BasicXmlUtil.escapeAttributeValue((String)value);
            } else if ("keyref".equals(keyName)) {
                attrNameToSet = "datakeyref";
            } else if ("width".equals(keyName)) {
                attrNameToSet = "width";
            } else if ("height".equals(keyName)) {
                attrNameToSet = "height";
            } else if ("mediaType".equals(keyName)) {
                attrNameToSet = "outputclass";
            } else if ("allowfullscreen".equals(keyName)) {
                fullScreen = "<param name=\"allowfullscreen\"/>";
            }
            if (attrNameToSet == null || attrNameToSet.equals("allowfullscreen")) continue;
            sb.append(attrNameToSet).append("=\"").append(value).append("\" ");
        }
        sb.append('>');
        if (fullScreen != null) {
            sb.append(fullScreen);
        }
        sb.append("</").append(mediaElementName).append('>');
        return sb.toString();
    }

    private static String computeVideoAndAudioReferenceXMLToInsert(WSTextXMLSchemaManager schemaManager, Map<String, String> mediaProperties, String mediaElementName) {
        String sourceElementName;
        StringBuilder sb = new StringBuilder().append('<').append(mediaElementName).append(' ');
        String href = null;
        String keyref = null;
        for (Map.Entry<String, String> entry : mediaProperties.entrySet()) {
            String keyName = entry.getKey();
            String value = entry.getValue();
            String attrNameToSet = null;
            if ("href".equals(keyName)) {
                href = BasicXmlUtil.escapeAttributeValue((String)value);
            } else if ("keyref".equals(keyName)) {
                keyref = value;
            } else if ("width".equals(keyName)) {
                attrNameToSet = "width";
            } else if ("height".equals(keyName)) {
                attrNameToSet = "height";
            }
            if (attrNameToSet == null) continue;
            sb.append(attrNameToSet).append("=\"").append(value).append("\" ");
        }
        sb.append('>');
        if ((href != null || keyref != null) && (sourceElementName = DITATextAccess.getPossibleElementQName((WSTextXMLSchemaManager)schemaManager, (String)" media-d/media-source ", (String)"source")) != null) {
            sb.append('<').append(sourceElementName).append(' ');
            if (href != null) {
                sb.append("value").append("=\"").append(href).append("\" ");
            }
            if (keyref != null) {
                sb.append("keyref").append("=\"").append(keyref).append("\" ");
            }
            sb.append("/>");
        }
        sb.append("</").append(mediaElementName).append('>');
        return sb.toString();
    }

    private static String getMostUsedMediaElementNameToDrop(WSXMLTextEditorPage textAccess, String imposedKeyAttribute, String mediaType) {
        List<String> allowedElements;
        List<String> allowedAudios;
        WSTextXMLSchemaManager schemaManager = textAccess.getXMLSchemaManager();
        int caretOffset = textAccess.getCaretOffset();
        boolean fallbackToObject = true;
        String mostUsed = "object";
        if ("video".equals(mediaType) || "iframe".equals(mediaType)) {
            List<String> allowedVideos = Arrays.asList(DITATextAccess.collectPossibleElements((String)imposedKeyAttribute, null, (WSTextXMLSchemaManager)schemaManager, (int)caretOffset, (String[])new String[]{"/video "}));
            if (allowedVideos != null && !allowedVideos.isEmpty() && allowedVideos.get(0) != null) {
                mostUsed = allowedVideos.get(0);
                fallbackToObject = false;
            }
        } else if ("audio".equals(mediaType) && (allowedAudios = Arrays.asList(DITATextAccess.collectPossibleElements((String)imposedKeyAttribute, null, (WSTextXMLSchemaManager)schemaManager, (int)caretOffset, (String[])new String[]{"/audio "}))) != null && !allowedAudios.isEmpty() && allowedAudios.get(0) != null) {
            mostUsed = allowedAudios.get(0);
            fallbackToObject = false;
        }
        if (fallbackToObject && (allowedElements = Arrays.asList(DITATextAccess.collectPossibleElements((String)imposedKeyAttribute, null, (WSTextXMLSchemaManager)schemaManager, (int)caretOffset, (String[])new String[]{" topic/object "}))) != null && !allowedElements.isEmpty() && allowedElements.get(0) != null && !allowedElements.contains(mostUsed)) {
            mostUsed = allowedElements.get(0);
        }
        return mostUsed;
    }

    private static URL removeOxyCustomQueryParams(URL url) {
        try {
            URLInfo info = URLUtil.getURLInfo((URL)url);
            return info.getURL(true, false, true);
        }
        catch (MalformedURLException malformedURLException) {
            return url;
        }
    }

    private static boolean isHTMLReference(URL url) {
        UtilAccess utilAccess = DITATextAccess.getUtilAccess();
        if (utilAccess != null) {
            String contentType = utilAccess.getContentType(url.toExternalForm());
            return "text/html".equalsIgnoreCase(contentType) || "application/xhtml+xml".equalsIgnoreCase(contentType);
        }
        return false;
    }
}

