/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.dita;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.function.Supplier;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.contentcompletion.xml.CIAttribute;
import ro.sync.contentcompletion.xml.CIElement;
import ro.sync.contentcompletion.xml.CIValue;
import ro.sync.contentcompletion.xml.Context;
import ro.sync.contentcompletion.xml.ContextElement;
import ro.sync.contentcompletion.xml.SchemaManagerFilterBase;
import ro.sync.contentcompletion.xml.WhatAttributesCanGoHereContext;
import ro.sync.contentcompletion.xml.WhatElementsCanGoHereContext;
import ro.sync.contentcompletion.xml.WhatPossibleValuesHasAttributeContext;
import ro.sync.ecss.dita.ContextKeyManager;
import ro.sync.ecss.dita.ContextKeyManagerProvider;
import ro.sync.ecss.dita.DITAAccess;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class DITASchemaManagerFilter
extends SchemaManagerFilterBase {
    private static final ImmutableSet<String> TITLE_PARENTS = ImmutableSet.of((Object)"section", (Object)"example");
    private static final String TITLE_ELEMENT_NAME = "title";
    private final String documentTypeName;
    private ContextKeyManagerProvider keyManagerProvider;
    private Supplier<String> userNameProvider;

    public DITASchemaManagerFilter(String documentTypeName, ContextKeyManagerProvider contextKeyManagerProvider, Supplier<String> userNameProvider) {
        this.documentTypeName = documentTypeName;
        this.keyManagerProvider = contextKeyManagerProvider;
        this.userNameProvider = userNameProvider;
    }

    public List<CIValue> filterAttributeValues(List<CIValue> attributeValues, WhatPossibleValuesHasAttributeContext context) {
        ContextKeyManager contextKeyManager = this.keyManagerProvider.getContextKeyManager();
        return DITAAccess.filterAttributeValues(attributeValues, (WhatPossibleValuesHasAttributeContext)context, (ContextKeyManager)contextKeyManager, (String)this.documentTypeName, null);
    }

    public List<CIAttribute> filterAttributes(List<CIAttribute> attributes, WhatAttributesCanGoHereContext context) {
        return attributes;
    }

    public List<CIValue> filterElementValues(List<CIValue> elementValues, Context context) {
        return elementValues;
    }

    public List<CIElement> filterElements(List<CIElement> elements, WhatElementsCanGoHereContext context) {
        String authorName = this.userNameProvider.get();
        List elems = DITAAccess.filterElements(elements, (WhatElementsCanGoHereContext)context, (String)authorName);
        DITASchemaManagerFilter.disallowDuplicateTitlesInElements(context, elems, TITLE_PARENTS);
        DITASchemaManagerFilter.disallowElementsBeforeTitle(context, elems, TITLE_PARENTS);
        return elems;
    }

    private static void disallowElementsBeforeTitle(WhatElementsCanGoHereContext context, List<CIElement> elems, Set<String> parentNames) {
        if (context != null && elems != null && !elems.isEmpty()) {
            Stack elemsStack = context.getElementStack();
            ContextElement parent = null;
            if (elemsStack != null && !elemsStack.isEmpty()) {
                parent = (ContextElement)elemsStack.peek();
            }
            if (parent != null && parentNames.contains(parent.getQName())) {
                List nextSiblingElements = context.getNextSiblingElements();
                ContextElement nextSibling = null;
                if (nextSiblingElements != null && !nextSiblingElements.isEmpty()) {
                    nextSibling = (ContextElement)nextSiblingElements.get(0);
                }
                if (nextSibling != null && TITLE_ELEMENT_NAME.equals(nextSibling.getQName())) {
                    elems.clear();
                }
            }
        }
    }

    private static void disallowDuplicateTitlesInElements(WhatElementsCanGoHereContext context, List<CIElement> elems, Set<String> parentNames) {
        ContextElement peek;
        Stack elemsStack;
        if (context != null && elems != null && !elems.isEmpty() && (elemsStack = context.getElementStack()) != null && !elemsStack.isEmpty() && (peek = (ContextElement)elemsStack.peek()) != null && parentNames.contains(peek.getQName())) {
            List nextSiblings;
            int i;
            boolean hasNextOrPrevTitle = false;
            List prevSiblings = context.getPreviousSiblingElements();
            if (prevSiblings != null) {
                for (i = 0; i < prevSiblings.size(); ++i) {
                    ContextElement contextElement = (ContextElement)prevSiblings.get(i);
                    if (!TITLE_ELEMENT_NAME.equals(contextElement.getQName())) continue;
                    hasNextOrPrevTitle = true;
                    break;
                }
            }
            if (!hasNextOrPrevTitle && (nextSiblings = context.getNextSiblingElements()) != null) {
                for (int i2 = 0; i2 < nextSiblings.size(); ++i2) {
                    ContextElement contextElement = (ContextElement)nextSiblings.get(i2);
                    if (!TITLE_ELEMENT_NAME.equals(contextElement.getQName())) continue;
                    hasNextOrPrevTitle = true;
                    break;
                }
            }
            if (hasNextOrPrevTitle) {
                for (i = 0; i < elems.size(); ++i) {
                    CIElement elem = elems.get(i);
                    if (!TITLE_ELEMENT_NAME.equals(elem.getQName())) continue;
                    elems.remove(i);
                    break;
                }
            }
        }
    }

    public String getDescription() {
        return "DITA Schema Manager Filter";
    }
}

