/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.dita;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.dita.DITAAccess;
import ro.sync.ecss.extensions.api.link.Attr;
import ro.sync.ecss.extensions.api.link.ElementLocator;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class DITAMapKeyDefElementLocator
extends ElementLocator {
    private final String anchorKeyref;
    private final Stack<Set<String>> keyScopes = new Stack();
    private final Stack<Boolean> elemContainsKeyScopes = new Stack();

    public DITAMapKeyDefElementLocator(String link) {
        super(link);
        this.anchorKeyref = link.substring(link.indexOf("keyref(") + "keyref(".length(), link.length() - 1);
    }

    public void endElement(String uri, String localName, String name) {
        if (this.elemContainsKeyScopes.peek().booleanValue()) {
            this.keyScopes.pop();
        }
        this.elemContainsKeyScopes.pop();
    }

    public boolean startElement(String uri, String localName, String name, Attr[] atts) {
        Set<String> vals = DITAMapKeyDefElementLocator.getAttributeValues(atts, "keyscope");
        this.elemContainsKeyScopes.push(vals != null && !vals.isEmpty());
        if (vals != null) {
            this.keyScopes.push(vals);
        }
        boolean toReturn = false;
        Set<String> keyValues = DITAMapKeyDefElementLocator.getAttributeValues(atts, "keys");
        if (keyValues != null) {
            if (keyValues.contains(this.anchorKeyref)) {
                toReturn = true;
            } else {
                int dotIndex = this.anchorKeyref.indexOf(46);
                if (dotIndex != -1) {
                    block0: for (String keydefName : keyValues) {
                        List relativeKeyRefs;
                        if (!this.anchorKeyref.endsWith("." + keydefName) || (relativeKeyRefs = DITAAccess.computeQualifiedKeyNames((String)keydefName, this.keyScopes)) == null) continue;
                        for (String relKeyref : relativeKeyRefs) {
                            if (!this.anchorKeyref.endsWith(relKeyref)) continue;
                            toReturn = true;
                            break block0;
                        }
                    }
                }
            }
        }
        return toReturn;
    }

    private static Set<String> getAttributeValues(Attr[] atts, String attrName) {
        HashSet<String> keyDefs = null;
        for (int i = 0; i < atts.length; ++i) {
            if (!attrName.equals(atts[i].getQName())) continue;
            StringTokenizer st = new StringTokenizer(atts[i].getValue());
            while (st.hasMoreTokens()) {
                String key = st.nextToken();
                if (key.trim().length() <= 0) continue;
                if (keyDefs == null) {
                    keyDefs = new HashSet<String>();
                }
                keyDefs.add(key);
            }
            break;
        }
        return keyDefs;
    }
}

