/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.dita;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.basic.xml.BasicXmlUtil;
import ro.sync.contentcompletion.xml.SchemaManagerFilter;
import ro.sync.ecss.dita.ContextKeyManager;
import ro.sync.ecss.dita.ContextKeyManagerProvider;
import ro.sync.ecss.dita.DITAAccess;
import ro.sync.ecss.dita.reference.keyref.KeyInfo;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorActionEventHandler;
import ro.sync.ecss.extensions.api.AuthorExtensionStateListener;
import ro.sync.ecss.extensions.api.AuthorExternalObjectInsertionHandler;
import ro.sync.ecss.extensions.api.AuthorImageDecorator;
import ro.sync.ecss.extensions.api.AuthorReferenceResolver;
import ro.sync.ecss.extensions.api.AuthorSchemaAwareEditingHandler;
import ro.sync.ecss.extensions.api.AuthorTableCellSepProvider;
import ro.sync.ecss.extensions.api.AuthorTableCellSpanProvider;
import ro.sync.ecss.extensions.api.AuthorTableColumnWidthProvider;
import ro.sync.ecss.extensions.api.CustomAttributeValueContext;
import ro.sync.ecss.extensions.api.CustomResolverException;
import ro.sync.ecss.extensions.api.DITAAuthorActionEventHandler;
import ro.sync.ecss.extensions.api.EditPropertiesHandler;
import ro.sync.ecss.extensions.api.ExtensionsBundle;
import ro.sync.ecss.extensions.api.ProfilingConditionalTextProvider;
import ro.sync.ecss.extensions.api.ReferenceErrorResolver;
import ro.sync.ecss.extensions.api.UniqueAttributesRecognizer;
import ro.sync.ecss.extensions.api.access.EditingSessionContext;
import ro.sync.ecss.extensions.api.content.ClipboardFragmentProcessor;
import ro.sync.ecss.extensions.api.link.ElementLocatorProvider;
import ro.sync.ecss.extensions.api.link.IDTypeRecognizer;
import ro.sync.ecss.extensions.api.link.LinkTextResolver;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.spell.SpellCheckerHelper;
import ro.sync.ecss.extensions.api.table.operations.AuthorTableOperationsHandler;
import ro.sync.ecss.extensions.api.text.TextPageExternalObjectInsertionHandler;
import ro.sync.ecss.extensions.commons.table.support.DITATableCellInfoProvider;
import ro.sync.ecss.extensions.commons.table.support.DITATableCellSepInfoProvider;
import ro.sync.ecss.extensions.dita.DITAAuthorImageDecorator;
import ro.sync.ecss.extensions.dita.DITAAuthorTableOperationsHandler;
import ro.sync.ecss.extensions.dita.DITAElementLocatorProvider;
import ro.sync.ecss.extensions.dita.DITAExternalObjectInsertionHandler;
import ro.sync.ecss.extensions.dita.DITANodeRendererCustomizer;
import ro.sync.ecss.extensions.dita.DITASchemaAwareEditingHandler;
import ro.sync.ecss.extensions.dita.DITASchemaManagerFilter;
import ro.sync.ecss.extensions.dita.DITASpellCheckerHelper;
import ro.sync.ecss.extensions.dita.DITATextPageExternalObjectInsertionHandler;
import ro.sync.ecss.extensions.dita.EditImageMapOperation;
import ro.sync.ecss.extensions.dita.conref.DITAConRefResolver;
import ro.sync.ecss.extensions.dita.id.DITAIDTypeRecognizer;
import ro.sync.ecss.extensions.dita.id.DITAUniqueAttributesRecognizer;
import ro.sync.ecss.extensions.dita.link.DitaLinkTextResolver;
import ro.sync.exml.workspace.api.editor.page.ditamap.keys.MetaContentProvider;
import ro.sync.exml.workspace.api.node.customizer.XMLNodeRendererCustomizer;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class DITAExtensionsBundle
extends ExtensionsBundle
implements ContextKeyManagerProvider {
    private static final Logger logger = LoggerFactory.getLogger((String)DITAExtensionsBundle.class.getName());
    private static final String KEYREF_PREFIX = "Keyref ";
    private static final String KEYWORD_KEYREF_PREFIX = "KeyWordKeyref ";
    private DITAAuthorTableOperationsHandler ditaAuthorTableOperationsHandler;
    private DITAAuthorImageDecorator decorator;
    private DITAUniqueAttributesRecognizer uniqueAttributesRecognizer;
    private DITASchemaAwareEditingHandler ditaSchemaAwareEditingHandler;
    protected ContextKeyManager keyManager = ContextKeyManager.getDefault();
    private AuthorAccess authorAccess = null;
    protected final ContextKeyManagerProvider keyManagerProvider = new ContextKeyManagerProvider(){

        public ContextKeyManager getContextKeyManager() {
            return DITAExtensionsBundle.this.keyManager;
        }
    };
    private AuthorActionEventHandler handler;

    public AuthorExtensionStateListener createAuthorExtensionStateListener() {
        this.uniqueAttributesRecognizer = new DITAUniqueAttributesRecognizer();
        return new AuthorExtensionStateListener(){

            public String getDescription() {
                return DITAExtensionsBundle.this.uniqueAttributesRecognizer.getDescription();
            }

            public void deactivated(AuthorAccess authorAccess) {
                DITAExtensionsBundle.this.uniqueAttributesRecognizer.deactivated(authorAccess);
                DITAExtensionsBundle.this.authorAccess = null;
            }

            public void activated(AuthorAccess authorAccess) {
                DITAExtensionsBundle.this.uniqueAttributesRecognizer.activated(authorAccess);
                EditingSessionContext editingContext = authorAccess.getEditorAccess().getEditingContext();
                DITAExtensionsBundle.this.keyManager = DITAExtensionsBundle.this.createContextKeyManager(editingContext);
                DITAExtensionsBundle.this.authorAccess = authorAccess;
            }
        };
    }

    protected ContextKeyManager createContextKeyManager(EditingSessionContext context) {
        ContextKeyManager createdKeyManager = null;
        try {
            createdKeyManager = context.getContextKeyManager();
        }
        catch (Throwable t) {
            logger.debug(t.getMessage(), t);
        }
        if (createdKeyManager == null) {
            createdKeyManager = ContextKeyManager.getDefault();
        }
        return createdKeyManager;
    }

    public ClipboardFragmentProcessor getClipboardFragmentProcessor() {
        return this.uniqueAttributesRecognizer;
    }

    public AuthorReferenceResolver createAuthorReferenceResolver() {
        return new DITAConRefResolver(this.keyManagerProvider);
    }

    public AuthorTableCellSpanProvider createAuthorTableCellSpanProvider() {
        return new DITATableCellInfoProvider();
    }

    public AuthorTableColumnWidthProvider createAuthorTableColumnWidthProvider() {
        return new DITATableCellInfoProvider();
    }

    public AuthorTableCellSepProvider createAuthorTableCellSepProvider() {
        return new DITATableCellSepInfoProvider();
    }

    public String getDescription() {
        return "DITA extensions bundle implementation";
    }

    public String getDocumentTypeID() {
        return "DITA.document.type";
    }

    public UniqueAttributesRecognizer getUniqueAttributesIdentifier() {
        return this.uniqueAttributesRecognizer;
    }

    public ElementLocatorProvider createElementLocatorProvider() {
        return new DITAElementLocatorProvider();
    }

    public String customizeLinkTooltipDescription(URL currentEditorURL, AuthorNode contextNode, String linkHref, AuthorAccess authorAccess, String computedDescription) {
        if (computedDescription != null && linkHref != null && (linkHref.startsWith(KEYREF_PREFIX) || linkHref.startsWith(KEYWORD_KEYREF_PREFIX)) && authorAccess != null && authorAccess.getAuthorResourceBundle() != null) {
            String keyRefValue = null;
            keyRefValue = linkHref.startsWith(KEYREF_PREFIX) ? linkHref.substring(KEYREF_PREFIX.length()) : linkHref.substring(KEYWORD_KEYREF_PREFIX.length());
            computedDescription = authorAccess.getAuthorResourceBundle().getMessage("Key_reference") + ": " + keyRefValue + "\n" + (String)computedDescription;
        }
        return computedDescription;
    }

    public String customizeImageTooltipDescription(AuthorNode contextNode, AuthorAccess authorAccess, String computedDescription) {
        if (contextNode != null) {
            if (contextNode.getType() == 6) {
                contextNode = contextNode.getParent();
            }
            if (contextNode != null && contextNode.getType() == 0) {
                computedDescription = this.computeImageAltText(contextNode, authorAccess, computedDescription);
            }
        }
        return computedDescription;
    }

    private String computeImageAltText(AuthorNode contextNode, AuthorAccess authorAccess, String computedDescription) {
        String altText;
        MetaContentProvider metaContentProvider;
        URL contextURL;
        LinkedHashMap keys;
        KeyInfo ki;
        String keyrefValue;
        AuthorElement elem = (AuthorElement)contextNode;
        AttrValue keyrefAttr = elem.getAttribute("keyref");
        AttrValue classAttr = elem.getAttribute("class");
        if (keyrefAttr != null && classAttr != null && (keyrefValue = keyrefAttr.getValue()) != null && keyrefValue.length() > 0 && (ki = (KeyInfo)(keys = DITAAccess.getKeys((URL)(contextURL = contextNode.getXMLBaseURL()), (ContextKeyManager)this.keyManager)).get(keyrefValue = DITAAccess.rewriteKeyref((LinkedHashMap)DITAAccess.getURLKeyScopeContexts((URL)contextURL, (ContextKeyManager)this.keyManager), (LinkedHashMap)keys, (AuthorNode)contextNode, (String)keyrefValue))) != null && (metaContentProvider = ki.getMetaContentProvider()) != null && (altText = metaContentProvider.getContent(classAttr.getValue())) != null && !altText.isEmpty()) {
            int bodyIndex;
            String altTextDescription = authorAccess.getAuthorResourceBundle().getMessage("Image_alt_text") + ": " + altText;
            computedDescription = computedDescription == null ? altTextDescription : ((bodyIndex = ((String)computedDescription).indexOf("</body>")) != -1 ? ((String)computedDescription).substring(0, bodyIndex) + "<p>" + BasicXmlUtil.escape((String)altTextDescription) + "</p>" + ((String)computedDescription).substring(bodyIndex) : (String)computedDescription + "\n\n" + altTextDescription);
        }
        return computedDescription;
    }

    public URL resolveCustomHref(URL currentEditorURL, AuthorNode contextNode, String linkHref, AuthorAccess authorAccess) throws IOException, CustomResolverException {
        URL resolvedURL = null;
        if (linkHref != null && (linkHref.startsWith(KEYREF_PREFIX) || linkHref.startsWith(KEYWORD_KEYREF_PREFIX))) {
            resolvedURL = this.resolveCustomKeyref(currentEditorURL, contextNode, linkHref);
        } else if (linkHref != null && linkHref.startsWith("#./")) {
            if (authorAccess != null && currentEditorURL != null && !currentEditorURL.equals(authorAccess.getEditorAccess().getEditorLocation())) {
                try {
                    resolvedURL = new URL(authorAccess.getEditorAccess().getEditorLocation().toString() + linkHref);
                }
                catch (MalformedURLException ex) {
                    logger.error((Object)ex, (Throwable)ex);
                }
            }
        } else if (linkHref != null) {
            LinkedHashMap context;
            Stack ksStack;
            URL editorLocation;
            String href = null;
            if (contextNode != null) {
                AttrValue hrefAttr;
                AttrValue attr;
                AuthorElement elem = null;
                if (contextNode.getType() == 0) {
                    elem = (AuthorElement)contextNode;
                } else {
                    AuthorNode parent = contextNode.getParent();
                    if (parent != null && parent.getType() == 0) {
                        elem = (AuthorElement)parent;
                    }
                }
                if (elem != null && (attr = elem.getAttribute("class")) != null && attr.getValue().contains(" map/topicref ") && (hrefAttr = elem.getAttribute("href")) != null) {
                    href = hrefAttr.getValue();
                }
            }
            if (href != null && href.equals(linkHref) && (editorLocation = authorAccess.getEditorAccess().getEditorLocation()) != null && (ksStack = DITAAccess.computeKeyScopeStack((AuthorNode)contextNode, (LinkedHashMap)(context = this.keyManager.getURLKeyScopeContexts(editorLocation)))) != null && !ksStack.isEmpty()) {
                resolvedURL = new URL(authorAccess.getEditorAccess().getEditorLocation(), linkHref);
                resolvedURL = DITAAccess.attachKeyScopeInformation((URL)resolvedURL, (Stack)ksStack, (String)authorAccess.getEditorAccess().getEditorLocation().toString());
            }
        }
        return resolvedURL;
    }

    private URL resolveCustomKeyref(URL currentEditorURL, AuthorNode contextNode, String linkHref) throws CustomResolverException, MalformedURLException {
        URL contextURL = currentEditorURL;
        URL resolvedURL = null;
        if (contextNode != null) {
            contextURL = contextNode.getXMLBaseURL();
        }
        if (linkHref.startsWith(KEYREF_PREFIX)) {
            LinkedHashMap keys;
            String keyName;
            int slashIndex;
            String keyref = linkHref = linkHref.substring(KEYREF_PREFIX.length());
            String validationProblem = DITAAccess.checkValidKeyRef((String)keyref);
            if (validationProblem != null) {
                throw new CustomResolverException(validationProblem, null);
            }
            if (contextNode != null) {
                String hrefValue;
                AuthorElement elem;
                AttrValue hrefAttr;
                if (contextNode.getType() == 6) {
                    contextNode = contextNode.getParent();
                }
                if (contextNode != null && contextNode.getType() == 0 && (hrefAttr = (elem = (AuthorElement)contextNode).getAttribute("href")) != null && (hrefValue = hrefAttr.getValue()) != null && hrefValue.length() > 0) {
                    resolvedURL = new URL(currentEditorURL, hrefValue);
                }
            }
            if ((slashIndex = (keyName = keyref).indexOf(47)) != -1) {
                keyName = keyName.substring(0, slashIndex);
            }
            if ((keys = DITAAccess.getKeys((URL)contextURL, (ContextKeyManager)this.keyManager)) != null) {
                String rewrittenKeyref;
                if (!keys.containsKey(keyName) && contextNode != null && (rewrittenKeyref = DITAAccess.rewriteKeyref((LinkedHashMap)DITAAccess.getURLKeyScopeContexts((URL)contextURL, (ContextKeyManager)this.keyManager), (LinkedHashMap)keys, (AuthorNode)contextNode, (String)keyref)) != null && (slashIndex = (keyName = (keyref = rewrittenKeyref)).indexOf(47)) != -1) {
                    keyName = keyName.substring(0, slashIndex);
                }
                if (!keys.containsKey(keyName)) {
                    if (resolvedURL == null) {
                        final String fkeyName = keyName;
                        ReferenceErrorResolver errorResolver = new ReferenceErrorResolver(){

                            public void resolveError(AuthorAccess authorAccess) {
                                DITAAccess.resolveKeyNotFoundError((AuthorAccess)authorAccess, (String)fkeyName);
                            }
                        };
                        throw new CustomResolverException("Key not found: " + keyName, errorResolver);
                    }
                } else {
                    URL keyResolvedURL = DITAAccess.resolveKeyRef((URL)contextURL, (String)keyref, (ContextKeyManager)this.keyManager, (boolean)true);
                    if (keyResolvedURL != null) {
                        resolvedURL = keyResolvedURL;
                        String originalKeyName = null;
                        KeyInfo ki = this.keyManager.getKeyDefinitionForKeyName(contextURL, keyName);
                        if (ki != null) {
                            originalKeyName = ki.getOriginalNotKeyScopedKeyName();
                        }
                        resolvedURL = DITAAccess.attachKeyScopeInformation((URL)resolvedURL, (String)keyref, (String)(contextNode != null ? contextNode.getOwnerDocument().getSystemID() : null), (String)originalKeyName);
                    } else if (resolvedURL == null) {
                        String resolveHref = DITAAccess.resolveKeyRefToHref((URL)contextURL, (String)keyref, (ContextKeyManager)this.keyManager, (boolean)true);
                        if (resolveHref != null) {
                            throw new CustomResolverException("Key definition for \"" + keyName + "\" references an unsupported URL: " + resolveHref, null);
                        }
                        throw new CustomResolverException("Key definition for \"" + keyName + "\" does not point to a resource.", null);
                    }
                }
            }
        } else {
            KeyInfo keyInfo;
            linkHref = linkHref.substring(KEYWORD_KEYREF_PREFIX.length());
            LinkedHashMap keys = DITAAccess.getKeys((URL)contextURL, (ContextKeyManager)this.keyManager);
            if (keys != null && (keyInfo = (KeyInfo)keys.get(linkHref)) != null) {
                resolvedURL = keyInfo.getHrefLocation();
            }
        }
        if (resolvedURL == null) {
            throw new CustomResolverException("Key definition for \"" + linkHref + "\" not found.", null);
        }
        return resolvedURL;
    }

    public AuthorSchemaAwareEditingHandler getAuthorSchemaAwareEditingHandler() {
        if (this.ditaSchemaAwareEditingHandler == null) {
            this.ditaSchemaAwareEditingHandler = new DITASchemaAwareEditingHandler();
        }
        return this.ditaSchemaAwareEditingHandler;
    }

    public SchemaManagerFilter createSchemaManagerFilter() {
        return new DITASchemaManagerFilter(this.getDocumentTypeName(), this.keyManagerProvider, this::getAuthorUserName);
    }

    private String getAuthorUserName() {
        String userName = this.authorAccess != null ? this.authorAccess.getReviewController().getReviewerAuthorName() : null;
        return userName;
    }

    public AuthorExternalObjectInsertionHandler createExternalObjectInsertionHandler() {
        return new DITAExternalObjectInsertionHandler(this.keyManagerProvider);
    }

    public TextPageExternalObjectInsertionHandler createTextPageExternalObjectInsertionHandler() {
        return new DITATextPageExternalObjectInsertionHandler(this.keyManagerProvider);
    }

    public boolean isContentReference(AuthorNode node) {
        AuthorElement elem;
        return node.getType() == 0 && ((elem = (AuthorElement)node).getAttribute("conref") != null || elem.getAttribute("conkeyref") != null);
    }

    public ProfilingConditionalTextProvider getProfilingConditionalTextProvider() {
        return new ProfilingConditionalTextProvider(){

            public String getXMLFragmentForContentProfiling(int startOffset, int endOffset, AuthorAccess authorAccess) {
                return "<ph/>";
            }

            public boolean shouldAddProfilingDirectlyOnElement(AuthorElement element) {
                boolean toRet = true;
                AttrValue classAttr = element.getAttribute("class");
                if (classAttr != null && classAttr.getValue().contains(" topic/entry ")) {
                    toRet = false;
                }
                return toRet;
            }
        };
    }

    public XMLNodeRendererCustomizer createXMLNodeCustomizer() {
        return new DITANodeRendererCustomizer();
    }

    public AuthorTableOperationsHandler getAuthorTableOperationsHandler() {
        if (this.ditaAuthorTableOperationsHandler == null) {
            this.ditaAuthorTableOperationsHandler = new DITAAuthorTableOperationsHandler();
        }
        return this.ditaAuthorTableOperationsHandler;
    }

    public LinkTextResolver createLinkTextResolver() {
        return new DitaLinkTextResolver(this.keyManagerProvider);
    }

    public IDTypeRecognizer createIDTypeRecognizer() {
        return new DITAIDTypeRecognizer();
    }

    public ContextKeyManager getKeyManager() {
        return this.keyManager;
    }

    public AuthorActionEventHandler getAuthorActionEventHandler() {
        if (this.handler == null) {
            this.handler = new DITAAuthorActionEventHandler();
        }
        return this.handler;
    }

    public AuthorImageDecorator getAuthorImageDecorator() {
        if (this.decorator == null) {
            this.decorator = new DITAAuthorImageDecorator();
        }
        return this.decorator;
    }

    public EditPropertiesHandler createEditPropertiesHandler() {
        return new EditPropertiesHandler(){

            public String getDescription() {
                return "Handles imagemap editing";
            }

            public void editProperties(AuthorNode authorNode, AuthorAccess authorAccess) {
                try {
                    new EditImageMapOperation().doOperation(authorAccess, null);
                }
                catch (Exception e) {
                    logger.error((Object)e, (Throwable)e);
                }
            }

            public boolean canEditProperties(AuthorNode authorNode) {
                AuthorElement element;
                AttrValue classAttr;
                boolean isHandled = false;
                if (authorNode.getType() == 0 && (classAttr = (element = (AuthorElement)authorNode).getAttribute("class")) != null) {
                    AuthorElement parent;
                    AttrValue parentClassAttr;
                    if (classAttr.getValue().contains(" ut-d/imagemap ")) {
                        isHandled = true;
                    } else if (classAttr.getValue().contains(" topic/image ") && (parentClassAttr = (parent = (AuthorElement)element.getParentElement()).getAttribute("class")) != null && parentClassAttr.getValue().contains(" ut-d/imagemap ")) {
                        isHandled = true;
                    }
                }
                return isHandled;
            }
        };
    }

    public String getHelpPageID(String currentEditorPage) {
        return "author-dita-doc-type";
    }

    public ContextKeyManager getContextKeyManager() {
        return this.keyManagerProvider.getContextKeyManager();
    }

    public URL resolveCustomAttributeValue(CustomAttributeValueContext attributeValueEditingContext) {
        URL url = null;
        if (attributeValueEditingContext.getBaseURL() != null && ("keyref".equals(attributeValueEditingContext.getAttributeName()) || "conkeyref".equals(attributeValueEditingContext.getAttributeName()))) {
            String keyref = attributeValueEditingContext.getAttributeValue();
            url = DITAAccess.resolveKeyRef((URL)attributeValueEditingContext.getBaseURL(), (String)keyref, (boolean)true);
        }
        return url;
    }

    public SpellCheckerHelper getSpellCheckerHelper() {
        return new DITASpellCheckerHelper();
    }
}

