/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.operations.cals;

import java.util.List;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.basic.util.NumberFormatException;
import ro.sync.basic.util.NumberParserUtil;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorTableCellSpanProvider;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.webapp.WebappRestSafe;
import ro.sync.ecss.extensions.commons.table.operations.AuthorTableHelper;
import ro.sync.ecss.extensions.commons.table.operations.DeleteColumnOperationBase;
import ro.sync.ecss.extensions.commons.table.operations.cals.CALSConstants;
import ro.sync.ecss.extensions.commons.table.operations.cals.CALSDocumentTypeHelper;
import ro.sync.ecss.extensions.commons.table.support.CALSColSpec;
import ro.sync.ecss.extensions.commons.table.support.CALSTableCellInfoProvider;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible
@WebappRestSafe
public class DeleteColumnOperation
extends DeleteColumnOperationBase
implements CALSConstants {
    public DeleteColumnOperation() {
        this(new CALSDocumentTypeHelper());
    }

    public DeleteColumnOperation(AuthorTableHelper documentTypeHelper) {
        super(documentTypeHelper);
    }

    @Override
    public void updateColspec(AuthorAccess authorAccess, Integer deletedColumnIndex) {
        CALSTableCellInfoProvider spanProvider = (CALSTableCellInfoProvider)this.tableHelper.getTableCellSpanProvider(this.tableElem);
        CALSColSpec colSpec = spanProvider.getColSpec(deletedColumnIndex + 1);
        if (colSpec != null) {
            List contentNodes = this.tableElem.getContentNodes();
            boolean shouldDecreaseColNum = false;
            AuthorElement toRemove = spanProvider.getColSpecElement(colSpec);
            for (AuthorNode node : contentNodes) {
                AttrValue colNumAttrVal;
                if (!this.tableHelper.isColspec(node)) continue;
                AuthorElement colSpecElem = (AuthorElement)node;
                if (colSpecElem == toRemove) {
                    shouldDecreaseColNum = true;
                }
                if (!shouldDecreaseColNum || (colNumAttrVal = colSpecElem.getAttribute("colnum")) == null || colNumAttrVal.getValue() == null) continue;
                try {
                    int colNum = NumberParserUtil.parseInt((String)colNumAttrVal.getValue());
                    authorAccess.getDocumentController().setAttribute("colnum", new AttrValue("" + (colNum - 1)), colSpecElem);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (toRemove != null) {
                int newCaretOffset = authorAccess.getEditorAccess().getCaretOffset() - (toRemove.getEndOffset() - toRemove.getStartOffset() + 1);
                authorAccess.getDocumentController().deleteNode((AuthorNode)toRemove);
                authorAccess.getEditorAccess().setCaretPosition(newCaretOffset);
            }
        }
    }

    @Override
    protected void updateTableColSpan(AuthorAccess authorAccess, AuthorTableCellSpanProvider spanProvider, AuthorElement cell, int colStartIndex, int colEndIndex) throws AuthorOperationException {
        if ((Integer)this.deletedColumnsIndices.get(this.deletedColumnsIndices.size() - 1) + 1 == colStartIndex) {
            this.tableHelper.updateTableColSpan(authorAccess, spanProvider, cell, colStartIndex + 1, colEndIndex);
        } else if ((Integer)this.deletedColumnsIndices.get(this.deletedColumnsIndices.size() - 1) + 1 == colEndIndex) {
            this.tableHelper.updateTableColSpan(authorAccess, spanProvider, cell, colStartIndex, colEndIndex - 1);
        }
    }
}

