/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.operations.cals;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.common.CommonAccess;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorElementBaseInterface;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.ExtensionsBundle;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.node.AuthorParentNode;
import ro.sync.ecss.extensions.commons.sort.CriterionInformation;
import ro.sync.ecss.extensions.commons.sort.SortCriteriaInformation;
import ro.sync.ecss.extensions.commons.sort.TableSortOperation;
import ro.sync.ecss.extensions.commons.sort.TableSortUtil;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public abstract class CALSAndHTMLTableSortOperation
extends TableSortOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)CALSAndHTMLTableSortOperation.class.getName());

    @Override
    public AuthorElement getSortParent(int offset, AuthorAccess authorAccess) throws AuthorOperationException {
        AuthorNode selectedNode;
        if (authorAccess.getEditorAccess().hasSelection() && (selectedNode = authorAccess.getEditorAccess().getFullySelectedNode()) != null && selectedNode.getType() == 0) {
            AuthorElement selectedElement = (AuthorElement)selectedNode;
            if (this.isTableBody(selectedElement)) {
                return selectedElement;
            }
            if (this.isTableHead(selectedElement) || this.isTableFoot(selectedElement)) {
                AuthorNode parent = selectedElement.getParent();
                if (parent.getType() == 0) {
                    return this.getBodyElement(parent);
                }
            } else if (this.isTable(selectedElement) || this.isTableGroup(selectedElement)) {
                List contentNodes = selectedElement.getContentNodes();
                for (int i = 0; i < contentNodes.size(); ++i) {
                    AuthorNode child = (AuthorNode)contentNodes.get(i);
                    if (child.getType() != 0) continue;
                    AuthorElement childElement = (AuthorElement)child;
                    if (this.isTableBody(childElement)) {
                        return childElement;
                    }
                    if (!this.isTableGroup(childElement)) continue;
                    return this.getBodyElement((AuthorNode)childElement);
                }
            }
        }
        try {
            for (AuthorNode parentElement = authorAccess.getDocumentController().getNodeAtOffset(offset); parentElement != null && parentElement.getType() != 2; parentElement = parentElement.getParent()) {
                if (parentElement.getType() == 0 && this.isTableBody((AuthorElement)parentElement)) {
                    return (AuthorElement)parentElement;
                }
                if (parentElement.getType() != 0 || !this.isTableHead((AuthorElement)parentElement) && !this.isTableFoot((AuthorElement)parentElement)) continue;
                AuthorNode parent = parentElement.getParent();
                return this.getBodyElement(parent);
            }
        }
        catch (BadLocationException e) {
            throw new AuthorOperationException(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private AuthorElement getBodyElement(AuthorNode currentElement) {
        AuthorElement bodyElement = null;
        if (currentElement != null && currentElement.getType() == 0) {
            List contentNodes = ((AuthorElement)currentElement).getContentNodes();
            for (int i = 0; contentNodes != null && i < contentNodes.size(); ++i) {
                AuthorNode authorNode = (AuthorNode)contentNodes.get(i);
                if (authorNode.getType() != 0 || !this.isTableBody((AuthorElement)authorNode)) continue;
                bodyElement = (AuthorElement)authorNode;
                break;
            }
        }
        return bodyElement;
    }

    @Override
    public boolean isIgnored(AuthorNode node) {
        return node.getType() == 3 || node.getType() == 5;
    }

    @Override
    public String[] getSortKeysValues(AuthorNode node, SortCriteriaInformation sortInfo) throws AuthorOperationException {
        CriterionInformation[] criterionInfo = sortInfo.criteriaInfo;
        String[] values = null;
        if (node instanceof AuthorElement && criterionInfo.length > 0) {
            values = new String[criterionInfo.length];
            AuthorElement authorParentNode = (AuthorElement)node;
            ExtensionsBundle extensionsBundle = this.authorAccess.getEditorAccess().getExtensionsBundle();
            if (extensionsBundle != null) {
                authorParentNode = (AuthorElement)CommonAccess.getContentReferencedNode((ExtensionsBundle)extensionsBundle, (AuthorNode)authorParentNode);
            }
            if (this.isTableRow(authorParentNode)) {
                List<AuthorNode> contentNodes = this.getNonIgnoredChildren(authorParentNode);
                int size = contentNodes.size();
                for (int i = 0; i < criterionInfo.length; ++i) {
                    CriterionInformation criterionInformation = criterionInfo[i];
                    int keyIndex = criterionInformation.getKeyIndex();
                    AuthorNode cellNode = null;
                    for (int j = 0; j < size; ++j) {
                        int[] tableColSpanIndices;
                        AuthorNode authorNode = contentNodes.get(j);
                        if (!(authorNode instanceof AuthorElement) || (tableColSpanIndices = this.authorAccess.getTableAccess().getTableColSpanIndices((AuthorElement)authorNode)) == null || tableColSpanIndices[0] > keyIndex || tableColSpanIndices[1] < keyIndex) continue;
                        cellNode = authorNode;
                        break;
                    }
                    if (cellNode == null) continue;
                    values[i] = this.getTextContentToSort(cellNode);
                }
            }
        }
        return values;
    }

    @Override
    public List<CriterionInformation> getSortCriteria(AuthorElement parent) throws AuthorOperationException {
        ArrayList<CriterionInformation> criteria;
        block8: {
            AuthorElement maxRowElem;
            block9: {
                criteria = new ArrayList<CriterionInformation>();
                List<AuthorNode> children = this.getNonIgnoredChildren(parent);
                int maxNrOfChildren = 0;
                maxRowElem = null;
                for (int i = 0; i < children.size(); ++i) {
                    int size;
                    AuthorNode child = children.get(i);
                    if (child.getType() != 0 || (size = this.getNonIgnoredChildren((AuthorElement)child).size()) <= maxNrOfChildren) continue;
                    maxRowElem = (AuthorElement)child;
                    maxNrOfChildren = size;
                }
                AuthorElementBaseInterface tGroupElementElement = null;
                tGroupElementElement = parent.getParentElement();
                if (tGroupElementElement == null) break block8;
                List contentNodes = tGroupElementElement.getContentNodes();
                AuthorElement theadElement = null;
                for (int i = 0; i < contentNodes.size(); ++i) {
                    AuthorElement authorElement;
                    AuthorNode child = (AuthorNode)contentNodes.get(i);
                    if (child.getType() != 0 || !this.isTableHead(authorElement = (AuthorElement)child)) continue;
                    theadElement = authorElement;
                    break;
                }
                AuthorElement theadRow = null;
                if (theadElement != null) {
                    List<AuthorNode> theadChildren = this.getNonIgnoredChildren(theadElement);
                    for (int i = 0; i < theadChildren.size(); ++i) {
                        int size;
                        AuthorNode child = theadChildren.get(i);
                        if (child.getType() != 0 || (size = this.getNonIgnoredChildren((AuthorElement)child).size()) != maxNrOfChildren) continue;
                        theadRow = (AuthorElement)child;
                        break;
                    }
                }
                if (theadRow == null || maxRowElem == null) break block9;
                List<AuthorNode> theadRowChildren = this.getNonIgnoredChildren(theadRow);
                for (int i = 0; i < maxNrOfChildren; ++i) {
                    AuthorNode authorNode = theadRowChildren.get(i);
                    if (authorNode.getType() != 0) continue;
                    try {
                        AuthorElement theadEntry = (AuthorElement)authorNode;
                        String textContent = theadEntry.getTextContent();
                        criteria.add(new CriterionInformation(i, CriterionInformation.TYPE.TEXT.getName(), CriterionInformation.ORDER.ASCENDING.getName(), (String)(textContent.length() > 0 ? textContent : "Column " + (i + 1)), TableSortUtil.isEntirelySelected(this.authorAccess, theadEntry) || this.isCaretInColumn(this.authorAccess, i)));
                        continue;
                    }
                    catch (BadLocationException e) {
                        throw new AuthorOperationException(e.getMessage(), (Throwable)e);
                    }
                }
                break block8;
            }
            if (maxRowElem == null) break block8;
            List<AuthorNode> maxRowChildren = this.getNonIgnoredChildren(maxRowElem);
            for (int i = 0; i < maxRowChildren.size(); ++i) {
                if (maxRowChildren.get(i).getType() != 0) continue;
                criteria.add(new CriterionInformation(i, CriterionInformation.TYPE.TEXT.getName(), CriterionInformation.ORDER.ASCENDING.getName(), "Column " + (i + 1), TableSortUtil.isEntirelySelected(this.authorAccess, (AuthorElement)maxRowChildren.get(i)) || this.isCaretInColumn(this.authorAccess, i)));
            }
        }
        return criteria;
    }

    @Override
    protected boolean forceSortAll() {
        return TableSortUtil.isColumnOrTableSelection(this.authorAccess);
    }

    public boolean isCaretInColumn(AuthorAccess authorAccess, int columnNumber) {
        if (columnNumber < 0) {
            return false;
        }
        boolean isCaretInColumn = false;
        int caretOffset = authorAccess.getEditorAccess().getCaretOffset();
        try {
            AuthorNode nodeAtOffset = authorAccess.getDocumentController().getNodeAtOffset(caretOffset);
            if (nodeAtOffset != null && nodeAtOffset.getType() == 0 && nodeAtOffset.getParent().getType() == 0 && this.isTableRow((AuthorElement)nodeAtOffset.getParent())) {
                List<AuthorNode> nonIgnoredChildren = this.getNonIgnoredChildren((AuthorElement)nodeAtOffset.getParent());
                int[] tableColSpanIndices = authorAccess.getTableAccess().getTableColSpanIndices((AuthorElement)nodeAtOffset);
                if (tableColSpanIndices != null) {
                    if (tableColSpanIndices[0] <= columnNumber && tableColSpanIndices[1] >= columnNumber) {
                        isCaretInColumn = true;
                    }
                } else if (columnNumber < nonIgnoredChildren.size()) {
                    isCaretInColumn = nonIgnoredChildren.get(columnNumber) == nodeAtOffset;
                }
            }
        }
        catch (BadLocationException e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
        }
        return isCaretInColumn;
    }

    @Override
    protected int getRowIndexForTableBody(AuthorNode parent) {
        int index = 0;
        if (parent.getParent() != null) {
            AuthorNode table = parent.getParent();
            List contentNodes = ((AuthorParentNode)table).getContentNodes();
            for (AuthorNode authorNode : contentNodes) {
                if (authorNode.getType() != 0 || !this.isTableHead((AuthorElement)authorNode) && !this.isTableFoot((AuthorElement)authorNode)) continue;
                ++index;
            }
        }
        return index;
    }

    public abstract boolean isTableBody(AuthorElement var1);

    public abstract boolean isTableRow(AuthorElement var1);

    public abstract boolean isTableHead(AuthorElement var1);

    public abstract boolean isTableFoot(AuthorElement var1);

    public abstract boolean isTable(AuthorElement var1);

    public abstract boolean isTableGroup(AuthorElement var1);
}

