/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.operations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.basic.util.NumberFormatException;
import ro.sync.basic.util.NumberParserUtil;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorTableCellSpanProvider;
import ro.sync.ecss.extensions.api.ContentInterval;
import ro.sync.ecss.extensions.api.access.AuthorTableAccess;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.table.operations.AbstractTableOperation;
import ro.sync.ecss.extensions.commons.table.operations.AuthorTableHelper;
import ro.sync.ecss.extensions.commons.table.operations.DeleteRowOperationBase;
import ro.sync.ecss.extensions.commons.table.operations.SplitCellAboveBelowOperationBase;
import ro.sync.ecss.extensions.commons.table.operations.TableOperationsUtil;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public abstract class JoinOperationBase
extends AbstractTableOperation {
    public static final String CURSOR_OUTSIDE_THE_TABLE_ERROR_MESSAGE = "Please place the cursor inside the table before invoking the Join operation.";
    public static final String SELECT_AT_LEAST_TWO_ADJACENT_CELLS_ERROR_MESSAGE = "Select at least two adjacent cells before invoking the Join operation.";
    public static final String RECTANGULAR_SELECTIONS_ERROR_MESSAGE = "Select a rectangular section of the table before invoking the Join operation.";
    private static final String ROW_COL_SEPARATOR = "-";

    public JoinOperationBase(AuthorTableHelper tableHelper) {
        super(tableHelper);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void doOperationInternal(AuthorAccess authorAccess, ArgumentsMap args) throws IllegalArgumentException, AuthorOperationException {
        try {
            List<AuthorElement> cellElements;
            if (!authorAccess.getEditorAccess().hasSelection()) {
                AuthorOperationException ex = new AuthorOperationException(SELECT_AT_LEAST_TWO_ADJACENT_CELLS_ERROR_MESSAGE);
                ex.setOperationRejectedOnPurpose(true);
                throw ex;
            }
            AuthorElement tableElement = this.getElementAncestor(authorAccess.getDocumentController().getNodeAtOffset(authorAccess.getEditorAccess().getCaretOffset()), 2);
            if (tableElement == null) {
                AuthorOperationException ex = new AuthorOperationException(CURSOR_OUTSIDE_THE_TABLE_ERROR_MESSAGE);
                ex.setOperationRejectedOnPurpose(true);
                throw ex;
            }
            List selectionIntervals = authorAccess.getEditorAccess().getAuthorSelectionModel().getSelectionIntervals();
            ArrayList<Integer[]> selections = new ArrayList<Integer[]>();
            if (selectionIntervals != null && !selectionIntervals.isEmpty()) {
                for (int i = 0; i < selectionIntervals.size(); ++i) {
                    int startOffset = ((ContentInterval)selectionIntervals.get(i)).getStartOffset();
                    int endOffset = ((ContentInterval)selectionIntervals.get(i)).getEndOffset();
                    if ((tableElement.getStartOffset() > startOffset || startOffset > tableElement.getEndOffset()) && (tableElement.getStartOffset() > endOffset || endOffset > tableElement.getEndOffset())) continue;
                    selections.add(new Integer[]{startOffset, endOffset});
                }
            }
            if ((cellElements = TableOperationsUtil.getTableElementsOfType(authorAccess, selections, 6, TableOperationsUtil.createTableHelper(this.tableHelper))) != null && cellElements.size() > 1) {
                this.joinCells(authorAccess, tableElement, cellElements);
                return;
            }
            AuthorOperationException ex = new AuthorOperationException(SELECT_AT_LEAST_TWO_ADJACENT_CELLS_ERROR_MESSAGE);
            ex.setOperationRejectedOnPurpose(true);
            throw ex;
        }
        catch (BadLocationException e) {
            AuthorOperationException ex = new AuthorOperationException(CURSOR_OUTSIDE_THE_TABLE_ERROR_MESSAGE, (Throwable)e);
            ex.setOperationRejectedOnPurpose(true);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void joinCells(AuthorAccess authorAccess, AuthorElement tableElement, List<AuthorElement> cellElements) throws AuthorOperationException, BadLocationException {
        HashMap<String, AuthorNode> mapCellToNode = new HashMap<String, AuthorNode>();
        AuthorTableAccess tableAccess = authorAccess.getTableAccess();
        for (AuthorElement cellElement : cellElements) {
            int[] tableRowSpanIndices = tableAccess.getTableRowSpanIndices(cellElement);
            int[] tableColSpanIndices = tableAccess.getTableColSpanIndices(cellElement);
            int startRow = tableRowSpanIndices[0];
            int endRow = tableRowSpanIndices[1];
            int startColumn = tableColSpanIndices[0];
            int endColumn = tableColSpanIndices[1];
            for (int i = startRow; i <= endRow; ++i) {
                for (int j = startColumn; j <= endColumn; ++j) {
                    mapCellToNode.put(i + ROW_COL_SEPARATOR + j, (AuthorNode)cellElement);
                }
            }
        }
        int columnsCount = tableAccess.getTableNumberOfColumns(tableElement);
        int rowsCount = tableAccess.getTableRowCount(tableElement);
        ArrayList<JoinGroupInformation> allGroupsToJoin = new ArrayList<JoinGroupInformation>();
        for (int i = 0; i < rowsCount; ++i) {
            for (int j = 0; j < columnsCount; ++j) {
                int[] currentCell = new int[]{i, j};
                String cellRepresentation = currentCell[0] + ROW_COL_SEPARATOR + currentCell[1];
                AuthorNode authorNode = (AuthorNode)mapCellToNode.remove(cellRepresentation);
                if (authorNode == null) continue;
                HashMap<String, AuthorNode> currentGroupToJoin = new HashMap<String, AuthorNode>();
                JoinGroupInformation groupInformation = new JoinGroupInformation();
                groupInformation.startRow = i;
                groupInformation.startColumn = j;
                groupInformation.endRow = i;
                groupInformation.endColumn = j;
                groupInformation.groupMap = currentGroupToJoin;
                this.populateJoinGroupStartingFrom(groupInformation, authorNode, cellRepresentation, mapCellToNode);
                if (currentGroupToJoin.size() <= 1) continue;
                boolean rectangular = true;
                block8: for (int k = groupInformation.startRow; k <= groupInformation.endRow; ++k) {
                    for (int l = groupInformation.startColumn; l <= groupInformation.endColumn; ++l) {
                        if (currentGroupToJoin.containsKey(k + ROW_COL_SEPARATOR + l)) continue;
                        rectangular = false;
                        continue block8;
                    }
                }
                if (rectangular) {
                    allGroupsToJoin.add(groupInformation);
                    continue;
                }
                AuthorOperationException ex = new AuthorOperationException(RECTANGULAR_SELECTIONS_ERROR_MESSAGE);
                ex.setOperationRejectedOnPurpose(true);
                throw ex;
            }
        }
        AuthorTableCellSpanProvider tableSupport = this.tableHelper.getTableCellSpanProvider(tableElement);
        ArrayList<AuthorElement> tableRowsToRemove = null;
        Position nextSelectionStartOffset = null;
        Position nextSelectionEndOffset = null;
        try {
            int size;
            authorAccess.getDocumentController().disableLayoutUpdate();
            if (!tableSupport.hasColumnSpecifications(tableElement) && authorAccess.getWorkspaceAccess().showConfirmDialog("Column specifications", "Join cells operation requires column specifications. Do you want to generate them?", new String[]{"Yes", "No"}, new int[]{1, 0}) == 1) {
                this.generateColumnSpecifications(authorAccess, tableSupport, tableElement);
            }
            if ((size = allGroupsToJoin.size()) == 0) {
                AuthorOperationException ex = new AuthorOperationException(SELECT_AT_LEAST_TWO_ADJACENT_CELLS_ERROR_MESSAGE);
                ex.setOperationRejectedOnPurpose(true);
                throw ex;
            }
            for (int i = size - 1; i >= 0; --i) {
                JoinGroupInformation joinGroupInformation = (JoinGroupInformation)allGroupsToJoin.get(i);
                Map<String, AuthorNode> groupMap = joinGroupInformation.groupMap;
                int destinationRow = joinGroupInformation.startRow;
                int destinationColumn = joinGroupInformation.startColumn;
                AuthorNode destinationCell = groupMap.get(destinationRow + ROW_COL_SEPARATOR + destinationColumn);
                AuthorNode lastCellOnFirstRow = groupMap.get(joinGroupInformation.startRow + ROW_COL_SEPARATOR + joinGroupInformation.endColumn);
                if (!(destinationCell instanceof AuthorElement) || !(lastCellOnFirstRow instanceof AuthorElement)) continue;
                this.tableHelper.checkTableColSpanIsDefined(authorAccess, tableSupport, (AuthorElement)destinationCell);
                this.tableHelper.checkTableColSpanIsDefined(authorAccess, tableSupport, (AuthorElement)lastCellOnFirstRow);
                this.tableHelper.updateTableColSpan(authorAccess, tableSupport, (AuthorElement)destinationCell, destinationColumn + 1, joinGroupInformation.endColumn + 1);
                this.tableHelper.updateTableRowSpan(authorAccess, (AuthorElement)destinationCell, joinGroupInformation.endRow - joinGroupInformation.startRow + 1);
                for (int k = joinGroupInformation.startRow; k <= joinGroupInformation.endRow; ++k) {
                    for (int l = joinGroupInformation.startColumn; l <= joinGroupInformation.endColumn; ++l) {
                        AuthorNode cellNode = groupMap.get(k + ROW_COL_SEPARATOR + l);
                        if (!(cellNode instanceof AuthorElement) || cellNode == destinationCell) continue;
                        AuthorElement cell = (AuthorElement)cellNode;
                        AuthorDocumentFragment fragmentToMove = null;
                        if (cell.getEndOffset() - cell.getStartOffset() > 1) {
                            fragmentToMove = authorAccess.getDocumentController().createDocumentFragment(cell.getStartOffset() + 1, cell.getEndOffset() - 1);
                        }
                        AuthorNode deletedCellParentRow = cell.getParent();
                        authorAccess.getDocumentController().deleteNode((AuthorNode)cell);
                        if (deletedCellParentRow instanceof AuthorElement && deletedCellParentRow.getStartOffset() + 1 == deletedCellParentRow.getEndOffset()) {
                            if (tableRowsToRemove == null) {
                                tableRowsToRemove = new ArrayList<AuthorElement>(1);
                            }
                            tableRowsToRemove.add((AuthorElement)deletedCellParentRow);
                        }
                        if (fragmentToMove == null) continue;
                        authorAccess.getDocumentController().insertFragment(destinationCell.getEndOffset(), fragmentToMove);
                    }
                }
                int startOffset = destinationCell.getStartOffset();
                int endOffset = destinationCell.getEndOffset();
                authorAccess.getEditorAccess().select(startOffset, endOffset + 1);
                nextSelectionStartOffset = authorAccess.getDocumentController().createPositionInContent(startOffset);
                nextSelectionEndOffset = authorAccess.getDocumentController().createPositionInContent(endOffset + 1);
            }
        }
        finally {
            authorAccess.getDocumentController().enableLayoutUpdate((AuthorNode)tableElement);
        }
        if (tableRowsToRemove != null) {
            DeleteRowOperationBase deleteRowOperation = new DeleteRowOperationBase(this.tableHelper){

                @Override
                protected SplitCellAboveBelowOperationBase createSplitCellOperation() {
                    return null;
                }
            };
            for (int j = tableRowsToRemove.size() - 1; j >= 0; --j) {
                AuthorElement tableRowToRemove = (AuthorElement)tableRowsToRemove.get(j);
                deleteRowOperation.performDeleteRows(authorAccess, tableRowToRemove.getStartOffset(), tableRowToRemove.getEndOffset() + 1);
            }
            if (nextSelectionStartOffset != null && nextSelectionEndOffset != null) {
                authorAccess.getEditorAccess().select(nextSelectionStartOffset.getOffset(), nextSelectionEndOffset.getOffset());
            }
        }
    }

    private void populateJoinGroupStartingFrom(JoinGroupInformation groupInformation, AuthorNode authorNode, String cellRepresentation, Map<String, AuthorNode> mapCellToNode) throws AuthorOperationException {
        groupInformation.groupMap.put(cellRepresentation, authorNode);
        int sepIndex = cellRepresentation.indexOf(ROW_COL_SEPARATOR);
        try {
            int rightCellColumn;
            String rightCellRepresentation;
            AuthorNode rightCell;
            int leftCellColumn;
            String leftColumnRepresentation;
            AuthorNode leftCell;
            int row = NumberParserUtil.parseInt((String)cellRepresentation.substring(0, sepIndex));
            int column = NumberParserUtil.parseInt((String)cellRepresentation.substring(sepIndex + 1, cellRepresentation.length()));
            if (column > 0 && (leftCell = mapCellToNode.remove(leftColumnRepresentation = row + ROW_COL_SEPARATOR + (leftCellColumn = column - 1))) != null) {
                AuthorOperationException ex = new AuthorOperationException(RECTANGULAR_SELECTIONS_ERROR_MESSAGE);
                ex.setOperationRejectedOnPurpose(true);
                throw ex;
            }
            int southCellRow = row + 1;
            String southCellRepresentation = southCellRow + ROW_COL_SEPARATOR + column;
            AuthorNode southCell = mapCellToNode.remove(southCellRepresentation);
            if (southCell != null) {
                groupInformation.endRow = Math.max(groupInformation.endRow, southCellRow);
                this.populateJoinGroupStartingFrom(groupInformation, southCell, southCellRepresentation, mapCellToNode);
            }
            if ((rightCell = mapCellToNode.remove(rightCellRepresentation = row + ROW_COL_SEPARATOR + (rightCellColumn = column + 1))) != null) {
                groupInformation.endColumn = Math.max(groupInformation.endColumn, rightCellColumn);
                this.populateJoinGroupStartingFrom(groupInformation, rightCell, rightCellRepresentation, mapCellToNode);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public String getDescription() {
        return "Join the content of the selected cells.";
    }

    public ArgumentDescriptor[] getArguments() {
        return null;
    }

    protected abstract void generateColumnSpecifications(AuthorAccess var1, AuthorTableCellSpanProvider var2, AuthorElement var3) throws AuthorOperationException;

    private static class JoinGroupInformation {
        private int startRow = -1;
        private int endRow = -1;
        private int startColumn = -1;
        private int endColumn = -1;
        private Map<String, AuthorNode> groupMap = new HashMap<String, AuthorNode>();

        private JoinGroupInformation() {
        }
    }
}

