/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations.text;

import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.css.Styles;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorResourceBundle;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.content.OffsetInformation;
import ro.sync.ecss.extensions.api.content.TextContentIterator;
import ro.sync.ecss.extensions.api.content.TextContext;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.webapp.WebappRestSafe;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible
@WebappRestSafe
public class CountWordsOperation
implements AuthorOperation {
    private static final Logger logger = LoggerFactory.getLogger((String)CountWordsOperation.class.getName());
    private static final int WORD_STATE = 0;
    private static final int WHITESPACE_STATE = 1;

    public void doOperation(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        AuthorResourceBundle authorResourceBundle = authorAccess.getAuthorResourceBundle();
        String REGULAR_CONTENT = authorResourceBundle.getMessage("Regular_content");
        String FILTERED_CONTENT = authorResourceBundle.getMessage("Filtered_content");
        String READONLY_CONTENT = authorResourceBundle.getMessage("Read_only_content");
        String WORDS = authorResourceBundle.getMessage("Words");
        String CHARACTERS = authorResourceBundle.getMessage("Characters");
        String CHARACTERS_NO_SPACES = authorResourceBundle.getMessage("characters_no_spaces");
        String TOTAL = authorResourceBundle.getMessage("Total");
        int startOffset = 0;
        int endOffset = authorAccess.getDocumentController().getAuthorDocumentNode().getEndOffset();
        if (authorAccess.getEditorAccess().hasSelection()) {
            startOffset = authorAccess.getEditorAccess().getSelectionStart();
            endOffset = authorAccess.getEditorAccess().getSelectionEnd() - 1;
        }
        TextContentIterator contentIterator = authorAccess.getDocumentController().getTextContentIterator(startOffset, endOffset);
        int wordCount = 0;
        int charCount = 0;
        int charactersWithWSCount = 0;
        int wordCountInReadOnly = 0;
        int charCountInReadOnly = 0;
        int charactersWithWSCountInReadOnly = 0;
        int wordCountInFilteredCondProfiling = 0;
        int charCountInFilteredCondProfiling = 0;
        int charactersWithWSCountInFilteredCondProfiling = 0;
        boolean firstIteration = true;
        while (contentIterator.hasNext()) {
            TextContext textContext = contentIterator.next();
            if (!textContext.inVisibleContent()) continue;
            int currentEditableState = textContext.getEditableState();
            if (currentEditableState != 2) {
                CharSequence textContent = textContext.getText();
                int textContentLength = textContent.length();
                int currentTextCharCount = 0;
                int currentTextWordCount = 0;
                boolean startsWithCharacter = false;
                boolean currentWordState = true;
                for (int i = 0; i < textContentLength; ++i) {
                    char ch = textContent.charAt(i);
                    if (!Character.isWhitespace(ch)) {
                        if (currentWordState) {
                            currentWordState = false;
                            ++currentTextWordCount;
                        }
                        ++currentTextCharCount;
                        if (i != 0) continue;
                        startsWithCharacter = true;
                        continue;
                    }
                    if (currentWordState) continue;
                    currentWordState = true;
                }
                if (startsWithCharacter && !firstIteration && !CountWordsOperation.isWordStart(authorAccess, textContext.getTextStartOffset())) {
                    --currentTextWordCount;
                }
                if (currentEditableState == 0) {
                    charCount += currentTextCharCount;
                    wordCount += currentTextWordCount;
                    charactersWithWSCount += textContentLength;
                } else if (currentEditableState == 1) {
                    charCountInFilteredCondProfiling += currentTextCharCount;
                    wordCountInFilteredCondProfiling += currentTextWordCount;
                    charactersWithWSCountInFilteredCondProfiling += textContentLength;
                } else {
                    charCountInReadOnly += currentTextCharCount;
                    wordCountInReadOnly += currentTextWordCount;
                    charactersWithWSCountInReadOnly += textContentLength;
                }
            }
            firstIteration = false;
        }
        StringBuilder message = new StringBuilder();
        if (wordCountInReadOnly == 0 && wordCountInFilteredCondProfiling == 0) {
            message.append(WORDS + ": ");
            message.append(wordCount);
            message.append("\n");
            message.append(CHARACTERS + ": ");
            message.append(charactersWithWSCount);
            message.append("\n");
            message.append(CHARACTERS_NO_SPACES + ": ");
            message.append(charCount);
        } else {
            String tabString = "     ";
            message.append(REGULAR_CONTENT + ":");
            message.append("\n");
            message.append(tabString);
            message.append(WORDS + ": ");
            message.append(wordCount);
            message.append("\n");
            message.append(tabString);
            message.append(CHARACTERS + ": ");
            message.append(charactersWithWSCount);
            message.append("\n");
            message.append(tabString);
            message.append(CHARACTERS_NO_SPACES + ": ");
            message.append(charCount);
            if (wordCountInFilteredCondProfiling > 0) {
                message.append("\n\n");
                message.append(FILTERED_CONTENT + ":");
                message.append("\n");
                message.append(tabString);
                message.append(WORDS + ": ");
                message.append(wordCountInFilteredCondProfiling);
                message.append("\n");
                message.append(tabString);
                message.append(CHARACTERS + ": ");
                message.append(charactersWithWSCountInFilteredCondProfiling);
                message.append("\n");
                message.append(tabString);
                message.append(CHARACTERS_NO_SPACES + ": ");
                message.append(charCountInFilteredCondProfiling);
            }
            if (wordCountInReadOnly > 0) {
                message.append("\n\n");
                message.append(READONLY_CONTENT + ":");
                message.append("\n");
                message.append(tabString);
                message.append(WORDS + ": ");
                message.append(wordCountInReadOnly);
                message.append("\n");
                message.append(tabString);
                message.append(CHARACTERS + ": ");
                message.append(charactersWithWSCountInReadOnly);
                message.append("\n");
                message.append(tabString);
                message.append(CHARACTERS_NO_SPACES + ": ");
                message.append(charCountInReadOnly);
            }
            message.append("\n\n");
            message.append(TOTAL + ":");
            message.append("\n");
            message.append(tabString);
            message.append(WORDS + ": ");
            message.append(wordCountInReadOnly + wordCountInFilteredCondProfiling + wordCount);
            message.append("\n");
            message.append(tabString);
            message.append(CHARACTERS + ": ");
            message.append(charactersWithWSCount + charactersWithWSCountInReadOnly + charactersWithWSCountInFilteredCondProfiling);
            message.append("\n");
            message.append(tabString);
            message.append(CHARACTERS_NO_SPACES + ": ");
            message.append(charCountInReadOnly + charCountInFilteredCondProfiling + charCount);
        }
        authorAccess.getWorkspaceAccess().showInformationMessage(message.toString());
    }

    public ArgumentDescriptor[] getArguments() {
        return null;
    }

    public String getDescription() {
        return "Count words either in the whole document or in the selection.";
    }

    private static boolean isWordStart(AuthorAccess authorAccess, int contentOffset) {
        AuthorDocumentController documentController = authorAccess.getDocumentController();
        boolean toRet = false;
        try {
            CharSequence contentCharSequence = documentController.getContentCharSequence();
            --contentOffset;
            while (contentOffset > 1) {
                char ch = contentCharSequence.charAt(contentOffset);
                if (ch == '\u0000') {
                    OffsetInformation contentInformationAtOffset = documentController.getContentInformationAtOffset(contentOffset);
                    AuthorNode nodeAtOffset = contentInformationAtOffset.getNodeForMarkerOffset();
                    Styles styles = authorAccess.getEditorAccess().getStyles(nodeAtOffset);
                    if (!styles.isInline()) {
                        toRet = true;
                        break;
                    }
                } else {
                    toRet = Character.isWhitespace(ch);
                    break;
                }
                --contentOffset;
            }
        }
        catch (BadLocationException ex) {
            logger.error((Object)ex, (Throwable)ex);
        }
        return toRet;
    }
}

