/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.text.BadLocationException;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.node.AuthorNode;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible(value=false)
public class ShowElementDocumentationOperation
implements AuthorOperation {
    private static final String ARGUMENT_NAME = "URL pattern";
    private static final String MACRO = "{Element_name}";
    private static final ArgumentDescriptor[] ARGUMENTS = new ArgumentDescriptor[]{new ArgumentDescriptor("URL pattern", 0, "The URL pattern of elements documentation.")};

    public void doOperation(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        String argVal = (String)args.getArgumentValue(ARGUMENT_NAME);
        int caretOffset = authorAccess.getEditorAccess().getCaretOffset();
        try {
            String nodeName = null;
            AuthorNode selectedNode = authorAccess.getEditorAccess().getFullySelectedNode();
            if (selectedNode != null) {
                nodeName = selectedNode.getName();
            } else {
                AuthorNode nodeAtOffset = authorAccess.getDocumentController().getNodeAtOffset(caretOffset);
                nodeName = nodeAtOffset.getName();
            }
            if (nodeName != null) {
                String elementDocLink = argVal.replace(MACRO, nodeName);
                authorAccess.getWorkspaceAccess().openInExternalApplication(new URL(elementDocLink), true);
            }
        }
        catch (MalformedURLException nodeName) {
        }
        catch (BadLocationException e) {
            throw new AuthorOperationException("The operation cannot be performed due to: " + e.getMessage(), (Throwable)e);
        }
    }

    public ArgumentDescriptor[] getArguments() {
        return ARGUMENTS;
    }

    public String getDescription() {
        return "Shows the current element documentation in reference manual.";
    }
}

