/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.operations.CommonsOperationsUtil;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible
public class ChangeAttributesOperation
implements AuthorOperation {
    private static final Logger logger = LoggerFactory.getLogger((String)ChangeAttributesOperation.class.getName());
    static final String ARGUMENT_ATTRIBUTE_NAMES = "attributeNames";
    static final String ARGUMENT_ATTRIBUTE_VALUES = "values";
    static final String ARGUMENT_ELEMENTS_XPATH_LOCATIONS = "elementLocations";
    static final String ARGUMENT_REMOVE_IF_EMPTY_VALUE = "removeIfEmpty";
    private ArgumentDescriptor[] arguments = new ArgumentDescriptor[4];

    public ChangeAttributesOperation() {
        ArgumentDescriptor argDescriptor;
        this.arguments[0] = argDescriptor = new ArgumentDescriptor(ARGUMENT_ELEMENTS_XPATH_LOCATIONS, 2, "An XPath expression indicating the elements whose attributes will be affected.\nNote: If it is not defined, then the element at the caret position will be used.");
        this.arguments[1] = argDescriptor = new ArgumentDescriptor(ARGUMENT_ATTRIBUTE_NAMES, 0, "The names of the attributes to change/insert/remove, each on a new line. The provided values can be local names or Clark notations {attribute_namespace}attibute_name.");
        this.arguments[2] = argDescriptor = new ArgumentDescriptor(ARGUMENT_ATTRIBUTE_VALUES, 0, "The attribute values, each on a new line. An empty value will remove the corresponding attribute if 'removeIfEmpty' is set to 'true' (it is by default).");
        this.arguments[3] = argDescriptor = new ArgumentDescriptor(ARGUMENT_REMOVE_IF_EMPTY_VALUE, 3, "'true' means the attribute should be removed if an empty value is provided. The default value is 'true'.", new String[]{"true", "false"}, "true");
    }

    public void doOperation(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        AuthorDocumentController docController = authorAccess.getDocumentController();
        Object names = args.getArgumentValue(ARGUMENT_ATTRIBUTE_NAMES);
        Object values = args.getArgumentValue(ARGUMENT_ATTRIBUTE_VALUES);
        Object xpathLocations = args.getArgumentValue(ARGUMENT_ELEMENTS_XPATH_LOCATIONS);
        if (names instanceof String && !((String)names).isEmpty()) {
            AuthorElement[] targetElements;
            Object removeIfEmpty;
            String attrNamesString = ((String)names).trim();
            String[] splitAttrNames = attrNamesString.split("\n");
            String[] attrNames = new String[splitAttrNames.length];
            String[] attrNamespaces = new String[splitAttrNames.length];
            for (int i = 0; i < splitAttrNames.length; ++i) {
                String token = splitAttrNames[i].trim();
                if (token.startsWith("{") && token.contains("}")) {
                    if (token.indexOf(125) < token.length() - 1) {
                        attrNames[i] = token.substring(token.indexOf(125) + 1).trim();
                        attrNamespaces[i] = token.substring(token.indexOf(123) + 1, token.indexOf(125)).trim();
                        continue;
                    }
                    throw new AuthorOperationException("Incorrect Clark notation. The attribute name must be specified after the namespace value '{" + token.substring(token.indexOf(123) + 1, token.indexOf(125)).trim() + "}'.");
                }
                attrNames[i] = token.trim();
                attrNamespaces[i] = "";
            }
            String[] attrValues = null;
            if (values instanceof String) {
                String attrValuesString = (String)values;
                attrValues = attrValuesString.split("\n");
            }
            if ((removeIfEmpty = args.getArgumentValue(ARGUMENT_REMOVE_IF_EMPTY_VALUE)) == null) {
                removeIfEmpty = "true";
            }
            for (AuthorElement elem : targetElements = ChangeAttributesOperation.detectTargetElements(authorAccess, xpathLocations)) {
                for (int i = 0; i < attrNames.length; ++i) {
                    CommonsOperationsUtil.setAttributeValue(docController, elem, new QName(attrNamespaces[i], attrNames[i], ""), attrValues != null && i < attrValues.length ? attrValues[i].trim() : "", "true".equals(removeIfEmpty));
                }
            }
        } else {
            throw new IllegalArgumentException("The argument 'attributeNames' was not defined!");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static AuthorElement[] detectTargetElements(AuthorAccess authorAccess, Object xpathLocations) throws AuthorOperationException {
        AuthorElement[] targetElements = null;
        AuthorDocumentController docController = authorAccess.getDocumentController();
        if (!(xpathLocations instanceof String)) return ChangeAttributesOperation.detectElementAtOffset(authorAccess);
        if (((String)xpathLocations).isEmpty()) return ChangeAttributesOperation.detectElementAtOffset(authorAccess);
        List<AuthorNode> results = Arrays.asList(docController.findNodesByXPath((String)xpathLocations, true, true, true));
        if (results.isEmpty()) throw new AuthorOperationException("The element XPath location does not identify any elements: " + xpathLocations);
        Iterator<AuthorNode> iterator = results.iterator();
        while (iterator.hasNext()) {
            AuthorNode next = iterator.next();
            if (next instanceof AuthorElement) continue;
            iterator.remove();
            logger.warn("The current node is not an element. It won't be taken into account. Node: " + next);
        }
        return results.toArray(new AuthorElement[results.size()]);
    }

    private static AuthorElement[] detectElementAtOffset(AuthorAccess authorAccess) throws AuthorOperationException {
        AuthorNode node = null;
        try {
        }
        catch (BadLocationException e) {
            throw new AuthorOperationException("Cannot identify the current element.", (Throwable)e);
        }
        for (node = authorAccess.getDocumentController().getNodeAtOffset(authorAccess.getEditorAccess().getCaretOffset()); node != null && !(node instanceof AuthorElement); node = node.getParent()) {
        }
        AuthorElement[] targetElements = null;
        if (!(node instanceof AuthorElement)) {
            throw new AuthorOperationException("You need to have the caret inside an element.");
        }
        targetElements = new AuthorElement[]{(AuthorElement)node};
        return targetElements;
    }

    public ArgumentDescriptor[] getArguments() {
        return this.arguments;
    }

    public String getDescription() {
        return "Add/change/remove one or more attributes for one or more elements.";
    }
}

