/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.tomcat.custom;

import com.oxygenxml.tomcat.custom.PasswordHasher;
import com.oxygenxml.tomcat.custom.ShiroHasherClassLoader;
import com.oxygenxml.tomcat.custom.ShiroPassword;
import com.oxygenxml.tomcat.custom.ShiroUser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.realm.RealmBase;

public class ShiroRealm
extends RealmBase {
    private static final String USER_PREFIX = "user.";
    private final Map<String, ShiroUser> users = new HashMap<String, ShiroUser>();
    private File tomcatDir = new File(System.getProperty("catalina.home"));
    private final ShiroHasherClassLoader classLoader;

    public ShiroRealm() throws IOException {
        File shiroLicenseUsersFile = new File(this.tomcatDir, "work/Catalina/localhost/license-servlet/license-shiro-users.ini");
        this.users.putAll(this.loadUsers(shiroLicenseUsersFile));
        this.classLoader = new ShiroHasherClassLoader();
    }

    private Map<String, ShiroUser> loadUsers(File shiroAdminUsersFile) {
        HashMap<String, ShiroUser> loadedUsers = new HashMap<String, ShiroUser>();
        if (!shiroAdminUsersFile.exists()) {
            return loadedUsers;
        }
        Properties properties = new Properties();
        try (FileInputStream is = new FileInputStream(shiroAdminUsersFile);){
            properties.load(is);
        }
        catch (IOException e) {
            System.err.println("Could not load users from " + shiroAdminUsersFile.getAbsolutePath());
            System.err.println(e.getMessage());
        }
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String property = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!property.startsWith(USER_PREFIX)) continue;
            String username = property.substring(USER_PREFIX.length());
            String[] split = value.split(",");
            String hashedPassword = split[0].trim();
            ArrayList<String> roles = new ArrayList<String>();
            for (int i = 1; i < split.length; ++i) {
                roles.add(split[i].trim());
            }
            ShiroUser user = new ShiroUser(username, new ShiroPassword(hashedPassword), roles);
            loadedUsers.put(username, user);
        }
        return loadedUsers;
    }

    protected String getPassword(String username) {
        return this.users.get(username).getShiroPassword().getHash();
    }

    protected Principal getPrincipal(String username) {
        ShiroUser user = this.users.get(username);
        if (user == null) {
            return null;
        }
        String password = user.getShiroPassword().getHash();
        return new GenericPrincipal(username, password, user.getRoles());
    }

    public Principal authenticate(String username, String password) {
        ShiroUser user = this.users.get(username);
        if (user == null) {
            File shiroAdminUsersFile = new File(this.tomcatDir, "work/Catalina/localhost/oxygen-xml-web-author/shiro-users.ini");
            Map<String, ShiroUser> loadedUsers = this.loadUsers(shiroAdminUsersFile);
            this.users.putAll(loadedUsers);
        }
        if ((user = this.users.get(username)) == null) {
            return null;
        }
        Principal principal = null;
        ShiroPassword shiroPassword = user.getShiroPassword();
        if (shiroPassword.isHashed()) {
            PasswordHasher passwordHasher = new PasswordHasher(this.classLoader, shiroPassword.getParams());
            String hashedProvidedPassword = passwordHasher.hashPassword(password);
            if (shiroPassword.getHash().equals(hashedProvidedPassword)) {
                principal = this.getPrincipal(username);
            }
        } else if (shiroPassword.getHash().equals(password)) {
            principal = this.getPrincipal(username);
        }
        return principal;
    }

    protected void destroyInternal() throws LifecycleException {
        try {
            this.classLoader.close();
        }
        finally {
            super.destroyInternal();
        }
    }

    public ShiroHasherClassLoader getClassLoaderForTest() {
        return this.classLoader;
    }
}

