/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.tomcat.custom;

import com.oxygenxml.tomcat.custom.HashingParams;
import java.util.Base64;

public class ShiroPassword {
    private static final int SALT_INDEX = 4;
    private static final int ITERATIONS_INDEX = 3;
    private static final int ALGORITHM_INDEX = 2;
    private String hash;
    private final HashingParams params;
    private boolean isHashed = true;

    public ShiroPassword(String shiroHash) {
        this.hash = shiroHash;
        if (shiroHash.indexOf("$shiro1$") == -1) {
            this.isHashed = false;
            this.params = null;
            return;
        }
        String[] components = shiroHash.split("\\$");
        String algorithm = components[2];
        int iterations = Integer.parseInt(components[3]);
        byte[] salt = Base64.getDecoder().decode(components[4].getBytes());
        this.params = new HashingParams(algorithm, salt, iterations);
    }

    public String getHash() {
        return this.hash;
    }

    public boolean isHashed() {
        return this.isHashed;
    }

    public HashingParams getParams() {
        return this.params;
    }
}

