/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.tomcat.custom;

import com.oxygenxml.tomcat.custom.JarClassLoaderWithAllPermissions;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class ShiroHasherClassLoader {
    private static final Log logger = LogFactory.getLog(ShiroHasherClassLoader.class);
    private static final String SHIRO_HASHER_JAR = "/shiro-hasher.jar";
    private File shiroHasherJar = ShiroHasherClassLoader.extractShiroHasher();
    private URLClassLoader classLoader = new JarClassLoaderWithAllPermissions(this.shiroHasherJar.toURI().toURL());

    private static File extractShiroHasher() throws IOException {
        File tempJar = Files.createTempFile("shiro-hasher", ".jar", new FileAttribute[0]).toFile();
        try (InputStream shiroHasherInputStream = ShiroHasherClassLoader.class.getResourceAsStream(SHIRO_HASHER_JAR);
             FileOutputStream tempJarOutputStream = new FileOutputStream(tempJar);){
            int bytesRead;
            byte[] buffer = new byte[8192];
            while ((bytesRead = shiroHasherInputStream.read(buffer)) != -1) {
                tempJarOutputStream.write(buffer, 0, bytesRead);
            }
        }
        return tempJar;
    }

    public Class<?> loadClass(String className) throws ClassNotFoundException {
        return this.classLoader.loadClass(className);
    }

    public void close() {
        try {
            this.classLoader.close();
        }
        catch (IOException e) {
            logger.warn((Object)"Could not close classloader", (Throwable)e);
        }
        finally {
            try {
                Files.delete(this.shiroHasherJar.toPath());
            }
            catch (IOException e) {
                logger.warn((Object)"Could not delete temporary file", (Throwable)e);
            }
        }
    }

    public File getShiroHasherJarForTest() {
        return this.shiroHasherJar;
    }
}

