/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.tomcat.custom;

import com.oxygenxml.tomcat.custom.HashingParams;
import com.oxygenxml.tomcat.custom.ShiroHasherClassLoader;
import java.lang.reflect.InvocationTargetException;

public class PasswordHasher {
    private static final String SHIRO_HASHER_METHOD_NAME = "shiroDigestPassword";
    private static final String SHIRO_HASHER_CLASS = "com.oxygenxml.webapp.installer.ShiroHasher";
    private final HashingParams params;
    private ShiroHasherClassLoader classloader;

    public PasswordHasher(ShiroHasherClassLoader classloader, HashingParams params) {
        this.classloader = classloader;
        this.params = params;
    }

    public String hashPassword(String password) {
        try {
            Class<?> utils = this.classloader.loadClass(SHIRO_HASHER_CLASS);
            return (String)utils.getDeclaredMethod(SHIRO_HASHER_METHOD_NAME, String.class, String.class, byte[].class, Integer.TYPE).invoke(null, password, this.params.getAlgorithm(), this.params.getSalt(), this.params.getIterations());
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }
}

