/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.tomcat.custom;

import java.net.URL;
import java.net.URLClassLoader;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.cert.Certificate;

public final class JarClassLoaderWithAllPermissions
extends URLClassLoader {
    private final CodeSource jarCodeSource;
    private final PermissionCollection perms;

    public JarClassLoaderWithAllPermissions(URL jarUrl) {
        super(new URL[]{jarUrl});
        this.jarCodeSource = new CodeSource(jarUrl, (Certificate[])null);
        this.perms = JarClassLoaderWithAllPermissions.createFullPermisions();
    }

    private static Permissions createFullPermisions() {
        Permissions perms = new Permissions();
        perms.add(new AllPermission());
        perms.setReadOnly();
        return perms;
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource cs) {
        return this.jarCodeSource.implies(cs) ? this.perms : super.getPermissions(cs);
    }
}

