/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.cmis.web.action;

import com.oxygenxml.cmis.core.urlhandler.CmisURLConnection;
import com.oxygenxml.cmis.web.action.CmisActionsUtills;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.webapp.AuthorDocumentModel;
import ro.sync.ecss.extensions.api.webapp.AuthorOperationWithResult;
import ro.sync.ecss.extensions.api.webapp.WebappRestSafe;

@WebappRestSafe
public class DiscardCheckOutOperation
extends AuthorOperationWithResult {
    public String doOperation(AuthorDocumentModel model, ArgumentsMap args) throws IllegalArgumentException, AuthorOperationException {
        this.doOperationInternal(model);
        return null;
    }

    private void doOperationInternal(AuthorDocumentModel model) throws CmisObjectNotFoundException {
        AuthorAccess authorAccess = model.getAuthorAccess();
        URL url = authorAccess.getEditorAccess().getEditorLocation();
        CmisURLConnection connection = CmisActionsUtills.getCmisURLConnection(url);
        URL urlWithoutContextId = CmisActionsUtills.getUrlWithoutContextIdAndVersion(url);
        try {
            String urlString = urlWithoutContextId.toExternalForm();
            Document document = (Document)connection.getCMISObject(urlString);
            this.discardPwc(document);
        }
        catch (MalformedURLException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void discardPwc(Document document) {
        Document latest = document.getObjectOfLatestVersion(false);
        if (!latest.isVersionSeriesCheckedOut().booleanValue()) {
            throw new IllegalStateException();
        }
        latest.cancelCheckOut();
    }
}

