/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.cmis.web.action;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.oxygenxml.cmis.core.CmisCredentials;
import com.oxygenxml.cmis.core.urlhandler.CmisURLConnection;
import com.oxygenxml.cmis.web.CredentialsManager;
import com.oxygenxml.cmis.web.action.CmisActionsUtills;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUnauthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.webapp.AuthorDocumentModel;
import ro.sync.ecss.extensions.api.webapp.AuthorOperationWithResult;
import ro.sync.ecss.extensions.api.webapp.WebappRestSafe;
import ro.sync.ecss.extensions.api.webapp.access.WebappPluginWorkspace;
import ro.sync.exml.workspace.api.PluginResourceBundle;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;

@WebappRestSafe
public class CmisOldVersions
extends AuthorOperationWithResult {
    private static final Logger log = LoggerFactory.getLogger(CmisOldVersions.class);

    public String doOperation(AuthorDocumentModel model, ArgumentsMap args) throws AuthorOperationException {
        AuthorAccess authorAccess = model.getAuthorAccess();
        authorAccess.getWorkspaceAccess();
        URL url = authorAccess.getEditorAccess().getEditorLocation();
        CmisCredentials currentUser = CredentialsManager.INSTANCE.getCredentials(url.getUserInfo());
        CmisURLConnection connection = CmisActionsUtills.getCmisURLConnection(url);
        URL urlWithoutContextId = CmisActionsUtills.getUrlWithoutContextId(url);
        URL urlWithoutContextIdAndVersion = CmisActionsUtills.stripVersion(urlWithoutContextId);
        Document document = null;
        try {
            document = (Document)connection.getCMISObject(urlWithoutContextIdAndVersion.toExternalForm());
        }
        catch (MalformedURLException | CmisObjectNotFoundException | CmisUnauthorizedException e) {
            log.debug("Error getting CMIS document " + urlWithoutContextIdAndVersion);
            throw new AuthorOperationException(e.getMessage());
        }
        try {
            List<Map<String, String>> allVersions = CmisOldVersions.listOldVersions(document, urlWithoutContextId, currentUser);
            String oldVersionJSON = new ObjectMapper().writeValueAsString(allVersions);
            if (oldVersionJSON != null && !oldVersionJSON.isEmpty()) {
                return oldVersionJSON;
            }
        }
        catch (Exception e) {
            return CmisActionsUtills.returnErrorInfoJSON("denied", e.getMessage());
        }
        return CmisActionsUtills.returnErrorInfoJSON("no_error", null);
    }

    public static List<Map<String, String>> listOldVersions(Document document, URL currentDocUrl, CmisCredentials currentUser) throws IOException {
        PluginResourceBundle rb = ((WebappPluginWorkspace)PluginWorkspaceProvider.getPluginWorkspace()).getResourceBundle();
        Optional<String> currentDocVersion = CmisActionsUtills.getVersionId(currentDocUrl);
        String docUrlWithoutVersion = CmisActionsUtills.stripVersion(currentDocUrl).toExternalForm();
        List allVersions = document.getObjectOfLatestVersion(false).getAllVersions();
        ArrayList<Map<String, String>> versions = new ArrayList<Map<String, String>>();
        for (int i = 0; i < allVersions.size(); ++i) {
            boolean isCurrentVersion;
            Document version = (Document)allVersions.get(i);
            String versionId = version.getId();
            boolean isPwcVersion = Boolean.TRUE.equals(version.isPrivateWorkingCopy()) || Boolean.TRUE.equals(version.isVersionSeriesPrivateWorkingCopy());
            boolean isCheckedOutByMe = currentUser.getUsername().equals(document.getVersionSeriesCheckedOutBy());
            if (currentDocVersion.isPresent()) {
                isCurrentVersion = version.getId().equals(currentDocVersion.get());
            } else {
                boolean bl = isCurrentVersion = isPwcVersion && isCheckedOutByMe;
            }
            String label = isPwcVersion ? (isCurrentVersion ? rb.getMessage("Current") : "PWC") : version.getVersionLabel();
            Object urlParam = isPwcVersion ? docUrlWithoutVersion : docUrlWithoutVersion + "?oldversion=" + versionId;
            String commitMessage = version.getCheckinComment() != null ? version.getCheckinComment() : "";
            String authorName = version.getLastModifiedBy();
            versions.add(CmisOldVersions.createProps(label, (String)urlParam, commitMessage, authorName, isCurrentVersion));
        }
        return versions;
    }

    private static Map<String, String> createProps(String label, String urlParam, String commitMessage, String authorName, boolean isCurrentVersion) {
        HashMap<String, String> props = new HashMap<String, String>(3);
        props.put("version", label);
        props.put("url", urlParam);
        props.put("author", authorName);
        if (commitMessage != null) {
            props.put("commitMessage", commitMessage);
        }
        props.put("isCurrentVersion", String.valueOf(isCurrentVersion));
        return props;
    }
}

