/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.cmis.web.action;

import com.oxygenxml.cmis.core.urlhandler.CmisURLConnection;
import com.oxygenxml.cmis.web.action.CmisActionsUtills;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUnauthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.webapp.AuthorDocumentModel;
import ro.sync.ecss.extensions.api.webapp.AuthorOperationWithResult;
import ro.sync.ecss.extensions.api.webapp.WebappRestSafe;
import ro.sync.ecss.extensions.api.webapp.access.WebappPluginWorkspace;
import ro.sync.ecss.extensions.commons.operations.ReloadContentOperation;
import ro.sync.exml.workspace.api.PluginResourceBundle;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.editor.ReadOnlyReason;

@WebappRestSafe
public class CmisCheckOut
extends AuthorOperationWithResult {
    private static final Logger log = LoggerFactory.getLogger(CmisCheckOut.class);

    public String doOperation(AuthorDocumentModel model, ArgumentsMap args) throws AuthorOperationException {
        AuthorAccess authorAccess = model.getAuthorAccess();
        authorAccess.getWorkspaceAccess();
        URL url = authorAccess.getEditorAccess().getEditorLocation();
        CmisURLConnection connection = CmisActionsUtills.getCmisURLConnection(url);
        String urlWithoutContextId = CmisActionsUtills.getUrlWithoutContextIdAndVersion(url).toExternalForm();
        Document document = null;
        try {
            document = (Document)connection.getCMISObject(urlWithoutContextId);
        }
        catch (MalformedURLException | CmisObjectNotFoundException | CmisUnauthorizedException e) {
            log.error("Error getting CMIS document " + urlWithoutContextId);
            throw new AuthorOperationException(e.getMessage());
        }
        try {
            document = document.getObjectOfLatestVersion(false);
            boolean canCheckoutDocument = connection.canCheckoutDocument(document);
            if (!canCheckoutDocument) {
                WebappPluginWorkspace pluginWorkspace = (WebappPluginWorkspace)PluginWorkspaceProvider.getPluginWorkspace();
                PluginResourceBundle rb = pluginWorkspace.getResourceBundle();
                String checkedOutBy = document.getVersionSeriesCheckedOutBy();
                model.getAuthorAccess().getEditorAccess().setReadOnly(new ReadOnlyReason(MessageFormat.format(rb.getMessage("Checked_out_by"), checkedOutBy)));
                this.reloadDocument(authorAccess);
                return CmisActionsUtills.returnErrorInfoJSON("checked_out_by", MessageFormat.format(rb.getMessage("Cannot_check_out_checked_out_by"), document.getName(), checkedOutBy));
            }
            CmisCheckOut.checkOutDocument(document);
            authorAccess.getEditorAccess().setEditable(true);
            this.reloadDocument(authorAccess);
        }
        catch (Exception e) {
            log.info(connection.getUserCredentials().getUsername() + " CANNOT checkout " + document.getName() + " " + e.getMessage());
            return CmisActionsUtills.returnErrorInfoJSON("denied", e.getMessage());
        }
        return CmisActionsUtills.returnErrorInfoJSON("success", null);
    }

    void reloadDocument(AuthorAccess authorAccess) throws AuthorOperationException {
        new ReloadContentOperation().doOperation(authorAccess, argumentName -> "markAsNotModified".equals(argumentName) ? "true" : "");
    }

    public static void checkOutDocument(Document document) {
        document.checkOut();
        document.refresh();
    }
}

