/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.cmis.web.action;

import com.oxygenxml.cmis.core.urlhandler.CmisURLConnection;
import com.oxygenxml.cmis.web.EditorListener;
import com.oxygenxml.cmis.web.action.CmisActionsUtills;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUnauthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.webapp.AuthorDocumentModel;
import ro.sync.ecss.extensions.api.webapp.AuthorOperationWithResult;
import ro.sync.ecss.extensions.api.webapp.WebappRestSafe;
import ro.sync.ecss.extensions.api.webapp.access.WebappPluginWorkspace;
import ro.sync.exml.workspace.api.PluginResourceBundle;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.editor.ReadOnlyReason;

@WebappRestSafe
public class CmisCheckIn
extends AuthorOperationWithResult {
    private static final Logger log = LoggerFactory.getLogger(CmisCheckIn.class);

    public String doOperation(AuthorDocumentModel model, ArgumentsMap args) throws AuthorOperationException {
        AuthorAccess authorAccess = model.getAuthorAccess();
        authorAccess.getWorkspaceAccess();
        URL url = authorAccess.getEditorAccess().getEditorLocation();
        CmisURLConnection connection = CmisActionsUtills.getCmisURLConnection(url);
        String urlWithoutContextId = CmisActionsUtills.getUrlWithoutContextIdAndVersion(url).toExternalForm();
        Document document = null;
        try {
            document = (Document)connection.getCMISObject(urlWithoutContextId);
        }
        catch (MalformedURLException | CmisObjectNotFoundException | CmisUnauthorizedException e) {
            log.debug("Error getting CMIS document " + urlWithoutContextId);
            throw new AuthorOperationException(e.getMessage());
        }
        String commitMessage = (String)args.getArgumentValue("commit");
        String actualState = (String)args.getArgumentValue("state");
        PluginResourceBundle rb = ((WebappPluginWorkspace)PluginWorkspaceProvider.getPluginWorkspace()).getResourceBundle();
        try {
            CmisCheckIn.checkInDocument(document, actualState, commitMessage);
            if (EditorListener.isCheckOutRequired()) {
                authorAccess.getEditorAccess().setReadOnly(new ReadOnlyReason(rb.getMessage("Check_out_required")));
            }
        }
        catch (Exception e) {
            return CmisActionsUtills.returnErrorInfoJSON("denied", e.getMessage());
        }
        return CmisActionsUtills.returnErrorInfoJSON("no_error", null);
    }

    public static void checkInDocument(Document document, String actualState, String commitMessage) {
        Document latest = CmisActionsUtills.getLatestVersion(document);
        if (document.isVersionSeriesCheckedOut().booleanValue()) {
            if (commitMessage == null || commitMessage == "null") {
                commitMessage = "";
            }
            ContentStream currentVersionStream = CmisCheckIn.getCurrentVersionContentStream(document);
            latest.checkIn(CmisCheckIn.isMajorVersion(actualState), null, currentVersionStream, commitMessage);
            latest.refresh();
            log.info(latest.getName() + " checked-out: " + latest.isVersionSeriesCheckedOut());
        } else {
            log.info("Document isn't checked-out!");
        }
    }

    private static ContentStream getCurrentVersionContentStream(Document document) {
        ContentStream currentVersionStream = null;
        Document objOflatestVersion = document.getObjectOfLatestVersion(false);
        List allVersions = objOflatestVersion.getAllVersions();
        if (!allVersions.isEmpty()) {
            currentVersionStream = ((Document)allVersions.get(0)).getContentStream();
        }
        return currentVersionStream;
    }

    private static boolean isMajorVersion(String actualState) {
        return actualState.equals("major");
    }
}

