/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.cmis.web.action;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.oxygenxml.cmis.core.CMISAccess;
import com.oxygenxml.cmis.core.CmisCredentials;
import com.oxygenxml.cmis.core.urlhandler.CmisURLConnection;
import com.oxygenxml.cmis.web.CredentialsManager;
import com.oxygenxml.cmis.web.EditorOption;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Optional;
import org.apache.chemistry.opencmis.client.api.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.ecss.extensions.api.webapp.plugin.URLStreamHandlerWithContextUtil;

public class CmisActionsUtills {
    private static final Logger log = LoggerFactory.getLogger(CmisActionsUtills.class);

    private CmisActionsUtills() {
    }

    private static String getErrorInfoJSON(String errorType, String errorInfo) throws IOException {
        HashMap<String, String> errorMap = new HashMap<String, String>();
        errorMap.put("error", errorType);
        if (errorInfo != null && !errorMap.isEmpty()) {
            errorMap.put("message", errorInfo);
        }
        return new ObjectMapper().writeValueAsString(errorMap);
    }

    public static String returnErrorInfoJSON(String errorType, String errorMessage) {
        String errorInfoJSON = null;
        try {
            errorInfoJSON = CmisActionsUtills.getErrorInfoJSON(errorType, errorMessage);
        }
        catch (IOException e) {
            log.debug(e.getMessage());
        }
        return errorInfoJSON;
    }

    public static CmisURLConnection getCmisURLConnection(URL url) {
        String contextId = url.getUserInfo();
        CmisCredentials credentials = CredentialsManager.INSTANCE.getCredentials(contextId);
        log.info("Getting connection!");
        return new CmisURLConnection(url, new CMISAccess(), credentials);
    }

    public static URL getUrlWithoutContextIdAndVersion(URL url) {
        return CmisActionsUtills.stripVersion(CmisActionsUtills.getUrlWithoutContextId(url));
    }

    public static URL getUrlWithoutContextId(URL url) {
        String urlWithoutContextId = URLStreamHandlerWithContextUtil.getInstance().toStrippedExternalForm(url);
        try {
            return new URL(urlWithoutContextId);
        }
        catch (MalformedURLException e) {
            throw new UncheckedIOException(e);
        }
    }

    static URL stripVersion(URL url) {
        String urlStr = url.toExternalForm();
        if (urlStr.contains(EditorOption.OLD_VERSION.getValue()) || urlStr.contains("?")) {
            urlStr = urlStr.substring(0, urlStr.indexOf(63));
        }
        try {
            return new URL(urlStr);
        }
        catch (MalformedURLException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static Optional<String> getVersionId(URL url) {
        Optional<String> toReturn = Optional.empty();
        String query = url.getQuery();
        if (query != null) {
            HashMap<String, String> queryPart = new HashMap<String, String>();
            for (String pair : url.getQuery().split("&")) {
                int index = pair.indexOf(61);
                queryPart.put(pair.substring(0, index), pair.substring(index + 1));
            }
            String objectId = (String)queryPart.get(EditorOption.OLD_VERSION.getValue());
            toReturn = Optional.ofNullable(objectId);
        }
        return toReturn;
    }

    public static Document getLatestVersion(Document document) {
        Document latest = document;
        if (!Boolean.TRUE.equals(document.isLatestVersion())) {
            latest = document.getObjectOfLatestVersion(false);
        }
        return latest;
    }
}

