/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.cmis.web;

import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.exml.plugin.workspace.security.Response;
import ro.sync.exml.plugin.workspace.security.TrustedHostsProviderExtension;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.options.WSOptionChangedEvent;
import ro.sync.exml.workspace.api.options.WSOptionListener;
import ro.sync.exml.workspace.api.options.WSOptionsStorage;

public class TrustedHostsProvider
implements TrustedHostsProviderExtension {
    private static final Logger log = LoggerFactory.getLogger(TrustedHostsProvider.class);
    private String enforcedHost = null;

    public TrustedHostsProvider() {
        final WSOptionsStorage optionsStorage = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage();
        this.updateEnforcedHost(optionsStorage);
        optionsStorage.addOptionListener(new WSOptionListener("cmis.enforced_url"){

            public void optionValueChanged(WSOptionChangedEvent event) {
                TrustedHostsProvider.this.updateEnforcedHost(optionsStorage);
            }
        });
    }

    private void updateEnforcedHost(WSOptionsStorage optionsStorage) {
        this.enforcedHost = null;
        String enforcedUrl = optionsStorage.getOption("cmis.enforced_url", "");
        if (enforcedUrl != null && !enforcedUrl.isEmpty()) {
            try {
                URL url = new URL(enforcedUrl);
                this.enforcedHost = url.getHost() + ":" + (url.getPort() != -1 ? url.getPort() : url.getDefaultPort());
            }
            catch (MalformedURLException e) {
                log.warn(e.getMessage(), (Throwable)e);
            }
        }
    }

    public Response isTrusted(String hostName) {
        if (hostName.equals(this.enforcedHost)) {
            return TRUSTED;
        }
        return UNKNOWN;
    }
}

