/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.cmis.web;

import com.google.common.annotations.VisibleForTesting;
import com.oxygenxml.cmis.core.CMISAccess;
import com.oxygenxml.cmis.core.CmisCredentials;
import com.oxygenxml.cmis.core.ResourceController;
import com.oxygenxml.cmis.core.urlhandler.CmisURLConnection;
import com.oxygenxml.cmis.web.CredentialsManager;
import com.oxygenxml.cmis.web.EditorOption;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Optional;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUnauthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.access.EditingSessionContext;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.webapp.AuthorDocumentModel;
import ro.sync.ecss.extensions.api.webapp.access.WebappEditingSessionLifecycleListener;
import ro.sync.ecss.extensions.api.webapp.access.WebappPluginWorkspace;
import ro.sync.exml.plugin.workspace.WorkspaceAccessPluginExtension;
import ro.sync.exml.workspace.api.PluginResourceBundle;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.editor.ReadOnlyReason;
import ro.sync.exml.workspace.api.options.WSOptionsStorage;
import ro.sync.exml.workspace.api.standalone.StandalonePluginWorkspace;

public class EditorListener
implements WorkspaceAccessPluginExtension {
    private static final Logger log = LoggerFactory.getLogger(EditorListener.class);
    private static final String CMIS_SERVICE_SUPPORTS_CHECKIN_COMMENT = "cmis.service.supports_checkin_comment";
    private PluginResourceBundle rb;
    private URL url;
    private String urlWithoutContextId;
    private CmisCredentials credentials;
    private CmisURLConnection connection;
    private Document document;

    public void applicationStarted(StandalonePluginWorkspace pluginWorkspaceAccess) {
        final WebappPluginWorkspace webappPluginWorkspace = (WebappPluginWorkspace)pluginWorkspaceAccess;
        webappPluginWorkspace.addEditingSessionLifecycleListener(new WebappEditingSessionLifecycleListener(){

            public void editingSessionStarted(String sessionId, AuthorDocumentModel documentModel) {
                EditorListener.this.editingSessionStarted(webappPluginWorkspace, documentModel);
            }
        });
    }

    @VisibleForTesting
    public void editingSessionStarted(WebappPluginWorkspace webappPluginWorkspace, AuthorDocumentModel documentModel) {
        AuthorAccess authorAccess = documentModel.getAuthorAccess();
        this.url = authorAccess.getEditorAccess().getEditorLocation();
        if (this.url == null || !this.url.getProtocol().equals("cmis")) {
            return;
        }
        this.urlWithoutContextId = this.url.getProtocol() + "://" + this.url.getHost() + this.url.getPath();
        String contextId = this.url.getUserInfo();
        this.credentials = CredentialsManager.INSTANCE.getCredentials(contextId);
        this.connection = new CmisURLConnection(this.url, new CMISAccess(), this.credentials);
        this.rb = webappPluginWorkspace.getResourceBundle();
        try {
            log.info("EditorListener was loaded!");
            if (this.url.getQuery() != null && this.url.getQuery().contains(EditorOption.OLD_VERSION.getValue())) {
                this.setOldVersionsOptions(webappPluginWorkspace, documentModel);
            } else {
                this.document = (Document)this.connection.getCMISObject(this.urlWithoutContextId);
                boolean isCheckinCommentSupported = this.isCheckinCommentSupported();
                if (isCheckinCommentSupported) {
                    AuthorDocumentController controller = documentModel.getAuthorDocumentController();
                    AuthorElement rootElement = controller.getAuthorDocumentNode().getRootElement();
                    controller.setPseudoClass(EditorOption.SUPPORTS_COMMIT_MESSAGE.getValue(), rootElement);
                }
                this.setEditorsOptions(documentModel);
            }
        }
        catch (MalformedURLException | CmisObjectNotFoundException | CmisUnauthorizedException e1) {
            log.info(e1.getMessage());
        }
    }

    private boolean isCheckinCommentSupported() {
        WSOptionsStorage optionsStorage = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage();
        String isSupportingCommentConfig = Optional.ofNullable(System.getProperty(CMIS_SERVICE_SUPPORTS_CHECKIN_COMMENT)).orElse(optionsStorage.getOption(CMIS_SERVICE_SUPPORTS_CHECKIN_COMMENT, null));
        return this.document.getCheckinComment() != null || "true".equals(isSupportingCommentConfig);
    }

    private void setEditorsOptions(AuthorDocumentModel documentModel) {
        if (!this.document.isVersionable()) {
            AuthorDocumentController controller = documentModel.getAuthorDocumentController();
            AuthorElement rootElement = controller.getAuthorDocumentNode().getRootElement();
            controller.setPseudoClass(EditorOption.NON_VERSIONABLE.getValue(), rootElement);
        } else if (this.document.isVersionSeriesCheckedOut().booleanValue()) {
            this.setVersionableOptions(documentModel);
        } else {
            boolean isPreview;
            EditingSessionContext editingContext = documentModel.getAuthorAccess().getEditorAccess().getEditingContext();
            Object previewMode = editingContext.getAttribute("previewMode");
            boolean bl = isPreview = "true".equals(previewMode) || Boolean.TRUE.equals(previewMode);
            if (!isPreview && EditorListener.isCheckOutRequired() && !this.document.isVersionSeriesCheckedOut().booleanValue()) {
                documentModel.getAuthorAccess().getEditorAccess().setReadOnly(new ReadOnlyReason(this.rb.getMessage("Check_out_required")));
            }
        }
    }

    private void setVersionableOptions(AuthorDocumentModel documentModel) {
        String versionSeriesCheckedOutBy = this.document.getVersionSeriesCheckedOutBy();
        ResourceController resourceController = this.connection.getCMISAccess().createResourceController();
        Document pwcDoc = this.document;
        if (this.document.getVersionSeriesCheckedOutId() != null) {
            String pwcId = this.document.getVersionSeriesCheckedOutId();
            pwcDoc = (Document)resourceController.getSession().getObject(pwcId);
        }
        boolean canEditDocument = this.connection.canCheckoutDocument(pwcDoc);
        AuthorDocumentController controller = documentModel.getAuthorDocumentController();
        AuthorElement rootElement = controller.getAuthorDocumentNode().getRootElement();
        if (canEditDocument) {
            controller.setPseudoClass(EditorOption.IS_CHECKED_OUT.getValue(), rootElement);
        } else {
            documentModel.getAuthorAccess().getEditorAccess().setReadOnly(new ReadOnlyReason(MessageFormat.format(this.rb.getMessage("Checked_out_by"), versionSeriesCheckedOutBy)));
            controller.setPseudoClass(EditorOption.LOCKED.getValue(), rootElement);
        }
    }

    private void setOldVersionsOptions(WebappPluginWorkspace webappPluginWorkspace, AuthorDocumentModel documentModel) throws MalformedURLException {
        String objectId = this.getOldVersionDocumentId(this.url);
        Document oldDoc = (Document)this.connection.getResourceController(this.urlWithoutContextId).getCmisObj(objectId);
        String language = webappPluginWorkspace.getUserInterfaceLanguage();
        SimpleDateFormat df = new SimpleDateFormat("d MMM yyyy HH:mm:ss", new Locale(language));
        Date lastMod = oldDoc.getLastModificationDate().getTime();
        documentModel.getAuthorAccess().getEditorAccess().setReadOnly(new ReadOnlyReason(this.rb.getMessage("Old_ver_warning") + " : " + df.format(lastMod)));
        AuthorDocumentController controller = documentModel.getAuthorDocumentController();
        AuthorElement rootElement = controller.getAuthorDocumentNode().getRootElement();
        controller.setPseudoClass(EditorOption.OLD_VERSION.getValue(), rootElement);
        if (oldDoc.getCheckinComment() != null) {
            controller.setPseudoClass(EditorOption.SUPPORTS_COMMIT_MESSAGE.getValue(), rootElement);
        }
    }

    private String getOldVersionDocumentId(URL url) {
        HashMap<String, String> queryPart = new HashMap<String, String>();
        for (String pair : url.getQuery().split("&")) {
            int index = pair.indexOf(61);
            queryPart.put(pair.substring(0, index), pair.substring(index + 1));
        }
        return (String)queryPart.get(EditorOption.OLD_VERSION.getValue());
    }

    public static boolean isCheckOutRequired() {
        WSOptionsStorage optionsStorage = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage();
        String optionValue = optionsStorage.getOption("cmis.checkout_required", "on");
        return "on".equals(optionValue);
    }

    public boolean applicationClosing() {
        return true;
    }
}

