/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.cmis.web;

import com.oxygenxml.cmis.core.CmisCredentials;
import com.oxygenxml.cmis.core.UserCredentials;
import java.util.Optional;
import ro.sync.ecss.extensions.api.webapp.SessionStore;
import ro.sync.ecss.extensions.api.webapp.access.WebappPluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.options.WSOptionsStorage;

public class CredentialsManager {
    private static final String CMIS_SERVICE_PASSWORD_PROP = "cmis.service.password";
    private static final String CMIS_SERVICE_USER_PROP = "cmis.service.user";
    private static final String WA_CMIS_PLUGIN_CREDENTIALS_KEY = "wa-cmis-plugin-credentials";
    public static final CredentialsManager INSTANCE = new CredentialsManager();
    private final SessionStore sessionStore;
    private final Optional<CmisCredentials> serviceAccount;

    private CredentialsManager() {
        PluginWorkspace pluginWorkspace = PluginWorkspaceProvider.getPluginWorkspace();
        this.sessionStore = ((WebappPluginWorkspace)pluginWorkspace).getSessionStore();
        this.serviceAccount = this.loadServiceAccount(pluginWorkspace);
    }

    private Optional<CmisCredentials> loadServiceAccount(PluginWorkspace pluginWorkspace) {
        WSOptionsStorage optionsStorage = pluginWorkspace.getOptionsStorage();
        String cmisUser = Optional.ofNullable(System.getProperty(CMIS_SERVICE_USER_PROP)).orElse(optionsStorage.getOption(CMIS_SERVICE_USER_PROP, null));
        String cmisPassword = Optional.ofNullable(System.getProperty(CMIS_SERVICE_PASSWORD_PROP)).orElse(optionsStorage.getOption(CMIS_SERVICE_PASSWORD_PROP, null));
        if (cmisUser != null && cmisPassword != null) {
            return Optional.of(new UserCredentials(cmisUser, cmisPassword));
        }
        return Optional.empty();
    }

    public CmisCredentials getCredentials(String sessionId) {
        return this.serviceAccount.orElseGet(() -> (CmisCredentials)this.sessionStore.get(sessionId, WA_CMIS_PLUGIN_CREDENTIALS_KEY));
    }

    public void setCredentials(String sessionId, CmisCredentials creds) {
        this.sessionStore.put(sessionId, WA_CMIS_PLUGIN_CREDENTIALS_KEY, (Object)creds);
    }

    public void forgetUserCredentials(String sessionId) {
        this.sessionStore.remove(sessionId, WA_CMIS_PLUGIN_CREDENTIALS_KEY);
    }

    public boolean hasServiceAccount() {
        return this.serviceAccount.isPresent();
    }
}

