/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.cmis.web;

import com.oxygenxml.cmis.core.CMISAccess;
import com.oxygenxml.cmis.core.CmisCredentials;
import com.oxygenxml.cmis.core.CmisURL;
import com.oxygenxml.cmis.core.urlhandler.CmisURLConnection;
import com.oxygenxml.cmis.web.CmisBrowsingURLConnection;
import com.oxygenxml.cmis.web.CredentialsManager;
import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.ecss.extensions.api.webapp.WebappMessage;
import ro.sync.ecss.extensions.api.webapp.plugin.URLStreamHandlerWithContext;
import ro.sync.ecss.extensions.api.webapp.plugin.UserActionRequiredException;

public class CmisStreamHandler
extends URLStreamHandlerWithContext {
    private static final Logger log = LoggerFactory.getLogger(CmisStreamHandler.class);

    protected URLConnection openConnectionInContext(String contextId, URL url, Proxy proxy) throws IOException {
        CmisCredentials credentials = CredentialsManager.INSTANCE.getCredentials(contextId);
        CMISAccess cmisAccess = new CMISAccess();
        CmisURLConnection cuc = new CmisURLConnection(url, cmisAccess, credentials);
        URL serverUrl = CmisURL.parseServerUrl((String)url.toExternalForm());
        log.info("Server URL: " + serverUrl.toExternalForm());
        boolean isUserValid = true;
        if (credentials != null && !credentials.isEmpty()) {
            try {
                cmisAccess.pureConnectToServer(serverUrl, credentials);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                isUserValid = false;
            }
        } else {
            isUserValid = false;
        }
        if (!isUserValid) {
            WebappMessage webappMessage = new WebappMessage(2, "401", "Invalid username or password!", true);
            throw new UserActionRequiredException(webappMessage);
        }
        return new CmisBrowsingURLConnection((URLConnection)cuc, serverUrl);
    }
}

