/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.cmis.web;

import com.google.common.annotations.VisibleForTesting;
import com.oxygenxml.cmis.core.CmisCredentials;
import com.oxygenxml.cmis.core.CmisURL;
import com.oxygenxml.cmis.core.RepositoryInfo;
import com.oxygenxml.cmis.core.ResourceController;
import com.oxygenxml.cmis.core.TokenCredentials;
import com.oxygenxml.cmis.core.UserCredentials;
import com.oxygenxml.cmis.core.urlhandler.CmisURLConnection;
import com.oxygenxml.cmis.web.action.CmisActionsUtills;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.FileableCmisObject;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.Repository;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUnauthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.ecss.extensions.api.webapp.WebappMessage;
import ro.sync.ecss.extensions.api.webapp.plugin.FilterURLConnection;
import ro.sync.ecss.extensions.api.webapp.plugin.UserActionRequiredException;
import ro.sync.net.protocol.FolderEntryDescriptor;

public class CmisBrowsingURLConnection
extends FilterURLConnection {
    private static final Logger log = LoggerFactory.getLogger(CmisBrowsingURLConnection.class);
    private static final String ERROR_MESSAGE = "Invalid username or password!";
    private static final String ERROR_CODE = "401";
    private CmisURLConnection connection;
    private URL serverUrl;

    public CmisBrowsingURLConnection(URLConnection delegateConnection, URL serverUrl) {
        super(delegateConnection);
        this.connection = (CmisURLConnection)delegateConnection;
        this.serverUrl = serverUrl;
    }

    public InputStream getInputStream() throws IOException {
        try {
            Optional<String> objectIdOpt = CmisActionsUtills.getVersionId(this.url);
            if (objectIdOpt.isPresent()) {
                log.debug("Old ver. InputStream.");
                return this.getOlderVersionInputStream(objectIdOpt.get());
            }
            return super.getInputStream();
        }
        catch (CmisUnauthorizedException e) {
            WebappMessage webappMessage = new WebappMessage(2, ERROR_CODE, ERROR_MESSAGE, true);
            throw new UserActionRequiredException(webappMessage);
        }
        catch (CmisObjectNotFoundException e) {
            throw new FileNotFoundException(e.getMessage());
        }
    }

    private InputStream getOlderVersionInputStream(String objectId) throws IOException {
        String connectionUrl = this.url.toExternalForm().replace(this.url.getQuery(), "");
        connectionUrl = connectionUrl.replace("?", "");
        Document document = (Document)this.connection.getResourceController(connectionUrl).getCmisObj(objectId);
        return this.getVersionInputStream(document, objectId);
    }

    private InputStream getVersionInputStream(Document document, String objectId) throws IOException {
        String contentUrl = document.getContentUrl();
        boolean isSharePoint = this.connection.getCMISAccess().isSharePoint();
        if (isSharePoint && contentUrl.contains("objectID=")) {
            contentUrl = contentUrl.replaceAll("objectID=[^&]+", "objectID=" + objectId);
            URL conn = new URL(contentUrl);
            CmisCredentials credentials = this.connection.getUserCredentials();
            URLConnection uc = conn.openConnection();
            if (credentials instanceof UserCredentials) {
                UserCredentials userCredentials = (UserCredentials)credentials;
                String userpass = userCredentials.getUsername() + ":" + userCredentials.getPassword();
                String basicAuth = "Basic " + new String(Base64.getEncoder().encode(userpass.getBytes()));
                uc.setRequestProperty("Authorization", basicAuth);
            } else {
                TokenCredentials tokenCredentials = (TokenCredentials)credentials;
                String basicAuth = "Basic " + new String(Base64.getEncoder().encode(tokenCredentials.getToken().getBytes()));
                uc.setRequestProperty("Authorization", basicAuth);
            }
            return uc.getInputStream();
        }
        return document.getContentStream().getStream();
    }

    public OutputStream getOutputStream() throws IOException {
        try {
            return super.getOutputStream();
        }
        catch (CmisUnauthorizedException e) {
            WebappMessage webappMessage = new WebappMessage(2, ERROR_CODE, ERROR_MESSAGE, true);
            throw new UserActionRequiredException(webappMessage);
        }
    }

    public List<FolderEntryDescriptor> listFolder() throws IOException {
        List<FolderEntryDescriptor> list = null;
        try {
            list = this.url.getPath().isEmpty() || this.url.getPath().equals("/") ? this.getRootFolderEntriesDescriptiors() : this.getFolderEntriesDescriptiors();
        }
        catch (CmisUnauthorizedException e) {
            WebappMessage webappMessage = new WebappMessage(2, ERROR_CODE, ERROR_MESSAGE, true);
            throw new UserActionRequiredException(webappMessage);
        }
        catch (CmisObjectNotFoundException e) {
            throw new FileNotFoundException(this.url.getPath());
        }
        return list;
    }

    @VisibleForTesting
    public List<FolderEntryDescriptor> getFolderEntriesDescriptiors() throws MalformedURLException {
        ArrayList<FolderEntryDescriptor> list = new ArrayList<FolderEntryDescriptor>();
        FileableCmisObject parent = null;
        parent = (FileableCmisObject)this.connection.getCMISObject(this.url.toExternalForm());
        String externalForm = this.url.toExternalForm();
        ResourceController resourceController = this.connection.getResourceController(externalForm);
        Folder folder = (Folder)parent;
        for (CmisObject obj : folder.getChildren()) {
            Document doc;
            Boolean isPrivateWorkingCopy;
            if (obj instanceof Document && ((isPrivateWorkingCopy = (doc = (Document)obj).isPrivateWorkingCopy()) != null && isPrivateWorkingCopy.booleanValue() || isPrivateWorkingCopy == null && this.checkPWCForAlfresco(doc))) continue;
            String entryUrl = CmisURLConnection.generateURLObject((Folder)folder, (CmisObject)obj, (ResourceController)resourceController);
            list.add(new FolderEntryDescriptor(entryUrl));
        }
        return list;
    }

    private boolean checkPWCForAlfresco(Document doc) {
        Boolean isVersionSeriesPWC = doc.isVersionSeriesPrivateWorkingCopy();
        return isVersionSeriesPWC != null && isVersionSeriesPWC != false;
    }

    @VisibleForTesting
    public List<FolderEntryDescriptor> getRootFolderEntriesDescriptiors() {
        ArrayList<FolderEntryDescriptor> list = new ArrayList<FolderEntryDescriptor>();
        List reposList = this.connection.getCMISAccess().connectToServerGetRepositories(this.serverUrl, this.connection.getUserCredentials());
        for (Repository repos : reposList) {
            String reposUrl = this.getRepositoryUrl(repos);
            list.add(new FolderEntryDescriptor(reposUrl));
        }
        return list;
    }

    private String getRepositoryUrl(Repository repo) {
        this.connection.getCMISAccess().connectToRepo(this.serverUrl, repo.getId(), this.connection.getUserCredentials());
        String atomPubUrlStr = (String)this.connection.getCMISAccess().getSession().getSessionParameters().get("org.apache.chemistry.opencmis.binding.atompub.url");
        try {
            return CmisURL.ofRepoWithName((URL)new URL(atomPubUrlStr), (RepositoryInfo)new RepositoryInfo(repo.getId(), repo.getName())).toExternalForm();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

