/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.cmis.web;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.oxygenxml.cmis.web.AlfrescoPeople;
import com.oxygenxml.cmis.web.AlfrescoPeopleEntry;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Base64;

public class AlfrescoApi {
    private URL apiBaseUrl;

    public AlfrescoApi(URL cmisatomUrl) {
        try {
            this.apiBaseUrl = new URL(cmisatomUrl, "api/-default-/public/alfresco/versions/1/");
        }
        catch (MalformedURLException e) {
            throw new UncheckedIOException(e);
        }
    }

    public AlfrescoPeople getMe(String alfrescoTicket) throws IOException {
        URL peopleMeApi = new URL(this.apiBaseUrl, "./people/-me-");
        URLConnection connection = peopleMeApi.openConnection();
        String encodedToken = new String(Base64.getEncoder().encode(alfrescoTicket.getBytes()));
        connection.setRequestProperty("Authorization", "Basic " + encodedToken);
        try (InputStream is = connection.getInputStream();){
            AlfrescoPeopleEntry peopleEntry = (AlfrescoPeopleEntry)new ObjectMapper().readValue(is, AlfrescoPeopleEntry.class);
            AlfrescoPeople alfrescoPeople = peopleEntry.getEntry();
            return alfrescoPeople;
        }
    }
}

