/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.examples.webdav;

import com.oxygenxml.examples.webdav.CredentialsStore;
import com.oxygenxml.examples.webdav.WebdavUrlConnection;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.URLUtil;
import ro.sync.ecss.extensions.api.webapp.plugin.URLStreamHandlerWithContext;

public class WebdavUrlStreamHandler
extends URLStreamHandlerWithContext {
    private static final Logger log = LoggerFactory.getLogger(WebdavUrlStreamHandler.class);

    public static String computeServerId(String serverUrl) {
        log.debug("Server for which to compute the serverID :" + serverUrl);
        String serverId = null;
        try {
            URL url = new URL(serverUrl);
            serverId = url.getProtocol() + url.getHost() + url.getPort();
        }
        catch (MalformedURLException e) {
            log.error("Malformed url in computeServerId", (Throwable)e);
        }
        log.debug("serverID :" + serverId);
        return serverId;
    }

    protected URLConnection openConnectionInContext(String contextId, URL url, Proxy proxy) throws IOException {
        URL completeUrl = WebdavUrlStreamHandler.addCredentials(contextId, url);
        URLConnection urlConnection = completeUrl.openConnection();
        return new WebdavUrlConnection(contextId, urlConnection);
    }

    static URL addCredentials(String sessionId, URL url) {
        PasswordAuthentication userCredentials = CredentialsStore.get(sessionId, WebdavUrlStreamHandler.computeServerId(url.toExternalForm()));
        String protocol = url.getProtocol().substring("webdav-".length());
        StringBuilder completeUrl = new StringBuilder();
        completeUrl.append(protocol).append("://");
        if (userCredentials != null && userCredentials.getPassword().length > 0) {
            String encodedUserName = URLUtil.encodeURIComponent((String)userCredentials.getUserName());
            String encodedPasswd = URLUtil.encodeURIComponent((String)new String(userCredentials.getPassword()));
            completeUrl.append(encodedUserName).append(":").append(encodedPasswd).append("@");
        } else if (url.getUserInfo() != null) {
            completeUrl.append(url.getUserInfo()).append("@");
        }
        completeUrl.append(url.getHost());
        if (url.getPort() != -1) {
            completeUrl.append(":").append(url.getPort());
        }
        completeUrl.append(url.getPath());
        if (url.getQuery() != null) {
            completeUrl.append("?").append(url.getQuery());
        }
        if (url.getRef() != null) {
            completeUrl.append("#").append(url.getRef());
        }
        log.debug("HTTP URL with credentials: " + completeUrl.toString());
        try {
            return new URL(completeUrl.toString());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

