/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.examples.webdav;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Uninterruptibles;
import com.oxygenxml.examples.webdav.WebdavUrlStreamHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import ro.sync.basic.util.URLUtil;
import ro.sync.ecss.extensions.api.webapp.plugin.ServletPluginExtension;
import ro.sync.ecss.extensions.api.webapp.plugin.servlet.ServletException;
import ro.sync.ecss.extensions.api.webapp.plugin.servlet.http.HttpServletRequest;
import ro.sync.ecss.extensions.api.webapp.plugin.servlet.http.HttpServletResponse;
import ro.sync.net.protocol.http.HttpExceptionWithDetails;

public class WebdavUrlInfo
extends ServletPluginExtension {
    private static final Logger log = LoggerFactory.getLogger(WebdavUrlInfo.class);
    private static final int SERVER_ROOT_COMPUTATION_ALLOCATION = 3;

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        URL url = new URL(req.getParameter("url"));
        String sessionId = req.getSession().getId();
        URL urlWithCredentials = WebdavUrlStreamHandler.addCredentials(sessionId, url);
        ResourceType resourceType = null;
        String errorMessage = null;
        try {
            resourceType = WebdavUrlInfo.getResourceType(urlWithCredentials);
        }
        catch (IOException e) {
            if (e.getMessage().indexOf("401") != -1) {
                String userInfo = urlWithCredentials.getUserInfo();
                if (userInfo != null && !userInfo.isEmpty()) {
                    String user = URLUtil.extractUser((String)userInfo);
                    String password = URLUtil.extractPassword((String)userInfo);
                    if (user != null && !user.trim().isEmpty() && password != null && !password.trim().isEmpty()) {
                        log.warn("Failed login attempt of user " + user + " for " + URLUtil.getDescription((URL)url));
                    }
                }
                resp.sendError(401);
                return;
            }
            errorMessage = e.getMessage();
        }
        String rootUrl = this.getRootUrl(urlWithCredentials);
        rootUrl = URLUtil.clearUserInfo((URL)new URL(rootUrl)).toExternalForm();
        ImmutableMap info = errorMessage == null ? ImmutableMap.of((Object)"type", (Object)resourceType.toString(), (Object)"rootUrl", (Object)rootUrl) : ImmutableMap.of((Object)"errorMessage", (Object)errorMessage);
        new ObjectMapper().writeValue((OutputStream)resp.getOutputStream(), (Object)info);
    }

    private String getRootUrl(final URL urlWithCredentials) {
        final AtomicReference<String> foundRoot = new AtomicReference<String>(urlWithCredentials.toExternalForm());
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                String candidateRoot = urlWithCredentials.getProtocol() + "://" + urlWithCredentials.getAuthority();
                Object[] pathParts = urlWithCredentials.getPath().split("/");
                if (log.isDebugEnabled()) {
                    log.debug(Arrays.toString(pathParts));
                }
                for (Object pathPart : pathParts) {
                    if (Thread.interrupted()) {
                        log.debug("Time's up searching for server root URL");
                        break;
                    }
                    candidateRoot = candidateRoot + (String)pathPart + "/";
                    foundRoot.set(candidateRoot);
                    ResourceType candidateResourceType = ResourceType.NON_WEBDAV;
                    try {
                        candidateResourceType = WebdavUrlInfo.getResourceType(new URL(candidateRoot));
                    }
                    catch (IOException e) {
                        log.debug((Object)e, (Throwable)e);
                    }
                    if (candidateResourceType != ResourceType.COLLECTION) continue;
                    log.debug("Found server root URL: " + candidateRoot);
                    break;
                }
            }
        });
        thread.start();
        Uninterruptibles.joinUninterruptibly((Thread)thread, (long)3L, (TimeUnit)TimeUnit.SECONDS);
        if (thread.isAlive()) {
            log.warn("Did not manage to determine the server root in the allocated time.");
            thread.interrupt();
        }
        return foundRoot.get();
    }

    private static ResourceType getResourceType(URL urlWithCredentials) throws IOException {
        Document doc;
        DocumentBuilder builder;
        ResourceType resourceType = ResourceType.NON_WEBDAV;
        HttpURLConnection conn = (HttpURLConnection)urlWithCredentials.openConnection();
        conn.setRequestMethod("PROPFIND");
        conn.setRequestProperty("Depth", "0");
        conn.setDoInput(true);
        conn.setDoOutput(true);
        String reqBody = "<?xml version=\"1.0\"?>\r\n<a:propfind xmlns:a=\"DAV:\">\r\n<a:prop><a:resourcetype/></a:prop>\r\n</a:propfind>";
        try (OutputStream outputStream = conn.getOutputStream();){
            outputStream.write(reqBody.getBytes());
        }
        catch (HttpExceptionWithDetails e) {
            URL urlToDisplay = URLUtil.clearUserInfo((String)urlWithCredentials.toExternalForm());
            log.debug("Resource type could not be determined for " + urlToDisplay + ": " + e.getReasonCode() + " - " + e.getReason());
            throw e;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IOException("Error creating parser", e);
        }
        InputStream inputStream = conn.getInputStream();
        try {
            doc = builder.parse(inputStream);
        }
        catch (SAXException e) {
            throw new IOException("Error parsing server response", e);
        }
        NodeList resourceTypes = doc.getElementsByTagNameNS("DAV:", "resourcetype");
        if (resourceTypes.getLength() == 1) {
            resourceType = ResourceType.FILE;
            Element resourceTypeElement = (Element)resourceTypes.item(0);
            NodeList collections = resourceTypeElement.getElementsByTagNameNS("DAV:", "collection");
            if (collections.getLength() == 1) {
                resourceType = ResourceType.COLLECTION;
            }
        }
        return resourceType;
    }

    public String getPath() {
        return "webdav-url-info";
    }

    public static enum ResourceType {
        NON_WEBDAV,
        COLLECTION,
        FILE;

    }
}

