/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.examples.webdav;

import com.google.common.io.Closeables;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.URLUtil;
import ro.sync.ecss.extensions.api.webapp.WebappMessage;
import ro.sync.ecss.extensions.api.webapp.access.WebappPluginWorkspace;
import ro.sync.ecss.extensions.api.webapp.plugin.FilterURLConnection;
import ro.sync.ecss.extensions.api.webapp.plugin.UserActionRequiredException;
import ro.sync.exml.plugin.urlstreamhandler.CacheableUrlConnection;
import ro.sync.exml.workspace.api.PluginResourceBundle;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.net.protocol.FolderEntryDescriptor;
import ro.sync.net.protocol.http.WebdavLockHelper;

public class WebdavUrlConnection
extends FilterURLConnection
implements CacheableUrlConnection {
    private static final Logger log = LoggerFactory.getLogger(WebdavUrlConnection.class);
    private String contextId;

    protected WebdavUrlConnection(String contextId, URLConnection delegate) {
        super(delegate);
        this.contextId = contextId;
    }

    public void connect() throws IOException {
        try {
            super.connect();
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    public InputStream getInputStream() throws IOException {
        try {
            return super.getInputStream();
        }
        catch (IOException e) {
            this.handleException(e);
            return null;
        }
    }

    public OutputStream getOutputStream() throws IOException {
        new WebdavLockHelper().addLockHeader(this.contextId, (HttpURLConnection)this.delegateConnection);
        this.addRequestProperty("X-Requested-With", "WA");
        try {
            return new FilterOutputStream(super.getOutputStream()){

                @Override
                public void close() throws IOException {
                    try {
                        super.close();
                        URLUtil.disconnect((URLConnection)WebdavUrlConnection.this.delegateConnection);
                    }
                    catch (IOException e) {
                        WebdavUrlConnection.this.handleException(e);
                    }
                }
            };
        }
        catch (IOException e) {
            this.handleException(e);
            return null;
        }
    }

    private void handleException(IOException e) throws UserActionRequiredException, IOException {
        if (e.getMessage().indexOf("401") != -1) {
            URL url = this.delegateConnection.getURL();
            String userInfo = url.getUserInfo();
            if (userInfo != null && !userInfo.isEmpty()) {
                String user = URLUtil.extractUser((String)userInfo);
                String password = URLUtil.extractPassword((String)userInfo);
                if (user != null && !user.trim().isEmpty() && password != null && !password.trim().isEmpty()) {
                    log.warn("Failed login attempt of user " + user + " for " + URLUtil.getDescription((URL)url));
                }
            }
            log.debug("WebDAV not authorized exception " + e.getMessage());
            PluginResourceBundle rb = ((WebappPluginWorkspace)PluginWorkspaceProvider.getPluginWorkspace()).getResourceBundle();
            throw new UserActionRequiredException(new WebappMessage(3, rb.getMessage("CONNECT_"), this.delegateConnection.getURL().toExternalForm(), true));
        }
        if (this.delegateConnection instanceof HttpURLConnection) {
            String serverMessage = null;
            InputStream errorStream = null;
            try {
                errorStream = ((HttpURLConnection)this.delegateConnection).getErrorStream();
                serverMessage = IOUtils.toString((InputStream)errorStream);
            }
            catch (Exception ex) {
                Closeables.closeQuietly(errorStream);
            }
            if (this.shouldDisplayServerMessage(serverMessage)) {
                throw new IOException(serverMessage, e);
            }
        }
        throw e;
    }

    public List<FolderEntryDescriptor> listFolder() throws IOException {
        try {
            return super.listFolder();
        }
        catch (IOException e) {
            this.handleException(e);
            return null;
        }
    }

    private boolean shouldDisplayServerMessage(String serverMessage) {
        if (serverMessage == null) {
            return false;
        }
        if (serverMessage.contains("<body") || serverMessage.contains("</body")) {
            return false;
        }
        return !serverMessage.contains("<?xml");
    }
}

