/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.examples.webdav;

import java.util.HashMap;
import ro.sync.ecss.extensions.api.webapp.access.WebappPluginWorkspace;
import ro.sync.ecss.extensions.api.webapp.plugin.ServletPluginConfigExtension;
import ro.sync.ecss.extensions.api.webapp.plugin.servlet.ServletException;
import ro.sync.exml.workspace.api.PluginResourceBundle;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;

public class WebdavPluginConfigExtension
extends ServletPluginConfigExtension {
    private static final String defaultAutoSaveInterval = "5";
    static final String LOCKING_ENABLED = "webdav.lock_on_open";
    static final String ENFORCED_URL = "webdav.enforced_url";
    private static final String HIDE_CONNECTOR_TAB = "webdav.hide_connector_tab";
    static final String AUTOSAVE_INTERVAL = "webdav.autosave_interval";

    public void init() throws ServletException {
        super.init();
        HashMap<String, String> defaultOptions = new HashMap<String, String>();
        defaultOptions.put(LOCKING_ENABLED, "on");
        defaultOptions.put(ENFORCED_URL, "");
        defaultOptions.put(AUTOSAVE_INTERVAL, defaultAutoSaveInterval);
        this.setDefaultOptions(defaultOptions);
    }

    public String getPath() {
        return "webdav-config";
    }

    public String getOptionsForm() {
        String optionValue = this.getOption(LOCKING_ENABLED, "on");
        boolean isLockEnabled = "on".equals(optionValue);
        String enforcedUrl = this.getOption(ENFORCED_URL, "");
        String autosaveInterval = this.getOption(AUTOSAVE_INTERVAL, defaultAutoSaveInterval);
        StringBuilder optionsForm = new StringBuilder();
        PluginResourceBundle rb = ((WebappPluginWorkspace)PluginWorkspaceProvider.getPluginWorkspace()).getResourceBundle();
        optionsForm.append("<div style='font-family:robotolight, Arial, Helvetica, sans-serif;font-size:0.85em;font-weight: lighter'>").append("<form style='text-align:left;line-height: 1.7em;'>");
        optionsForm.append("<label style='margin-bottom:6px;overflow:hidden'>").append("<input name='").append(LOCKING_ENABLED).append("' type=\"checkbox\" value=\"on\"").append(isLockEnabled ? "checked" : "").append("> ").append(rb.getMessage("Lock_resources_on_open")).append("</label>");
        optionsForm.append("<label style='margin-top:6px;display:block;overflow:hidden'>").append(rb.getMessage("Autosave_interval")).append(": ").append("<input min='0' value='").append(autosaveInterval).append("'name='").append(AUTOSAVE_INTERVAL).append("' type='number'").append("style='width: 50px;text-align:center;'/>").append(" ").append(rb.getMessage("Seconds")).append("</label>");
        optionsForm.append("<label style='margin-top:6px;display:block;'>").append(rb.getMessage("Enforced_server")).append(": ").append("<input placeholder='").append(rb.getMessage("Server_URL")).append("' name='").append(ENFORCED_URL).append("' type='text' style='color:#606060;background-color:#FAFAFA;").append("-webkit-box-sizing: border-box;-moz-box-sizing: border-box;box-sizing: border-box;display: inline-block;").append("width:75%;border-radius:4px;border:1px solid #E4E4E4;padding:6px 4px' value='").append(enforcedUrl).append("'/>").append("</label>");
        optionsForm.append("<div style='background-color: lightyellow;border: 1px solid #dadab4; padding: 8px;margin-top: 5px;'>").append(rb.getMessage("Enforced_server_note")).append("</div>");
        optionsForm.append("</form>").append("</div>");
        return optionsForm.toString();
    }

    public String getOptionsJson() {
        return "{\"hide_connector_tab\":\"" + this.getOption(HIDE_CONNECTOR_TAB, "") + "\",\"webdav_autosave_interval\":\"" + this.getOption(AUTOSAVE_INTERVAL, defaultAutoSaveInterval) + "\",\"enforced_webdav_server\":\"" + this.getOption(ENFORCED_URL, "") + "\",\"lock_on_open\":\"" + this.getOption(LOCKING_ENABLED, "on") + "\"}";
    }
}

